/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class FontTexture
extends AbstractTexture {
    private static final int SIZE = 256;
    private final ResourceLocation name;
    private final RenderType normalType;
    private final RenderType seeThroughType;
    private final RenderType polygonOffsetType;
    private final boolean colored;
    private final Node root;

    public FontTexture(ResourceLocation pName, boolean pColored) {
        this.name = pName;
        this.colored = pColored;
        this.root = new Node(0, 0, 256, 256);
        TextureUtil.prepareImage(pColored ? NativeImage.InternalGlFormat.RGBA : NativeImage.InternalGlFormat.RED, this.getId(), 256, 256);
        this.normalType = pColored ? RenderType.text(pName) : RenderType.textIntensity(pName);
        this.seeThroughType = pColored ? RenderType.textSeeThrough(pName) : RenderType.textIntensitySeeThrough(pName);
        this.polygonOffsetType = pColored ? RenderType.textPolygonOffset(pName) : RenderType.textIntensityPolygonOffset(pName);
    }

    @Override
    public void load(ResourceManager pManager) {
    }

    @Override
    public void close() {
        this.releaseId();
    }

    @Nullable
    public BakedGlyph add(RawGlyph pGlyphInfo) {
        if (pGlyphInfo.isColored() != this.colored) {
            return null;
        }
        Node fonttexture$node = this.root.insert(pGlyphInfo);
        if (fonttexture$node != null) {
            this.bind();
            pGlyphInfo.upload(fonttexture$node.x, fonttexture$node.y);
            float f = 256.0f;
            float f1 = 256.0f;
            float f2 = 0.01f;
            return new BakedGlyph(this.normalType, this.seeThroughType, this.polygonOffsetType, ((float)fonttexture$node.x + 0.01f) / 256.0f, ((float)fonttexture$node.x - 0.01f + (float)pGlyphInfo.getPixelWidth()) / 256.0f, ((float)fonttexture$node.y + 0.01f) / 256.0f, ((float)fonttexture$node.y - 0.01f + (float)pGlyphInfo.getPixelHeight()) / 256.0f, pGlyphInfo.getLeft(), pGlyphInfo.getRight(), pGlyphInfo.getUp(), pGlyphInfo.getDown());
        }
        return null;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    static class Node {
        final int x;
        final int y;
        private final int width;
        private final int height;
        @Nullable
        private Node left;
        @Nullable
        private Node right;
        private boolean occupied;

        Node(int pX, int pY, int pWidth, int pHeight) {
            this.x = pX;
            this.y = pY;
            this.width = pWidth;
            this.height = pHeight;
        }

        @Nullable
        Node insert(RawGlyph p_95124_) {
            if (this.left != null && this.right != null) {
                Node fonttexture$node = this.left.insert(p_95124_);
                if (fonttexture$node == null) {
                    fonttexture$node = this.right.insert(p_95124_);
                }
                return fonttexture$node;
            }
            if (this.occupied) {
                return null;
            }
            int i = p_95124_.getPixelWidth();
            int j = p_95124_.getPixelHeight();
            if (i <= this.width && j <= this.height) {
                if (i == this.width && j == this.height) {
                    this.occupied = true;
                    return this;
                }
                int k = this.width - i;
                int l = this.height - j;
                if (k > l) {
                    this.left = new Node(this.x, this.y, i, this.height);
                    this.right = new Node(this.x + i + 1, this.y, this.width - i - 1, this.height);
                } else {
                    this.left = new Node(this.x, this.y, this.width, j);
                    this.right = new Node(this.x, this.y + j + 1, this.width, this.height - j - 1);
                }
                return this.left.insert(p_95124_);
            }
            return null;
        }
    }
}

