/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.optifine.util.FontUtils;
import org.slf4j.Logger;

public class BitmapProvider
implements GlyphProvider {
    static final Logger LOGGER = LogUtils.getLogger();
    private final NativeImage image;
    private final Int2ObjectMap<Glyph> glyphs;
    private boolean blend = false;
    private float widthSpace = -1.0f;

    BitmapProvider(NativeImage pImage, Int2ObjectMap<Glyph> pGlyphs) {
        this.image = pImage;
        this.glyphs = pGlyphs;
    }

    @Override
    public void close() {
        this.image.close();
    }

    @Override
    @Nullable
    public RawGlyph getGlyph(int pCharacter) {
        return (RawGlyph)this.glyphs.get(pCharacter);
    }

    @Override
    public IntSet getSupportedGlyphs() {
        return IntSets.unmodifiable((IntSet)this.glyphs.keySet());
    }

    public boolean isBlend() {
        return this.blend;
    }

    public float getWidthSpace() {
        return this.widthSpace;
    }

    public static class Builder
    implements GlyphProviderBuilder {
        private ResourceLocation texture;
        private final List<int[]> chars;
        private final int height;
        private final int ascent;

        public Builder(ResourceLocation p_95349_, int p_95350_, int p_95351_, List<int[]> p_95352_) {
            this.texture = new ResourceLocation(p_95349_.getNamespace(), "textures/" + p_95349_.getPath());
            this.texture = FontUtils.getHdFontLocation(this.texture);
            this.chars = p_95352_;
            this.height = p_95350_;
            this.ascent = p_95351_;
        }

        public static Builder fromJson(JsonObject pJson) {
            int i = GsonHelper.getAsInt(pJson, "height", 8);
            int j = GsonHelper.getAsInt(pJson, "ascent");
            if (j > i) {
                throw new JsonParseException("Ascent " + j + " higher than height " + i);
            }
            ArrayList list = Lists.newArrayList();
            JsonArray jsonarray = GsonHelper.getAsJsonArray(pJson, "chars");
            int k = 0;
            while (k < jsonarray.size()) {
                int l;
                String s = GsonHelper.convertToString(jsonarray.get(k), "chars[" + k + "]");
                int[] aint = s.codePoints().toArray();
                if (k > 0 && aint.length != (l = ((int[])list.get(0)).length)) {
                    throw new JsonParseException("Elements of chars have to be the same length (found: " + aint.length + ", expected: " + l + "), pad with space or \\u0000");
                }
                list.add(aint);
                ++k;
            }
            if (!list.isEmpty() && ((int[])list.get(0)).length != 0) {
                return new Builder(new ResourceLocation(GsonHelper.getAsString(pJson, "file")), i, j, list);
            }
            throw new JsonParseException("Expected to find data in chars, found none.");
        }

        @Override
        @Nullable
        public GlyphProvider create(ResourceManager pResourceManager) {
            try {
                BitmapProvider bitmapprovider;
                try (Resource resource = pResourceManager.getResource(this.texture);){
                    NativeImage nativeimage = NativeImage.read(NativeImage.Format.RGBA, resource.getInputStream());
                    int i = nativeimage.getWidth();
                    int j = nativeimage.getHeight();
                    int k = i / this.chars.get(0).length;
                    int l = j / this.chars.size();
                    float f = (float)this.height / (float)l;
                    Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
                    Properties properties = FontUtils.readFontProperties(this.texture);
                    Int2ObjectMap<Float> int2objectmap1 = FontUtils.readCustomCharWidths(properties);
                    Float f1 = (Float)int2objectmap1.get(32);
                    boolean flag = FontUtils.readBoolean(properties, "blend", false);
                    float f2 = FontUtils.readFloat(properties, "offsetBold", -1.0f);
                    if (f2 < 0.0f) {
                        f2 = k > 8 ? 0.5f : 1.0f;
                    }
                    int i1 = 0;
                    while (i1 < this.chars.size()) {
                        int j1 = 0;
                        int[] nArray = this.chars.get(i1);
                        int n = nArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int k1 = nArray[n2];
                            int l1 = j1++;
                            if (k1 != 0 && k1 != 32) {
                                Glyph bitmapprovider$glyph;
                                float f3 = this.getActualGlyphWidth(nativeimage, k, l, l1, i1);
                                Float f4 = (Float)int2objectmap1.get(k1);
                                if (f4 != null) {
                                    f3 = f4.floatValue() * ((float)k / 8.0f);
                                }
                                if ((bitmapprovider$glyph = (Glyph)int2objectmap.put(k1, (Object)new Glyph(f, nativeimage, l1 * k, i1 * l, k, l, (int)(0.5 + (double)(f3 * f)) + 1, this.ascent))) != null) {
                                    LOGGER.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(k1), (Object)this.texture);
                                }
                                Glyph bitmapprovider$glyph1 = (Glyph)int2objectmap.get(k1);
                                bitmapprovider$glyph1.offsetBold = f2;
                            }
                            ++n2;
                        }
                        ++i1;
                    }
                    bitmapprovider = new BitmapProvider(nativeimage, (Int2ObjectMap<Glyph>)int2objectmap);
                    bitmapprovider.blend = flag;
                    if (f1 != null) {
                        bitmapprovider.widthSpace = f1.floatValue();
                    }
                }
                return bitmapprovider;
            }
            catch (IOException ioexception1) {
                throw new RuntimeException(ioexception1.getMessage());
            }
        }

        private int getActualGlyphWidth(NativeImage pNativeImage, int pCharWidth, int pCharHeightInsp, int pColumn, int pRow) {
            int i = pCharWidth - 1;
            while (i >= 0) {
                int j = pColumn * pCharWidth + i;
                int k = 0;
                while (k < pCharHeightInsp) {
                    int l = pRow * pCharHeightInsp + k;
                    if ((pNativeImage.getLuminanceOrAlpha(j, l) & 0xFF) > 16) {
                        return i + 1;
                    }
                    ++k;
                }
                --i;
            }
            return i + 1;
        }
    }

    static final class Glyph
    implements RawGlyph {
        private final float scale;
        private final NativeImage image;
        private final int offsetX;
        private final int offsetY;
        private final int width;
        private final int height;
        private final int advance;
        private final int ascent;
        private float offsetBold = 1.0f;

        Glyph(float p_95372_, NativeImage p_95373_, int p_95374_, int p_95375_, int p_95376_, int p_95377_, int p_95378_, int p_95379_) {
            this.scale = p_95372_;
            this.image = p_95373_;
            this.offsetX = p_95374_;
            this.offsetY = p_95375_;
            this.width = p_95376_;
            this.height = p_95377_;
            this.advance = p_95378_;
            this.ascent = p_95379_;
        }

        @Override
        public float getOversample() {
            return 1.0f / this.scale;
        }

        @Override
        public int getPixelWidth() {
            return this.width;
        }

        @Override
        public int getPixelHeight() {
            return this.height;
        }

        @Override
        public float getAdvance() {
            return this.advance;
        }

        @Override
        public float getBearingY() {
            return RawGlyph.super.getBearingY() + 7.0f - (float)this.ascent;
        }

        @Override
        public void upload(int pXOffset, int pYOffset) {
            this.image.upload(0, pXOffset, pYOffset, this.offsetX, this.offsetY, this.width, this.height, false, false);
        }

        @Override
        public boolean isColored() {
            return this.image.format().components() > 1;
        }

        @Override
        public float getBoldOffset() {
            return this.offsetBold;
        }
    }
}

