/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.gui.font.providers.BitmapProvider;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.client.gui.font.providers.LegacyUnicodeBitmapsProvider;
import net.minecraft.client.gui.font.providers.TrueTypeGlyphProviderBuilder;

public enum GlyphProviderBuilderType {
    BITMAP("bitmap", BitmapProvider.Builder::fromJson),
    TTF("ttf", TrueTypeGlyphProviderBuilder::fromJson),
    LEGACY_UNICODE("legacy_unicode", LegacyUnicodeBitmapsProvider.Builder::fromJson);

    private static final Map<String, GlyphProviderBuilderType> BY_NAME;
    private final String name;
    private final Function<JsonObject, GlyphProviderBuilder> factory;

    static {
        BY_NAME = Util.make(Maps.newHashMap(), p_95418_ -> {
            GlyphProviderBuilderType[] glyphProviderBuilderTypeArray = GlyphProviderBuilderType.values();
            int n = glyphProviderBuilderTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GlyphProviderBuilderType glyphproviderbuildertype = glyphProviderBuilderTypeArray[n2];
                p_95418_.put(glyphproviderbuildertype.name, glyphproviderbuildertype);
                ++n2;
            }
        });
    }

    private GlyphProviderBuilderType(String p_95411_, Function<JsonObject, GlyphProviderBuilder> p_95412_) {
        this.name = p_95411_;
        this.factory = p_95412_;
    }

    public static GlyphProviderBuilderType byName(String pType) {
        GlyphProviderBuilderType glyphproviderbuildertype = BY_NAME.get(pType);
        if (glyphproviderbuildertype == null) {
            throw new IllegalArgumentException("Invalid type: " + pType);
        }
        return glyphproviderbuildertype;
    }

    public GlyphProviderBuilder create(JsonObject pJson) {
        return this.factory.apply(pJson);
    }
}

