/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.RawGlyph;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.Arrays;
import java.util.IllegalFormatException;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.slf4j.Logger;

public class LegacyUnicodeBitmapsProvider
implements GlyphProvider {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int UNICODE_SHEETS = 256;
    private static final int CHARS_PER_SHEET = 256;
    private static final int TEXTURE_SIZE = 256;
    private final ResourceManager resourceManager;
    private final byte[] sizes;
    private final String texturePattern;
    private final Map<ResourceLocation, NativeImage> textures = Maps.newHashMap();

    public LegacyUnicodeBitmapsProvider(ResourceManager pResourceManager, byte[] pSizes, String pTexturePattern) {
        this.resourceManager = pResourceManager;
        this.sizes = pSizes;
        this.texturePattern = pTexturePattern;
        int i = 0;
        while (i < 256) {
            block19: {
                int j;
                block18: {
                    j = i * 256;
                    ResourceLocation resourcelocation = this.getSheetLocation(j);
                    try (Resource resource = this.resourceManager.getResource(resourcelocation);
                         NativeImage nativeimage = NativeImage.read(NativeImage.Format.RGBA, resource.getInputStream());){
                        if (nativeimage.getWidth() != 256 || nativeimage.getHeight() != 256) break block18;
                        int k = 0;
                        while (true) {
                            if (k >= 256) {
                                break block19;
                            }
                            byte b0 = pSizes[j + k];
                            if (b0 != 0 && LegacyUnicodeBitmapsProvider.getLeft(b0) > LegacyUnicodeBitmapsProvider.getRight(b0)) {
                                pSizes[j + k] = 0;
                            }
                            ++k;
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Arrays.fill(pSizes, j, j + 256, (byte)0);
            }
            ++i;
        }
    }

    @Override
    public void close() {
        this.textures.values().forEach(NativeImage::close);
    }

    private ResourceLocation getSheetLocation(int p_95443_) {
        ResourceLocation resourcelocation = new ResourceLocation(String.format(this.texturePattern, String.format("%02x", p_95443_ / 256)));
        return new ResourceLocation(resourcelocation.getNamespace(), "textures/" + resourcelocation.getPath());
    }

    @Override
    @Nullable
    public RawGlyph getGlyph(int pCharacter) {
        if (pCharacter >= 0 && pCharacter <= 65535) {
            NativeImage nativeimage;
            byte b0 = this.sizes[pCharacter];
            if (b0 != 0 && (nativeimage = this.textures.computeIfAbsent(this.getSheetLocation(pCharacter), this::loadTexture)) != null) {
                int i = LegacyUnicodeBitmapsProvider.getLeft(b0);
                return new Glyph(pCharacter % 16 * 16 + i, (pCharacter & 0xFF) / 16 * 16, LegacyUnicodeBitmapsProvider.getRight(b0) - i, 16, nativeimage);
            }
            return null;
        }
        return null;
    }

    @Override
    public IntSet getSupportedGlyphs() {
        IntOpenHashSet intset = new IntOpenHashSet();
        int i = 0;
        while (i < 65535) {
            if (this.sizes[i] != 0) {
                intset.add(i);
            }
            ++i;
        }
        return intset;
    }

    @Nullable
    private NativeImage loadTexture(ResourceLocation p_95438_) {
        try {
            NativeImage nativeimage;
            try (Resource resource = this.resourceManager.getResource(p_95438_);){
                nativeimage = NativeImage.read(NativeImage.Format.RGBA, resource.getInputStream());
            }
            return nativeimage;
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load texture {}", (Object)p_95438_, (Object)ioexception);
            return null;
        }
    }

    private static int getLeft(byte p_95434_) {
        return p_95434_ >> 4 & 0xF;
    }

    private static int getRight(byte p_95441_) {
        return (p_95441_ & 0xF) + 1;
    }

    public static class Builder
    implements GlyphProviderBuilder {
        private final ResourceLocation metadata;
        private final String texturePattern;

        public Builder(ResourceLocation pMetadata, String pTexturePattern) {
            this.metadata = pMetadata;
            this.texturePattern = pTexturePattern;
        }

        public static GlyphProviderBuilder fromJson(JsonObject pJson) {
            return new Builder(new ResourceLocation(GsonHelper.getAsString(pJson, "sizes")), Builder.getTemplate(pJson));
        }

        private static String getTemplate(JsonObject pJson) {
            String s = GsonHelper.getAsString(pJson, "template");
            try {
                String.format(s, "");
                return s;
            }
            catch (IllegalFormatException illegalformatexception) {
                throw new JsonParseException("Invalid legacy unicode template supplied, expected single '%s': " + s);
            }
        }

        @Override
        @Nullable
        public GlyphProvider create(ResourceManager pResourceManager) {
            try {
                LegacyUnicodeBitmapsProvider legacyunicodebitmapsprovider;
                try (Resource resource = Minecraft.getInstance().getResourceManager().getResource(this.metadata);){
                    byte[] abyte = new byte[65536];
                    resource.getInputStream().read(abyte);
                    legacyunicodebitmapsprovider = new LegacyUnicodeBitmapsProvider(pResourceManager, abyte, this.texturePattern);
                }
                return legacyunicodebitmapsprovider;
            }
            catch (IOException ioexception) {
                LOGGER.error("Cannot load {}, unicode glyphs will not render correctly", (Object)this.metadata);
                return null;
            }
        }
    }

    static class Glyph
    implements RawGlyph {
        private final int width;
        private final int height;
        private final int sourceX;
        private final int sourceY;
        private final NativeImage source;

        Glyph(int pSourceX, int pSourceY, int pWidth, int pHeight, NativeImage pSource) {
            this.width = pWidth;
            this.height = pHeight;
            this.sourceX = pSourceX;
            this.sourceY = pSourceY;
            this.source = pSource;
        }

        @Override
        public float getOversample() {
            return 2.0f;
        }

        @Override
        public int getPixelWidth() {
            return this.width;
        }

        @Override
        public int getPixelHeight() {
            return this.height;
        }

        @Override
        public float getAdvance() {
            return this.width / 2 + 1;
        }

        @Override
        public void upload(int pXOffset, int pYOffset) {
            this.source.upload(0, pXOffset, pYOffset, this.sourceX, this.sourceY, this.width, this.height, false, false);
        }

        @Override
        public boolean isColored() {
            return this.source.format().components() > 1;
        }

        @Override
        public float getShadowOffset() {
            return 0.5f;
        }

        @Override
        public float getBoldOffset() {
            return 0.5f;
        }
    }
}

