/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font.providers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.font.TrueTypeGlyphProvider;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.font.providers.GlyphProviderBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;

public class TrueTypeGlyphProviderBuilder
implements GlyphProviderBuilder {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation location;
    private final float size;
    private final float oversample;
    private final float shiftX;
    private final float shiftY;
    private final String skip;

    public TrueTypeGlyphProviderBuilder(ResourceLocation pLocation, float pSize, float pOversample, float pShiftX, float pShiftY, String pSkip) {
        this.location = pLocation;
        this.size = pSize;
        this.oversample = pOversample;
        this.shiftX = pShiftX;
        this.shiftY = pShiftY;
        this.skip = pSkip;
    }

    public static GlyphProviderBuilder fromJson(JsonObject pJson) {
        float f = 0.0f;
        float f1 = 0.0f;
        if (pJson.has("shift")) {
            JsonArray jsonarray = pJson.getAsJsonArray("shift");
            if (jsonarray.size() != 2) {
                throw new JsonParseException("Expected 2 elements in 'shift', found " + jsonarray.size());
            }
            f = GsonHelper.convertToFloat(jsonarray.get(0), "shift[0]");
            f1 = GsonHelper.convertToFloat(jsonarray.get(1), "shift[1]");
        }
        StringBuilder stringbuilder = new StringBuilder();
        if (pJson.has("skip")) {
            JsonElement jsonelement = pJson.get("skip");
            if (jsonelement.isJsonArray()) {
                JsonArray jsonarray1 = GsonHelper.convertToJsonArray(jsonelement, "skip");
                int i = 0;
                while (i < jsonarray1.size()) {
                    stringbuilder.append(GsonHelper.convertToString(jsonarray1.get(i), "skip[" + i + "]"));
                    ++i;
                }
            } else {
                stringbuilder.append(GsonHelper.convertToString(jsonelement, "skip"));
            }
        }
        return new TrueTypeGlyphProviderBuilder(new ResourceLocation(GsonHelper.getAsString(pJson, "file")), GsonHelper.getAsFloat(pJson, "size", 11.0f), GsonHelper.getAsFloat(pJson, "oversample", 1.0f), f, f1, stringbuilder.toString());
    }

    @Override
    @Nullable
    public GlyphProvider create(ResourceManager pResourceManager) {
        STBTTFontinfo stbttfontinfo = null;
        ByteBuffer bytebuffer = null;
        try {
            TrueTypeGlyphProvider truetypeglyphprovider;
            try (Resource resource = pResourceManager.getResource(new ResourceLocation(this.location.getNamespace(), "font/" + this.location.getPath()));){
                LOGGER.debug("Loading font {}", (Object)this.location);
                stbttfontinfo = STBTTFontinfo.malloc();
                bytebuffer = TextureUtil.readResource(resource.getInputStream());
                bytebuffer.flip();
                LOGGER.debug("Reading font {}", (Object)this.location);
                if (!STBTruetype.stbtt_InitFont((STBTTFontinfo)stbttfontinfo, (ByteBuffer)bytebuffer)) {
                    throw new IOException("Invalid ttf");
                }
                truetypeglyphprovider = new TrueTypeGlyphProvider(bytebuffer, stbttfontinfo, this.size, this.oversample, this.shiftX, this.shiftY, this.skip);
            }
            return truetypeglyphprovider;
        }
        catch (Exception exception) {
            LOGGER.error("Couldn't load truetype font {}", (Object)this.location, (Object)exception);
            if (stbttfontinfo != null) {
                stbttfontinfo.free();
            }
            MemoryUtil.memFree(bytebuffer);
            return null;
        }
    }
}

