/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.narration;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationThunk;

public class ScreenNarrationCollector {
    int generation;
    final Map<EntryKey, NarrationEntry> entries = Maps.newTreeMap(Comparator.comparing(p_169196_ -> p_169196_.type).thenComparing(p_169185_ -> p_169185_.depth));

    public void update(Consumer<NarrationElementOutput> p_169187_) {
        ++this.generation;
        p_169187_.accept(new Output(0));
    }

    public String collectNarrationText(boolean p_169189_) {
        StringBuilder stringbuilder = new StringBuilder();
        Consumer<String> consumer = new Consumer<String>(){
            private boolean firstEntry = true;

            @Override
            public void accept(String p_169204_) {
                if (!this.firstEntry) {
                    stringbuilder.append(". ");
                }
                this.firstEntry = false;
                stringbuilder.append(p_169204_);
            }
        };
        this.entries.forEach((p_169193_, p_169194_) -> {
            if (p_169194_.generation == this.generation && (p_169189_ || !p_169194_.alreadyNarrated)) {
                p_169194_.contents.getText(consumer);
                p_169194_.alreadyNarrated = true;
            }
        });
        return stringbuilder.toString();
    }

    static class EntryKey {
        final NarratedElementType type;
        final int depth;

        EntryKey(NarratedElementType pType, int pDepth) {
            this.type = pType;
            this.depth = pDepth;
        }
    }

    static class NarrationEntry {
        NarrationThunk<?> contents = NarrationThunk.EMPTY;
        int generation = -1;
        boolean alreadyNarrated;

        NarrationEntry() {
        }

        public NarrationEntry update(int pGeneration, NarrationThunk<?> pContents) {
            if (!this.contents.equals(pContents)) {
                this.contents = pContents;
                this.alreadyNarrated = false;
            } else if (this.generation + 1 != pGeneration) {
                this.alreadyNarrated = false;
            }
            this.generation = pGeneration;
            return this;
        }
    }

    class Output
    implements NarrationElementOutput {
        private final int depth;

        Output(int p_169223_) {
            this.depth = p_169223_;
        }

        @Override
        public void add(NarratedElementType pType, NarrationThunk<?> pContents) {
            ScreenNarrationCollector.this.entries.computeIfAbsent(new EntryKey(pType, this.depth), p_169229_ -> new NarrationEntry()).update(ScreenNarrationCollector.this.generation, pContents);
        }

        @Override
        public NarrationElementOutput nest() {
            ScreenNarrationCollector screenNarrationCollector = ScreenNarrationCollector.this;
            screenNarrationCollector.getClass();
            return screenNarrationCollector.new Output(this.depth + 1);
        }
    }
}

