/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.Mth;

public class ChatScreen
extends Screen {
    public static final double MOUSE_SCROLL_SPEED = 7.0;
    private static final Component USAGE_TEXT = new TranslatableComponent("chat_screen.usage");
    private String historyBuffer = "";
    private int historyPos = -1;
    protected EditBox input;
    private final String initial;
    CommandSuggestions commandSuggestions;

    public ChatScreen(String pInitial) {
        super(new TranslatableComponent("chat_screen.title"));
        this.initial = pInitial;
    }

    @Override
    protected void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.historyPos = this.minecraft.gui.getChat().getRecentChat().size();
        this.input = new EditBox(this.font, 4, this.height - 12, this.width - 4, 12, (Component)new TranslatableComponent("chat.editBox")){

            @Override
            protected MutableComponent createNarrationMessage() {
                return super.createNarrationMessage().append(ChatScreen.this.commandSuggestions.getNarrationMessage());
            }
        };
        this.input.setMaxLength(256);
        this.input.setBordered(false);
        this.input.setValue(this.initial);
        this.input.setResponder(this::onEdited);
        this.addWidget(this.input);
        this.commandSuggestions = new CommandSuggestions(this.minecraft, this, this.input, this.font, false, false, 1, 10, true, -805306368);
        this.commandSuggestions.updateCommandInfo();
        this.setInitialFocus(this.input);
    }

    @Override
    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.input.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.setChatLine(s);
        this.commandSuggestions.updateCommandInfo();
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
        this.minecraft.gui.getChat().resetChatScroll();
    }

    @Override
    public void tick() {
        this.input.tick();
    }

    private void onEdited(String p_95611_) {
        String s = this.input.getValue();
        this.commandSuggestions.setAllowSuggestions(!s.equals(this.initial));
        this.commandSuggestions.updateCommandInfo();
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.commandSuggestions.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode == 256) {
            this.minecraft.setScreen(null);
            return true;
        }
        if (pKeyCode != 257 && pKeyCode != 335) {
            if (pKeyCode == 265) {
                this.moveInHistory(-1);
                return true;
            }
            if (pKeyCode == 264) {
                this.moveInHistory(1);
                return true;
            }
            if (pKeyCode == 266) {
                this.minecraft.gui.getChat().scrollChat(this.minecraft.gui.getChat().getLinesPerPage() - 1);
                return true;
            }
            if (pKeyCode == 267) {
                this.minecraft.gui.getChat().scrollChat(-this.minecraft.gui.getChat().getLinesPerPage() + 1);
                return true;
            }
            return false;
        }
        String s = this.input.getValue().trim();
        if (!s.isEmpty()) {
            this.sendMessage(s);
        }
        this.minecraft.setScreen(null);
        return true;
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double p_95582_, double pMouseY) {
        if (this.commandSuggestions.mouseScrolled(pMouseY = Mth.clamp(pMouseY, -1.0, 1.0))) {
            return true;
        }
        if (!ChatScreen.hasShiftDown()) {
            pMouseY *= 7.0;
        }
        this.minecraft.gui.getChat().scrollChat((int)pMouseY);
        return true;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_95586_, int pMouseY) {
        if (this.commandSuggestions.mouseClicked((int)pMouseX, (int)p_95586_, pMouseY)) {
            return true;
        }
        if (pMouseY == 0) {
            ChatComponent chatcomponent = this.minecraft.gui.getChat();
            if (chatcomponent.handleChatQueueClicked(pMouseX, p_95586_)) {
                return true;
            }
            Style style = chatcomponent.getClickedComponentStyleAt(pMouseX, p_95586_);
            if (style != null && this.handleComponentClicked(style)) {
                return true;
            }
        }
        return this.input.mouseClicked(pMouseX, p_95586_, pMouseY) ? true : super.mouseClicked(pMouseX, p_95586_, pMouseY);
    }

    @Override
    protected void insertText(String pText, boolean pOverwrite) {
        if (pOverwrite) {
            this.input.setValue(pText);
        } else {
            this.input.insertText(pText);
        }
    }

    public void moveInHistory(int pMsgPos) {
        int i = this.historyPos + pMsgPos;
        int j = this.minecraft.gui.getChat().getRecentChat().size();
        if ((i = Mth.clamp(i, 0, j)) != this.historyPos) {
            if (i == j) {
                this.historyPos = j;
                this.input.setValue(this.historyBuffer);
            } else {
                if (this.historyPos == j) {
                    this.historyBuffer = this.input.getValue();
                }
                this.input.setValue(this.minecraft.gui.getChat().getRecentChat().get(i));
                this.commandSuggestions.setAllowSuggestions(false);
                this.historyPos = i;
            }
        }
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.setFocused(this.input);
        this.input.setFocus(true);
        ChatScreen.fill(pPoseStack, 2, this.height - 14, this.width - 2, this.height - 2, this.minecraft.options.getBackgroundColor(Integer.MIN_VALUE));
        this.input.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.commandSuggestions.render(pPoseStack, pMouseX, pMouseY);
        Style style = this.minecraft.gui.getChat().getClickedComponentStyleAt(pMouseX, pMouseY);
        if (style != null && style.getHoverEvent() != null) {
            this.renderComponentHoverEffect(pPoseStack, style, pMouseX, pMouseY);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    private void setChatLine(String p_95613_) {
        this.input.setValue(p_95613_);
    }

    @Override
    protected void updateNarrationState(NarrationElementOutput p_169238_) {
        p_169238_.add(NarratedElementType.TITLE, this.getTitle());
        p_169238_.add(NarratedElementType.USAGE, USAGE_TEXT);
        String s = this.input.getValue();
        if (!s.isEmpty()) {
            p_169238_.nest().add(NarratedElementType.TITLE, new TranslatableComponent("chat_screen.message", s));
        }
    }
}

