/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.PresetFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.flat.FlatLayerInfo;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;

public class CreateFlatWorldScreen
extends Screen {
    private static final int SLOT_TEX_SIZE = 128;
    private static final int SLOT_BG_SIZE = 18;
    private static final int SLOT_STAT_HEIGHT = 20;
    private static final int SLOT_BG_X = 1;
    private static final int SLOT_BG_Y = 1;
    private static final int SLOT_FG_X = 2;
    private static final int SLOT_FG_Y = 2;
    protected final CreateWorldScreen parent;
    private final Consumer<FlatLevelGeneratorSettings> applySettings;
    FlatLevelGeneratorSettings generator;
    private Component columnType;
    private Component columnHeight;
    private DetailsList list;
    private Button deleteLayerButton;

    public CreateFlatWorldScreen(CreateWorldScreen pParent, Consumer<FlatLevelGeneratorSettings> pApplySettings, FlatLevelGeneratorSettings pGenerator) {
        super(new TranslatableComponent("createWorld.customize.flat.title"));
        this.parent = pParent;
        this.applySettings = pApplySettings;
        this.generator = pGenerator;
    }

    public FlatLevelGeneratorSettings settings() {
        return this.generator;
    }

    public void setConfig(FlatLevelGeneratorSettings pGenerator) {
        this.generator = pGenerator;
    }

    @Override
    protected void init() {
        this.columnType = new TranslatableComponent("createWorld.customize.flat.tile");
        this.columnHeight = new TranslatableComponent("createWorld.customize.flat.height");
        this.list = new DetailsList();
        this.addWidget(this.list);
        this.deleteLayerButton = this.addRenderableWidget(new Button(this.width / 2 - 155, this.height - 52, 150, 20, new TranslatableComponent("createWorld.customize.flat.removeLayer"), p_95845_ -> {
            if (this.hasValidSelection()) {
                List<FlatLayerInfo> list = this.generator.getLayersInfo();
                int i = this.list.children().indexOf(this.list.getSelected());
                int j = list.size() - i - 1;
                list.remove(j);
                this.list.setSelected(list.isEmpty() ? null : (DetailsList.Entry)this.list.children().get(Math.min(i, list.size() - 1)));
                this.generator.updateLayers();
                this.list.resetRows();
                this.updateButtonValidity();
            }
        }));
        this.addRenderableWidget(new Button(this.width / 2 + 5, this.height - 52, 150, 20, new TranslatableComponent("createWorld.customize.presets"), p_95843_ -> {
            this.minecraft.setScreen(new PresetFlatWorldScreen(this));
            this.generator.updateLayers();
            this.updateButtonValidity();
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 155, this.height - 28, 150, 20, CommonComponents.GUI_DONE, p_95839_ -> {
            this.applySettings.accept(this.generator);
            this.minecraft.setScreen(this.parent);
            this.generator.updateLayers();
        }));
        this.addRenderableWidget(new Button(this.width / 2 + 5, this.height - 28, 150, 20, CommonComponents.GUI_CANCEL, p_95833_ -> {
            this.minecraft.setScreen(this.parent);
            this.generator.updateLayers();
        }));
        this.generator.updateLayers();
        this.updateButtonValidity();
    }

    void updateButtonValidity() {
        this.deleteLayerButton.active = this.hasValidSelection();
    }

    private boolean hasValidSelection() {
        return this.list.getSelected() != null;
    }

    @Override
    public void onClose() {
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        this.list.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        CreateFlatWorldScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        int i = this.width / 2 - 92 - 16;
        CreateFlatWorldScreen.drawString(pPoseStack, this.font, this.columnType, i, 32, 0xFFFFFF);
        CreateFlatWorldScreen.drawString(pPoseStack, this.font, this.columnHeight, i + 2 + 213 - this.font.width(this.columnHeight), 32, 0xFFFFFF);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    class DetailsList
    extends ObjectSelectionList<Entry> {
        public DetailsList() {
            super(CreateFlatWorldScreen.this.minecraft, CreateFlatWorldScreen.this.width, CreateFlatWorldScreen.this.height, 43, CreateFlatWorldScreen.this.height - 60, 24);
            int i = 0;
            while (i < CreateFlatWorldScreen.this.generator.getLayersInfo().size()) {
                this.addEntry(new Entry());
                ++i;
            }
        }

        @Override
        public void setSelected(@Nullable Entry pEntry) {
            super.setSelected(pEntry);
            CreateFlatWorldScreen.this.updateButtonValidity();
        }

        @Override
        protected boolean isFocused() {
            return CreateFlatWorldScreen.this.getFocused() == this;
        }

        @Override
        protected int getScrollbarPosition() {
            return this.width - 70;
        }

        public void resetRows() {
            int i = this.children().indexOf(this.getSelected());
            this.clearEntries();
            int j = 0;
            while (j < CreateFlatWorldScreen.this.generator.getLayersInfo().size()) {
                this.addEntry(new Entry());
                ++j;
            }
            List list = this.children();
            if (i >= 0 && i < list.size()) {
                this.setSelected((Entry)list.get(i));
            }
        }

        class Entry
        extends ObjectSelectionList.Entry<Entry> {
            Entry() {
            }

            @Override
            public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                FlatLayerInfo flatlayerinfo = ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.generator.getLayersInfo().get(((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.generator.getLayersInfo().size() - pIndex - 1);
                BlockState blockstate = flatlayerinfo.getBlockState();
                ItemStack itemstack = this.getDisplayItem(blockstate);
                this.blitSlot(pPoseStack, pLeft, pTop, itemstack);
                ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.font.draw(pPoseStack, itemstack.getHoverName(), (float)(pLeft + 18 + 5), (float)(pTop + 3), 0xFFFFFF);
                TranslatableComponent component = pIndex == 0 ? new TranslatableComponent("createWorld.customize.flat.layer.top", flatlayerinfo.getHeight()) : (pIndex == ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.generator.getLayersInfo().size() - 1 ? new TranslatableComponent("createWorld.customize.flat.layer.bottom", flatlayerinfo.getHeight()) : new TranslatableComponent("createWorld.customize.flat.layer", flatlayerinfo.getHeight()));
                ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.font.draw(pPoseStack, component, (float)(pLeft + 2 + 213 - ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.font.width(component)), (float)(pTop + 3), 0xFFFFFF);
            }

            private ItemStack getDisplayItem(BlockState pState) {
                Item item = pState.getBlock().asItem();
                if (item == Items.AIR) {
                    if (pState.is(Blocks.WATER)) {
                        item = Items.WATER_BUCKET;
                    } else if (pState.is(Blocks.LAVA)) {
                        item = Items.LAVA_BUCKET;
                    }
                }
                return new ItemStack(item);
            }

            @Override
            public Component getNarration() {
                FlatLayerInfo flatlayerinfo = ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.generator.getLayersInfo().get(((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.generator.getLayersInfo().size() - DetailsList.this.children().indexOf(this) - 1);
                ItemStack itemstack = this.getDisplayItem(flatlayerinfo.getBlockState());
                return !itemstack.isEmpty() ? new TranslatableComponent("narrator.select", itemstack.getHoverName()) : TextComponent.EMPTY;
            }

            @Override
            public boolean mouseClicked(double pMouseX, double p_95869_, int pMouseY) {
                if (pMouseY == 0) {
                    DetailsList.this.setSelected(this);
                    return true;
                }
                return false;
            }

            private void blitSlot(PoseStack pPoseStack, int pX, int pY, ItemStack pStack) {
                this.blitSlotBg(pPoseStack, pX + 1, pY + 1);
                if (!pStack.isEmpty()) {
                    ((DetailsList)DetailsList.this).CreateFlatWorldScreen.this.itemRenderer.renderGuiItem(pStack, pX + 2, pY + 2);
                }
            }

            private void blitSlotBg(PoseStack pPoseStack, int pX, int pY) {
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                RenderSystem.setShaderTexture(0, GuiComponent.STATS_ICON_LOCATION);
                GuiComponent.blit(pPoseStack, pX, pY, CreateFlatWorldScreen.this.getBlitOffset(), 0.0f, 0.0f, 18, 18, 128, 128);
            }
        }
    }
}

