/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class DeathScreen
extends Screen {
    private int delayTicker;
    private final Component causeOfDeath;
    private final boolean hardcore;
    private Component deathScore;
    private final List<Button> exitButtons = Lists.newArrayList();

    public DeathScreen(@Nullable Component pCauseOfDeath, boolean pHardcore) {
        super(new TranslatableComponent(pHardcore ? "deathScreen.title.hardcore" : "deathScreen.title").withStyle(ChatFormatting.UNDERLINE));
        this.causeOfDeath = pCauseOfDeath;
        this.hardcore = pHardcore;
    }

    @Override
    protected void init() {
        this.delayTicker = 0;
        this.exitButtons.clear();
        this.exitButtons.add(this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 72, 200, 20, this.hardcore ? new TranslatableComponent("deathScreen.spectate") : new TranslatableComponent("deathScreen.respawn"), p_95930_ -> {
            this.minecraft.player.respawn();
            this.minecraft.setScreen(null);
        })));
        this.exitButtons.add(this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 96, 200, 20, new TranslatableComponent("deathScreen.titleScreen"), p_95925_ -> {
            if (this.hardcore) {
                this.exitToTitleScreen();
            } else {
                ConfirmScreen confirmscreen = new ConfirmScreen(this::confirmResult, new TranslatableComponent("deathScreen.quit.confirm"), TextComponent.EMPTY, new TranslatableComponent("deathScreen.titleScreen"), new TranslatableComponent("deathScreen.respawn"));
                this.minecraft.setScreen(confirmscreen);
                confirmscreen.setDelay(20);
            }
        })));
        for (Button button : this.exitButtons) {
            button.active = false;
        }
        this.deathScore = new TranslatableComponent("deathScreen.score").append(": ").append(new TextComponent(Integer.toString(this.minecraft.player.getScore())).withStyle(ChatFormatting.AQUA));
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    private void confirmResult(boolean p_95932_) {
        if (p_95932_) {
            this.exitToTitleScreen();
        } else {
            this.minecraft.player.respawn();
            this.minecraft.setScreen(null);
        }
    }

    private void exitToTitleScreen() {
        if (this.minecraft.level != null) {
            this.minecraft.level.disconnect();
        }
        this.minecraft.clearLevel(new GenericDirtMessageScreen(new TranslatableComponent("menu.savingLevel")));
        this.minecraft.setScreen(new TitleScreen());
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.fillGradient(pPoseStack, 0, 0, this.width, this.height, 0x60500000, -1602211792);
        pPoseStack.pushPose();
        pPoseStack.scale(2.0f, 2.0f, 2.0f);
        DeathScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2 / 2, 30, 0xFFFFFF);
        pPoseStack.popPose();
        if (this.causeOfDeath != null) {
            DeathScreen.drawCenteredString(pPoseStack, this.font, this.causeOfDeath, this.width / 2, 85, 0xFFFFFF);
        }
        DeathScreen.drawCenteredString(pPoseStack, this.font, this.deathScore, this.width / 2, 100, 0xFFFFFF);
        if (this.causeOfDeath != null && pMouseY > 85 && pMouseY < 94) {
            Style style = this.getClickedComponentStyleAt(pMouseX);
            this.renderComponentHoverEffect(pPoseStack, style, pMouseX, pMouseY);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    @Nullable
    private Style getClickedComponentStyleAt(int p_95918_) {
        if (this.causeOfDeath == null) {
            return null;
        }
        int i = this.minecraft.font.width(this.causeOfDeath);
        int j = this.width / 2 - i / 2;
        int k = this.width / 2 + i / 2;
        return p_95918_ >= j && p_95918_ <= k ? this.minecraft.font.getSplitter().componentStyleAtWidth(this.causeOfDeath, p_95918_ - j) : null;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_95915_, int pMouseY) {
        Style style;
        if (this.causeOfDeath != null && p_95915_ > 85.0 && p_95915_ < 94.0 && (style = this.getClickedComponentStyleAt((int)pMouseX)) != null && style.getClickEvent() != null && style.getClickEvent().getAction() == ClickEvent.Action.OPEN_URL) {
            this.handleComponentClicked(style);
            return false;
        }
        return super.mouseClicked(pMouseX, p_95915_, pMouseY);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.delayTicker;
        if (this.delayTicker == 20) {
            for (Button button : this.exitButtons) {
                button.active = true;
            }
        }
    }
}

