/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class LanguageSelectScreen
extends OptionsSubScreen {
    private static final Component WARNING_LABEL = new TextComponent("(").append(new TranslatableComponent("options.languageWarning")).append(")").withStyle(ChatFormatting.GRAY);
    private LanguageSelectionList packSelectionList;
    final LanguageManager languageManager;

    public LanguageSelectScreen(Screen pLastScreen, Options pOptions, LanguageManager pLanguageManager) {
        super(pLastScreen, pOptions, new TranslatableComponent("options.language"));
        this.languageManager = pLanguageManager;
    }

    @Override
    protected void init() {
        this.packSelectionList = new LanguageSelectionList(this.minecraft);
        this.addWidget(this.packSelectionList);
        this.addRenderableWidget(Option.FORCE_UNICODE_FONT.createButton(this.options, this.width / 2 - 155, this.height - 38, 150));
        this.addRenderableWidget(new Button(this.width / 2 - 155 + 160, this.height - 38, 150, 20, CommonComponents.GUI_DONE, p_96099_ -> {
            LanguageSelectionList.Entry languageselectscreen$languageselectionlist$entry = (LanguageSelectionList.Entry)this.packSelectionList.getSelected();
            if (languageselectscreen$languageselectionlist$entry != null && !languageselectscreen$languageselectionlist$entry.language.getCode().equals(this.languageManager.getSelected().getCode())) {
                this.languageManager.setSelected(languageselectscreen$languageselectionlist$entry.language);
                this.options.languageCode = languageselectscreen$languageselectionlist$entry.language.getCode();
                this.minecraft.reloadResourcePacks();
                this.options.save();
            }
            this.minecraft.setScreen(this.lastScreen);
        }));
        super.init();
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.packSelectionList.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        LanguageSelectScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 16, 0xFFFFFF);
        LanguageSelectScreen.drawCenteredString(pPoseStack, this.font, WARNING_LABEL, this.width / 2, this.height - 56, 0x808080);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    class LanguageSelectionList
    extends ObjectSelectionList<Entry> {
        public LanguageSelectionList(Minecraft p_96103_) {
            super(p_96103_, LanguageSelectScreen.this.width, LanguageSelectScreen.this.height, 32, LanguageSelectScreen.this.height - 65 + 4, 18);
            for (LanguageInfo languageinfo : LanguageSelectScreen.this.languageManager.getLanguages()) {
                Entry languageselectscreen$languageselectionlist$entry = new Entry(languageinfo);
                this.addEntry(languageselectscreen$languageselectionlist$entry);
                if (!LanguageSelectScreen.this.languageManager.getSelected().getCode().equals(languageinfo.getCode())) continue;
                this.setSelected(languageselectscreen$languageselectionlist$entry);
            }
            if (this.getSelected() != null) {
                this.centerScrollOn((Entry)this.getSelected());
            }
        }

        @Override
        protected int getScrollbarPosition() {
            return super.getScrollbarPosition() + 20;
        }

        @Override
        public int getRowWidth() {
            return super.getRowWidth() + 50;
        }

        @Override
        protected void renderBackground(PoseStack pPoseStack) {
            LanguageSelectScreen.this.renderBackground(pPoseStack);
        }

        @Override
        protected boolean isFocused() {
            return LanguageSelectScreen.this.getFocused() == this;
        }

        public class Entry
        extends ObjectSelectionList.Entry<Entry> {
            final LanguageInfo language;

            public Entry(LanguageInfo p_96119_) {
                this.language = p_96119_;
            }

            @Override
            public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                String s = this.language.toString();
                ((LanguageSelectionList)LanguageSelectionList.this).LanguageSelectScreen.this.font.drawShadow(pPoseStack, s, LanguageSelectionList.this.width / 2 - ((LanguageSelectionList)LanguageSelectionList.this).LanguageSelectScreen.this.font.width(s) / 2, pTop + 1, 0xFFFFFF, true);
            }

            @Override
            public boolean mouseClicked(double pMouseX, double p_96123_, int pMouseY) {
                if (pMouseY == 0) {
                    this.select();
                    return true;
                }
                return false;
            }

            private void select() {
                LanguageSelectionList.this.setSelected(this);
            }

            @Override
            public Component getNarration() {
                return new TranslatableComponent("narrator.select", this.language);
            }
        }
    }
}

