/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.Util;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.progress.StoringChunkProgressListener;
import net.minecraft.util.Mth;
import net.minecraft.world.level.chunk.ChunkStatus;

public class LevelLoadingScreen
extends Screen {
    private static final long NARRATION_DELAY_MS = 2000L;
    private final StoringChunkProgressListener progressListener;
    private long lastNarration = -1L;
    private boolean done;
    private static final Object2IntMap<ChunkStatus> COLORS = (Object2IntMap)Util.make(new Object2IntOpenHashMap(), p_96157_ -> {
        p_96157_.defaultReturnValue(0);
        p_96157_.put((Object)ChunkStatus.EMPTY, 0x545454);
        p_96157_.put((Object)ChunkStatus.STRUCTURE_STARTS, 0x999999);
        p_96157_.put((Object)ChunkStatus.STRUCTURE_REFERENCES, 6250897);
        p_96157_.put((Object)ChunkStatus.BIOMES, 8434258);
        p_96157_.put((Object)ChunkStatus.NOISE, 0xD1D1D1);
        p_96157_.put((Object)ChunkStatus.SURFACE, 7497737);
        p_96157_.put((Object)ChunkStatus.CARVERS, 7169628);
        p_96157_.put((Object)ChunkStatus.LIQUID_CARVERS, 3159410);
        p_96157_.put((Object)ChunkStatus.FEATURES, 2213376);
        p_96157_.put((Object)ChunkStatus.LIGHT, 0xCCCCCC);
        p_96157_.put((Object)ChunkStatus.SPAWN, 15884384);
        p_96157_.put((Object)ChunkStatus.HEIGHTMAPS, 0xEEEEEE);
        p_96157_.put((Object)ChunkStatus.FULL, 0xFFFFFF);
    });

    public LevelLoadingScreen(StoringChunkProgressListener pProgressListener) {
        super(NarratorChatListener.NO_TITLE);
        this.progressListener = pProgressListener;
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void removed() {
        this.done = true;
        this.triggerImmediateNarration(true);
    }

    @Override
    protected void updateNarratedWidget(NarrationElementOutput p_169312_) {
        if (this.done) {
            p_169312_.add(NarratedElementType.TITLE, new TranslatableComponent("narrator.loading.done"));
        } else {
            String s = this.getFormattedProgress();
            p_169312_.add(NarratedElementType.TITLE, s);
        }
    }

    private String getFormattedProgress() {
        return String.valueOf(Mth.clamp(this.progressListener.getProgress(), 0, 100)) + "%";
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        long i = Util.getMillis();
        if (i - this.lastNarration > 2000L) {
            this.lastNarration = i;
            this.triggerImmediateNarration(true);
        }
        int j = this.width / 2;
        int k = this.height / 2;
        int l = 30;
        LevelLoadingScreen.renderChunks(pPoseStack, this.progressListener, j, k + 30, 2, 0);
        LevelLoadingScreen.drawCenteredString(pPoseStack, this.font, this.getFormattedProgress(), j, k - 4 - 30, 0xFFFFFF);
    }

    public static void renderChunks(PoseStack p_96150_, StoringChunkProgressListener p_96151_, int p_96152_, int p_96153_, int p_96154_, int p_96155_) {
        int i = p_96154_ + p_96155_;
        int j = p_96151_.getFullDiameter();
        int k = j * i - p_96155_;
        int l = p_96151_.getDiameter();
        int i1 = l * i - p_96155_;
        int j1 = p_96152_ - i1 / 2;
        int k1 = p_96153_ - i1 / 2;
        int l1 = k / 2 + 1;
        int i2 = -16772609;
        if (p_96155_ != 0) {
            LevelLoadingScreen.fill(p_96150_, p_96152_ - l1, p_96153_ - l1, p_96152_ - l1 + 1, p_96153_ + l1, -16772609);
            LevelLoadingScreen.fill(p_96150_, p_96152_ + l1 - 1, p_96153_ - l1, p_96152_ + l1, p_96153_ + l1, -16772609);
            LevelLoadingScreen.fill(p_96150_, p_96152_ - l1, p_96153_ - l1, p_96152_ + l1, p_96153_ - l1 + 1, -16772609);
            LevelLoadingScreen.fill(p_96150_, p_96152_ - l1, p_96153_ + l1 - 1, p_96152_ + l1, p_96153_ + l1, -16772609);
        }
        int j2 = 0;
        while (j2 < l) {
            int k2 = 0;
            while (k2 < l) {
                ChunkStatus chunkstatus = p_96151_.getStatus(j2, k2);
                int l2 = j1 + j2 * i;
                int i3 = k1 + k2 * i;
                LevelLoadingScreen.fill(p_96150_, l2, i3, l2 + p_96154_, i3 + p_96154_, COLORS.getInt((Object)chunkstatus) | 0xFF000000);
                ++k2;
            }
            ++j2;
        }
    }
}

