/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Overlay;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.resources.metadata.texture.TextureMetadataSection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.render.GlBlendState;
import net.optifine.shaders.config.ShaderPackParser;
import net.optifine.util.PropertiesOrdered;

public class LoadingOverlay
extends Overlay {
    static final ResourceLocation MOJANG_STUDIOS_LOGO_LOCATION = new ResourceLocation("textures/gui/title/mojangstudios.png");
    private static final int LOGO_BACKGROUND_COLOR = FastColor.ARGB32.color(255, 239, 50, 61);
    private static final int LOGO_BACKGROUND_COLOR_DARK = FastColor.ARGB32.color(255, 0, 0, 0);
    private static final IntSupplier BRAND_BACKGROUND = () -> Minecraft.getInstance().options.darkMojangStudiosBackground ? LOGO_BACKGROUND_COLOR_DARK : LOGO_BACKGROUND_COLOR;
    private static final int LOGO_SCALE = 240;
    private static final float LOGO_QUARTER_FLOAT = 60.0f;
    private static final int LOGO_QUARTER = 60;
    private static final int LOGO_HALF = 120;
    private static final float LOGO_OVERLAP = 0.0625f;
    private static final float SMOOTHING = 0.95f;
    public static final long FADE_OUT_TIME = 1000L;
    public static final long FADE_IN_TIME = 500L;
    private final Minecraft minecraft;
    private final ReloadInstance reload;
    private final Consumer<Optional<Throwable>> onFinish;
    private final boolean fadeIn;
    private float currentProgress;
    private long fadeOutStart = -1L;
    private long fadeInStart = -1L;
    private int colorBackground = BRAND_BACKGROUND.getAsInt();
    private int colorBar = BRAND_BACKGROUND.getAsInt();
    private int colorOutline = 0xFFFFFF;
    private int colorProgress = 0xFFFFFF;
    private GlBlendState blendState = null;
    private boolean fadeOut = false;

    public LoadingOverlay(Minecraft pMinecraft, ReloadInstance pReload, Consumer<Optional<Throwable>> pOnFinish, boolean pFadeIn) {
        this.minecraft = pMinecraft;
        this.reload = pReload;
        this.onFinish = pOnFinish;
        this.fadeIn = false;
    }

    public static void registerTextures(Minecraft pMc) {
        pMc.getTextureManager().register(MOJANG_STUDIOS_LOGO_LOCATION, new LogoTexture());
    }

    private static int replaceAlpha(int p_169325_, int p_169326_) {
        return p_169325_ & 0xFFFFFF | p_169326_ << 24;
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        float f2;
        float f1;
        int i = this.minecraft.getWindow().getGuiScaledWidth();
        int j = this.minecraft.getWindow().getGuiScaledHeight();
        long k = Util.getMillis();
        if (this.fadeIn && this.fadeInStart == -1L) {
            this.fadeInStart = k;
        }
        float f = this.fadeOutStart > -1L ? (float)(k - this.fadeOutStart) / 1000.0f : -1.0f;
        float f3 = f1 = this.fadeInStart > -1L ? (float)(k - this.fadeInStart) / 500.0f : -1.0f;
        if (f >= 1.0f) {
            this.fadeOut = true;
            if (this.minecraft.screen != null) {
                this.minecraft.screen.render(pPoseStack, 0, 0, pPartialTick);
            }
            int l = Mth.ceil((1.0f - Mth.clamp(f - 1.0f, 0.0f, 1.0f)) * 255.0f);
            LoadingOverlay.fill(pPoseStack, 0, 0, i, j, LoadingOverlay.replaceAlpha(this.colorBackground, l));
            f2 = 1.0f - Mth.clamp(f - 1.0f, 0.0f, 1.0f);
        } else if (this.fadeIn) {
            if (this.minecraft.screen != null && f1 < 1.0f) {
                this.minecraft.screen.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
            int l1 = Mth.ceil(Mth.clamp((double)f1, 0.15, 1.0) * 255.0);
            LoadingOverlay.fill(pPoseStack, 0, 0, i, j, LoadingOverlay.replaceAlpha(this.colorBackground, l1));
            f2 = Mth.clamp(f1, 0.0f, 1.0f);
        } else {
            int i2 = this.colorBackground;
            float f32 = (float)(i2 >> 16 & 0xFF) / 255.0f;
            float f4 = (float)(i2 >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(i2 & 0xFF) / 255.0f;
            GlStateManager._clearColor(f32, f4, f5, 1.0f);
            GlStateManager._clear(16384, Minecraft.ON_OSX);
            f2 = 1.0f;
        }
        int j2 = (int)((double)this.minecraft.getWindow().getGuiScaledWidth() * 0.5);
        int k2 = (int)((double)this.minecraft.getWindow().getGuiScaledHeight() * 0.5);
        double d1 = Math.min((double)this.minecraft.getWindow().getGuiScaledWidth() * 0.75, (double)this.minecraft.getWindow().getGuiScaledHeight()) * 0.25;
        int i1 = (int)(d1 * 0.5);
        double d0 = d1 * 4.0;
        int j1 = (int)(d0 * 0.5);
        RenderSystem.setShaderTexture(0, MOJANG_STUDIOS_LOGO_LOCATION);
        RenderSystem.enableBlend();
        RenderSystem.blendEquation(32774);
        RenderSystem.blendFunc(770, 1);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, f2);
        boolean flag = true;
        if (this.blendState != null) {
            this.blendState.apply();
            if (!this.blendState.isEnabled() && this.fadeOut) {
                flag = false;
            }
        }
        if (flag) {
            LoadingOverlay.blit(pPoseStack, j2 - j1, k2 - i1, j1, (int)d1, -0.0625f, 0.0f, 120, 60, 120, 120);
            LoadingOverlay.blit(pPoseStack, j2, k2 - i1, j1, (int)d1, 0.0625f, 60.0f, 120, 60, 120, 120);
        }
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
        int k1 = (int)((double)this.minecraft.getWindow().getGuiScaledHeight() * 0.8325);
        float f6 = this.reload.getActualProgress();
        this.currentProgress = Mth.clamp(this.currentProgress * 0.95f + f6 * 0.050000012f, 0.0f, 1.0f);
        Reflector.ClientModLoader_renderProgressText.call(new Object[0]);
        if (f < 1.0f) {
            this.drawProgressBar(pPoseStack, i / 2 - j1, k1 - 5, i / 2 + j1, k1 + 5, 1.0f - Mth.clamp(f, 0.0f, 1.0f));
        }
        if (f >= 2.0f) {
            this.minecraft.setOverlay(null);
        }
        if (this.fadeOutStart == -1L && this.reload.isDone() && (!this.fadeIn || f1 >= 2.0f)) {
            this.fadeOutStart = Util.getMillis();
            try {
                this.reload.checkExceptions();
                this.onFinish.accept(Optional.empty());
            }
            catch (Throwable throwable) {
                this.onFinish.accept(Optional.of(throwable));
            }
            if (this.minecraft.screen != null) {
                this.minecraft.screen.init(this.minecraft, this.minecraft.getWindow().getGuiScaledWidth(), this.minecraft.getWindow().getGuiScaledHeight());
            }
        }
    }

    private void drawProgressBar(PoseStack p_96183_, int p_96184_, int p_96185_, int p_96186_, int p_96187_, float p_96188_) {
        int i = Mth.ceil((float)(p_96186_ - p_96184_ - 2) * this.currentProgress);
        int j = Math.round(p_96188_ * 255.0f);
        if (this.colorBar != this.colorBackground) {
            int k = this.colorBar >> 16 & 0xFF;
            int l = this.colorBar >> 8 & 0xFF;
            int i1 = this.colorBar & 0xFF;
            int j1 = FastColor.ARGB32.color(j, k, l, i1);
            LoadingOverlay.fill(p_96183_, p_96184_, p_96185_, p_96186_, p_96187_, j1);
        }
        int j2 = this.colorProgress >> 16 & 0xFF;
        int k2 = this.colorProgress >> 8 & 0xFF;
        int l2 = this.colorProgress & 0xFF;
        int i3 = FastColor.ARGB32.color(j, j2, k2, l2);
        LoadingOverlay.fill(p_96183_, p_96184_ + 2, p_96185_ + 2, p_96184_ + i, p_96187_ - 2, i3);
        int k1 = this.colorOutline >> 16 & 0xFF;
        int l1 = this.colorOutline >> 8 & 0xFF;
        int i2 = this.colorOutline & 0xFF;
        i3 = FastColor.ARGB32.color(j, k1, l1, i2);
        LoadingOverlay.fill(p_96183_, p_96184_ + 1, p_96185_, p_96186_ - 1, p_96185_ + 1, i3);
        LoadingOverlay.fill(p_96183_, p_96184_ + 1, p_96187_, p_96186_ - 1, p_96187_ - 1, i3);
        LoadingOverlay.fill(p_96183_, p_96184_, p_96185_, p_96184_ + 1, p_96187_, i3);
        LoadingOverlay.fill(p_96183_, p_96186_, p_96185_, p_96186_ - 1, p_96187_, i3);
    }

    @Override
    public boolean isPauseScreen() {
        return true;
    }

    public void update() {
        this.colorBackground = BRAND_BACKGROUND.getAsInt();
        this.colorBar = BRAND_BACKGROUND.getAsInt();
        this.colorOutline = 0xFFFFFF;
        this.colorProgress = 0xFFFFFF;
        if (Config.isCustomColors()) {
            try {
                String s = "optifine/color.properties";
                ResourceLocation resourcelocation = new ResourceLocation(s);
                if (!Config.hasResource(resourcelocation)) {
                    return;
                }
                InputStream inputstream = Config.getResourceStream(resourcelocation);
                Config.dbg("Loading " + s);
                PropertiesOrdered properties = new PropertiesOrdered();
                properties.load(inputstream);
                inputstream.close();
                this.colorBackground = LoadingOverlay.readColor(properties, "screen.loading", this.colorBackground);
                this.colorOutline = LoadingOverlay.readColor(properties, "screen.loading.outline", this.colorOutline);
                this.colorBar = LoadingOverlay.readColor(properties, "screen.loading.bar", this.colorBar);
                this.colorProgress = LoadingOverlay.readColor(properties, "screen.loading.progress", this.colorProgress);
                this.blendState = ShaderPackParser.parseBlendState(properties.getProperty("screen.loading.blend"));
            }
            catch (Exception exception) {
                Config.warn(String.valueOf(exception.getClass().getName()) + ": " + exception.getMessage());
            }
        }
    }

    private static int readColor(Properties props, String name, int colDef) {
        String s = props.getProperty(name);
        if (s == null) {
            return colDef;
        }
        int i = LoadingOverlay.parseColor(s = s.trim(), colDef);
        if (i < 0) {
            Config.warn("Invalid color: " + name + " = " + s);
            return i;
        }
        Config.dbg(String.valueOf(name) + " = " + s);
        return i;
    }

    private static int parseColor(String str, int colDef) {
        if (str == null) {
            return colDef;
        }
        str = str.trim();
        try {
            return Integer.parseInt(str, 16) & 0xFFFFFF;
        }
        catch (NumberFormatException numberformatexception) {
            return colDef;
        }
    }

    public boolean isFadeOut() {
        return this.fadeOut;
    }

    static class LogoTexture
    extends SimpleTexture {
        public LogoTexture() {
            super(MOJANG_STUDIOS_LOGO_LOCATION);
        }

        @Override
        protected SimpleTexture.TextureImage getTextureImage(ResourceManager pResourceManager) {
            Minecraft minecraft = Minecraft.getInstance();
            VanillaPackResources vanillapackresources = minecraft.getClientPackSource().getVanillaPack();
            try {
                SimpleTexture.TextureImage simpletexture$textureimage;
                try (InputStream inputstream = LogoTexture.getLogoInputStream(pResourceManager, vanillapackresources);){
                    simpletexture$textureimage = new SimpleTexture.TextureImage(new TextureMetadataSection(true, true), NativeImage.read(inputstream));
                }
                return simpletexture$textureimage;
            }
            catch (IOException ioexception1) {
                return new SimpleTexture.TextureImage(ioexception1);
            }
        }

        private static InputStream getLogoInputStream(ResourceManager resourceManager, VanillaPackResources vanillapack) throws IOException {
            return resourceManager.hasResource(MOJANG_STUDIOS_LOGO_LOCATION) ? resourceManager.getResource(MOJANG_STUDIOS_LOGO_LOCATION).getInputStream() : vanillapack.getResource(PackType.CLIENT_RESOURCES, MOJANG_STUDIOS_LOGO_LOCATION);
        }
    }
}

