/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.realmsclient.RealmsMainScreen;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.network.chat.TranslatableComponent;

public class PauseScreen
extends Screen {
    private static final String URL_FEEDBACK_SNAPSHOT = "https://aka.ms/snapshotfeedback?ref=game";
    private static final String URL_FEEDBACK_RELEASE = "https://aka.ms/javafeedback?ref=game";
    private static final String URL_BUGS = "https://aka.ms/snapshotbugs?ref=game";
    private final boolean showPauseMenu;

    public PauseScreen(boolean pShowPauseMenu) {
        super(pShowPauseMenu ? new TranslatableComponent("menu.game") : new TranslatableComponent("menu.paused"));
        this.showPauseMenu = pShowPauseMenu;
    }

    @Override
    protected void init() {
        if (this.showPauseMenu) {
            this.createPauseMenu();
        }
    }

    private void createPauseMenu() {
        int i = -16;
        int j = 98;
        this.addRenderableWidget(new Button(this.width / 2 - 102, this.height / 4 + 24 + -16, 204, 20, new TranslatableComponent("menu.returnToGame"), p_96337_ -> {
            this.minecraft.setScreen(null);
            this.minecraft.mouseHandler.grabMouse();
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 102, this.height / 4 + 48 + -16, 98, 20, new TranslatableComponent("gui.advancements"), p_96335_ -> this.minecraft.setScreen(new AdvancementsScreen(this.minecraft.player.connection.getAdvancements()))));
        this.addRenderableWidget(new Button(this.width / 2 + 4, this.height / 4 + 48 + -16, 98, 20, new TranslatableComponent("gui.stats"), p_96333_ -> this.minecraft.setScreen(new StatsScreen(this, this.minecraft.player.getStats()))));
        String s = SharedConstants.getCurrentVersion().isStable() ? URL_FEEDBACK_RELEASE : URL_FEEDBACK_SNAPSHOT;
        this.addRenderableWidget(new Button(this.width / 2 - 102, this.height / 4 + 72 + -16, 98, 20, new TranslatableComponent("menu.sendFeedback"), p_96318_ -> this.minecraft.setScreen(new ConfirmLinkScreen(p_169337_ -> {
            if (p_169337_) {
                Util.getPlatform().openUri(s);
            }
            this.minecraft.setScreen(this);
        }, s, true))));
        this.addRenderableWidget(new Button(this.width / 2 + 4, this.height / 4 + 72 + -16, 98, 20, new TranslatableComponent("menu.reportBugs"), p_96331_ -> this.minecraft.setScreen(new ConfirmLinkScreen(p_169339_ -> {
            if (p_169339_) {
                Util.getPlatform().openUri(URL_BUGS);
            }
            this.minecraft.setScreen(this);
        }, URL_BUGS, true))));
        this.addRenderableWidget(new Button(this.width / 2 - 102, this.height / 4 + 96 + -16, 98, 20, new TranslatableComponent("menu.options"), p_96323_ -> this.minecraft.setScreen(new OptionsScreen(this, this.minecraft.options))));
        Button button = this.addRenderableWidget(new Button(this.width / 2 + 4, this.height / 4 + 96 + -16, 98, 20, new TranslatableComponent("menu.shareToLan"), p_96321_ -> this.minecraft.setScreen(new ShareToLanScreen(this))));
        button.active = this.minecraft.hasSingleplayerServer() && !this.minecraft.getSingleplayerServer().isPublished();
        TranslatableComponent component = this.minecraft.isLocalServer() ? new TranslatableComponent("menu.returnToMenu") : new TranslatableComponent("menu.disconnect");
        this.addRenderableWidget(new Button(this.width / 2 - 102, this.height / 4 + 120 + -16, 204, 20, component, p_96315_ -> {
            boolean flag = this.minecraft.isLocalServer();
            boolean flag1 = this.minecraft.isConnectedToRealms();
            p_96315_.active = false;
            this.minecraft.level.disconnect();
            if (flag) {
                this.minecraft.clearLevel(new GenericDirtMessageScreen(new TranslatableComponent("menu.savingLevel")));
            } else {
                this.minecraft.clearLevel();
            }
            TitleScreen titlescreen = new TitleScreen();
            if (flag) {
                this.minecraft.setScreen(titlescreen);
            } else if (flag1) {
                this.minecraft.setScreen(new RealmsMainScreen(titlescreen));
            } else {
                this.minecraft.setScreen(new JoinMultiplayerScreen(titlescreen));
            }
        }));
    }

    @Override
    public void tick() {
        super.tick();
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.showPauseMenu) {
            this.renderBackground(pPoseStack);
            PauseScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        } else {
            PauseScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 10, 0xFFFFFF);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

