/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.ProgressListener;
import net.optifine.CustomLoadingScreen;
import net.optifine.CustomLoadingScreens;

public class ProgressScreen
extends Screen
implements ProgressListener {
    @Nullable
    private Component header;
    @Nullable
    private Component stage;
    private int progress;
    private boolean stop;
    private final boolean clearScreenAfterStop;
    private CustomLoadingScreen customLoadingScreen;

    public ProgressScreen(boolean pClearScreenAfterStop) {
        super(NarratorChatListener.NO_TITLE);
        this.clearScreenAfterStop = pClearScreenAfterStop;
        this.customLoadingScreen = CustomLoadingScreens.getCustomLoadingScreen();
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void progressStartNoAbort(Component pComponent) {
        this.progressStart(pComponent);
    }

    @Override
    public void progressStart(Component pComponent) {
        this.header = pComponent;
        this.progressStage(new TranslatableComponent("progress.working"));
    }

    @Override
    public void progressStage(Component pComponent) {
        this.stage = pComponent;
        this.progressStagePercentage(0);
    }

    @Override
    public void progressStagePercentage(int pProgress) {
        this.progress = pProgress;
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.stop) {
            if (this.clearScreenAfterStop) {
                this.minecraft.setScreen(null);
            }
        } else {
            if (this.customLoadingScreen != null && this.minecraft.level == null) {
                this.customLoadingScreen.drawBackground(this.width, this.height);
            } else {
                this.renderBackground(pPoseStack);
            }
            if (this.progress > 0) {
                if (this.header != null) {
                    ProgressScreen.drawCenteredString(pPoseStack, this.font, this.header, this.width / 2, 70, 0xFFFFFF);
                }
                if (this.stage != null && this.progress != 0) {
                    ProgressScreen.drawCenteredString(pPoseStack, this.font, new TextComponent("").append(this.stage).append(" " + this.progress + "%"), this.width / 2, 90, 0xFFFFFF);
                }
            }
            super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }
}

