/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;

public class ShareToLanScreen
extends Screen {
    private static final Component ALLOW_COMMANDS_LABEL = new TranslatableComponent("selectWorld.allowCommands");
    private static final Component GAME_MODE_LABEL = new TranslatableComponent("selectWorld.gameMode");
    private static final Component INFO_TEXT = new TranslatableComponent("lanServer.otherPlayers");
    private final Screen lastScreen;
    private GameType gameMode = GameType.SURVIVAL;
    private boolean commands;

    public ShareToLanScreen(Screen pLastScreen) {
        super(new TranslatableComponent("lanServer.title"));
        this.lastScreen = pLastScreen;
    }

    @Override
    protected void init() {
        this.addRenderableWidget(CycleButton.builder(GameType::getShortDisplayName).a((GameType[])new GameType[]{GameType.SURVIVAL, GameType.SPECTATOR, GameType.CREATIVE, GameType.ADVENTURE}).withInitialValue(this.gameMode).create(this.width / 2 - 155, 100, 150, 20, GAME_MODE_LABEL, (p_169429_, p_169430_) -> {
            this.gameMode = p_169430_;
        }));
        this.addRenderableWidget(CycleButton.onOffBuilder(this.commands).create(this.width / 2 + 5, 100, 150, 20, ALLOW_COMMANDS_LABEL, (p_169432_, p_169433_) -> {
            this.commands = p_169433_;
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 155, this.height - 28, 150, 20, new TranslatableComponent("lanServer.start"), p_96660_ -> {
            this.minecraft.setScreen(null);
            int i = HttpUtil.getAvailablePort();
            TranslatableComponent component = this.minecraft.getSingleplayerServer().publishServer(this.gameMode, this.commands, i) ? new TranslatableComponent("commands.publish.started", i) : new TranslatableComponent("commands.publish.failed");
            this.minecraft.gui.getChat().addMessage(component);
            this.minecraft.updateTitle();
        }));
        this.addRenderableWidget(new Button(this.width / 2 + 5, this.height - 28, 150, 20, CommonComponents.GUI_CANCEL, p_96657_ -> this.minecraft.setScreen(this.lastScreen)));
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        ShareToLanScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 50, 0xFFFFFF);
        ShareToLanScreen.drawCenteredString(pPoseStack, this.font, INFO_TEXT, this.width / 2, 82, 0xFFFFFF);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

