/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.util.concurrent.Runnables;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.math.Vector3f;
import com.mojang.realmsclient.RealmsMainScreen;
import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.RealmsNotificationsScreen;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.OptionsScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.Realms32bitWarningScreen;
import net.minecraft.client.gui.screens.multiplayer.SafetyScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorForge;
import org.slf4j.Logger;

public class TitleScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEMO_LEVEL_ID = "Demo_World";
    public static final Component COPYRIGHT_TEXT = new TextComponent("");
    public static final CubeMap CUBE_MAP = new CubeMap(new ResourceLocation("textures/gui/title/background/panorama"));
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation ACCESSIBILITY_TEXTURE = new ResourceLocation("textures/gui/accessibility.png");
    private final boolean minceraftEasterEgg;
    @Nullable
    private String splash;
    private Button resetDemoButton;
    private static final ResourceLocation CUSTOM_BACKGROUND = new ResourceLocation("textures/gui/title/bg.png");
    private static final ResourceLocation MINECRAFT_LOGO = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation MINECRAFT_EDITION = new ResourceLocation("textures/gui/title/edition.png");
    private Screen realmsNotificationsScreen;
    private final PanoramaRenderer panorama = new PanoramaRenderer(CUBE_MAP);
    private final boolean fading;
    private long fadeInStart;
    @Nullable
    private Warning32Bit warning32Bit;
    private RealmsClient realmsClient;
    private boolean realms32bitWarningShown = false;
    private Screen modUpdateNotification;

    public TitleScreen() {
        this(false);
    }

    public TitleScreen(boolean pFading) {
        super(new TranslatableComponent("narrator.screen.title"));
        this.fading = pFading;
        this.minceraftEasterEgg = (double)new Random().nextFloat() < 1.0E-4;
        this.realmsClient = RealmsClient.create();
    }

    private boolean realmsNotificationsEnabled() {
        return this.minecraft.options.realmsNotifications && this.realmsNotificationsScreen != null;
    }

    @Override
    public void tick() {
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.tick();
        }
        this.showRealms32BitWarningIfNeeded();
    }

    private void showRealms32BitWarningIfNeeded() {
        try {
            if (this.warning32Bit != null && !this.minecraft.options.skipRealms32bitWarning && !this.realms32bitWarningShown && this.warning32Bit.realmsSubscriptionFuture.getNow(false).booleanValue()) {
                this.realms32bitWarningShown = true;
                this.minecraft.setScreen(new Realms32bitWarningScreen(this));
            }
        }
        catch (CompletionException completionexception) {
            LOGGER.warn("Failed to retrieve realms subscriptions", (Throwable)completionexception);
            this.realms32bitWarningShown = true;
        }
    }

    public static CompletableFuture<Void> preloadResources(TextureManager pTexMngr, Executor pBackgroundExecutor) {
        return CompletableFuture.allOf(pTexMngr.preload(MINECRAFT_LOGO, pBackgroundExecutor), pTexMngr.preload(MINECRAFT_EDITION, pBackgroundExecutor), pTexMngr.preload(PANORAMA_OVERLAY, pBackgroundExecutor), CUBE_MAP.preload(pTexMngr, pBackgroundExecutor));
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    protected void init() {
        if (this.splash == null) {
            this.splash = this.minecraft.getSplashManager().getSplash();
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new Date());
            int i = calendar.get(5);
            int j = calendar.get(2) + 1;
            if (i == 8 && j == 4) {
                this.splash = "Happy birthday, OptiFine!";
            }
            if (i == 14 && j == 8) {
                this.splash = "Happy birthday, sp614x!";
            }
        }
        int l = this.font.width(COPYRIGHT_TEXT);
        int i1 = this.width - l - 2;
        int j1 = 24;
        int k = this.height / 4 + 48;
        Button button = null;
        if (this.minecraft.isDemo()) {
            this.createDemoMenuOptions(k, 24);
        } else {
            this.createNormalMenuOptions(k, 24);
            if (Reflector.ModListScreen_Constructor.exists()) {
                button = ReflectorForge.makeButtonMods(this, k, 24);
                this.addRenderableWidget(button);
            }
        }
        this.addRenderableWidget(new Button(this.width / 2 - 100, k + 72 + 12, 98, 20, new TranslatableComponent("menu.options"), p_96787_1_ -> this.minecraft.setScreen(new OptionsScreen(this, this.minecraft.options))));
        this.addRenderableWidget(new Button(this.width / 2 + 2, k + 72 + 12, 98, 20, new TranslatableComponent("menu.quit"), p_96785_1_ -> this.minecraft.stop()));
        this.addRenderableWidget(new PlainTextButton(i1, this.height - 10, l, 10, COPYRIGHT_TEXT, p_211789_1_ -> this.minecraft.setScreen(new WinScreen(false, Runnables.doNothing())), this.font));
        this.minecraft.setConnectedToRealms(false);
        if (this.minecraft.options.realmsNotifications && this.realmsNotificationsScreen == null) {
            this.realmsNotificationsScreen = new RealmsNotificationsScreen();
        }
        if (this.realmsNotificationsEnabled()) {
            this.realmsNotificationsScreen.init(this.minecraft, this.width, this.height);
        }
        if (!this.minecraft.is64Bit()) {
            CompletableFuture<Boolean> completablefuture = this.warning32Bit != null ? this.warning32Bit.realmsSubscriptionFuture : CompletableFuture.supplyAsync(this::hasRealmsSubscription, Util.backgroundExecutor());
            this.warning32Bit = new Warning32Bit(MultiLineLabel.create(this.font, new TranslatableComponent("title.32bit.deprecation"), 350, 2), this.width / 2, k - 24, completablefuture);
        }
        if (Reflector.NotificationModUpdateScreen_init.exists()) {
            this.modUpdateNotification = (Screen)Reflector.call(Reflector.NotificationModUpdateScreen_init, this, button);
        }
    }

    private boolean hasRealmsSubscription() {
        try {
            return this.realmsClient.listWorlds().servers.stream().anyMatch(p_211780_1_ -> p_211780_1_.ownerUUID != null && !p_211780_1_.expired && p_211780_1_.ownerUUID.equals(this.minecraft.getUser().getUuid()));
        }
        catch (RealmsServiceException realmsserviceexception) {
            return false;
        }
    }

    private void createNormalMenuOptions(int pY, int pRowHeight) {
        this.addRenderableWidget(new Button(this.width / 2 - 100, pY, 200, 20, new TranslatableComponent("menu.singleplayer"), p_96775_1_ -> this.minecraft.setScreen(new SelectWorldScreen(this))));
        boolean flag = this.minecraft.allowsMultiplayer();
        Button.OnTooltip button$ontooltip = flag ? Button.NO_TOOLTIP : new Button.OnTooltip(){
            private final Component text = new TranslatableComponent("title.multiplayer.disabled");

            @Override
            public void onTooltip(Button p_169458_, PoseStack p_169459_, int p_169460_, int p_169461_) {
                if (!p_169458_.active) {
                    TitleScreen.this.renderTooltip(p_169459_, TitleScreen.this.minecraft.font.split(this.text, Math.max(TitleScreen.this.width / 2 - 43, 170)), p_169460_, p_169461_);
                }
            }

            @Override
            public void narrateTooltip(Consumer<Component> p_169456_) {
                p_169456_.accept(this.text);
            }
        };
        this.addRenderableWidget(new Button((int)(this.width / 2 - 100), (int)(pY + pRowHeight * 1), (int)200, (int)20, (Component)new TranslatableComponent((String)"menu.multiplayer"), (Button.OnPress)(Button.OnPress)LambdaMetafactory.metafactory(null, null, null, (Lnet/minecraft/client/gui/components/Button;)V, lambda$6(net.minecraft.client.gui.components.Button ), (Lnet/minecraft/client/gui/components/Button;)V)((TitleScreen)this), (Button.OnTooltip)button$ontooltip)).active = flag;
        boolean flag1 = Reflector.ModListScreen_Constructor.exists();
        int i = flag1 ? this.width / 2 + 2 : this.width / 2 - 100;
        int j = flag1 ? 98 : 200;
    }

    private void createDemoMenuOptions(int pY, int pRowHeight) {
        boolean flag = this.checkDemoWorldPresence();
        this.addRenderableWidget(new Button(this.width / 2 - 100, pY, 200, 20, new TranslatableComponent("menu.playdemo"), p_211784_2_ -> {
            if (flag) {
                this.minecraft.loadLevel(DEMO_LEVEL_ID);
            } else {
                RegistryAccess registryaccess = RegistryAccess.BUILTIN.get();
                this.minecraft.createLevel(DEMO_LEVEL_ID, MinecraftServer.DEMO_SETTINGS, registryaccess, WorldGenSettings.demoSettings(registryaccess));
            }
        }));
        this.resetDemoButton = this.addRenderableWidget(new Button(this.width / 2 - 100, pY + pRowHeight * 1, 200, 20, new TranslatableComponent("menu.resetdemo"), p_211782_1_ -> {
            LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.createAccess(DEMO_LEVEL_ID);){
                LevelSummary levelsummary = levelstoragesource$levelstorageaccess.getSummary();
                if (levelsummary != null) {
                    this.minecraft.setScreen(new ConfirmScreen(this::confirmDemo, new TranslatableComponent("selectWorld.deleteQuestion"), new TranslatableComponent("selectWorld.deleteWarning", levelsummary.getLevelName()), new TranslatableComponent("selectWorld.deleteButton"), CommonComponents.GUI_CANCEL));
                }
            }
            catch (IOException ioexception1) {
                SystemToast.onWorldAccessFailure(this.minecraft, DEMO_LEVEL_ID);
                LOGGER.warn("Failed to access demo world", (Throwable)ioexception1);
            }
        }));
        this.resetDemoButton.active = flag;
    }

    private boolean checkDemoWorldPresence() {
        try {
            boolean flag;
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().createAccess(DEMO_LEVEL_ID);){
                flag = levelstoragesource$levelstorageaccess.getSummary() != null;
            }
            return flag;
        }
        catch (IOException ioexception1) {
            SystemToast.onWorldAccessFailure(this.minecraft, DEMO_LEVEL_ID);
            LOGGER.warn("Failed to read demo world data", (Throwable)ioexception1);
            return false;
        }
    }

    private void realmsButtonClicked() {
        this.minecraft.setScreen(new RealmsMainScreen(this));
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        String username;
        if (this.fadeInStart == 0L && this.fading) {
            this.fadeInStart = Util.getMillis();
        }
        float f = this.fading ? (float)(Util.getMillis() - this.fadeInStart) / 1000.0f : 1.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, CUSTOM_BACKGROUND);
        TitleScreen.blit(pPoseStack, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        String customText = username = Minecraft.getInstance().player != null ? Minecraft.getInstance().player.getDisplayName().getString() : Minecraft.getInstance().getUser().getName();
        int textWidth = this.font.width(customText);
        int xPos = this.width - textWidth - 5;
        int yPos = 5;
        this.font.drawShadow(pPoseStack, customText, (float)xPos, (float)yPos, 0xFFFFFF);
        int i = 274;
        int j = this.width / 2 - 137;
        int k = 30;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, PANORAMA_OVERLAY);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, this.fading ? (float)Mth.ceil(Mth.clamp(f, 0.0f, 1.0f)) : 1.0f);
        TitleScreen.blit(pPoseStack, 0, 0, this.width, this.height, 0.0f, 0.0f, 16, 128, 16, 128);
        float f1 = this.fading ? Mth.clamp(f - 1.0f, 0.0f, 1.0f) : 1.0f;
        int l = Mth.ceil(f1 * 255.0f) << 24;
        if ((l & 0xFC000000) != 0) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, MINECRAFT_LOGO);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, f1);
            if (this.minceraftEasterEgg) {
                this.blitOutlineBlack(j, 30, (p_210860_2_, p_210860_3_) -> {
                    this.blit(pPoseStack, p_210860_2_ + 0, (int)p_210860_3_, 0, 0, 99, 44);
                    this.blit(pPoseStack, p_210860_2_ + 99, (int)p_210860_3_, 129, 0, 27, 44);
                    this.blit(pPoseStack, p_210860_2_ + 99 + 26, (int)p_210860_3_, 126, 0, 3, 44);
                    this.blit(pPoseStack, p_210860_2_ + 99 + 26 + 3, (int)p_210860_3_, 99, 0, 26, 44);
                    this.blit(pPoseStack, p_210860_2_ + 155, (int)p_210860_3_, 0, 45, 155, 44);
                });
            } else {
                this.blitOutlineBlack(j, 30, (p_211776_2_, p_211776_3_) -> {
                    this.blit(pPoseStack, p_211776_2_ + 0, (int)p_211776_3_, 0, 0, 155, 44);
                    this.blit(pPoseStack, p_211776_2_ + 155, (int)p_211776_3_, 0, 45, 155, 44);
                });
            }
            RenderSystem.setShaderTexture(0, MINECRAFT_EDITION);
            TitleScreen.blit(pPoseStack, j + 88, 67, 0.0f, 0.0f, 98, 14, 128, 16);
            if (this.warning32Bit != null) {
                this.warning32Bit.label.renderBackgroundCentered(pPoseStack, this.warning32Bit.x, this.warning32Bit.y, 9, 2, 0x55200000);
                this.warning32Bit.label.renderCentered(pPoseStack, this.warning32Bit.x, this.warning32Bit.y, 9, 0xFFFFFF | l);
            }
            if (Reflector.ForgeHooksClient_renderMainMenu.exists()) {
                Reflector.callVoid(Reflector.ForgeHooksClient_renderMainMenu, this, pPoseStack, this.font, this.width, this.height, l);
            }
            if (this.splash != null) {
                pPoseStack.pushPose();
                pPoseStack.translate(this.width / 2 + 90, 70.0, 0.0);
                pPoseStack.mulPose(Vector3f.ZP.rotationDegrees(-20.0f));
                float f2 = 1.8f - Mth.abs(Mth.sin((float)(Util.getMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2)) * 0.1f);
                f2 = f2 * 100.0f / (float)(this.font.width(this.splash) + 32);
                pPoseStack.scale(f2, f2, f2);
                TitleScreen.drawCenteredString(pPoseStack, this.font, "Made by: Dominikhun250", 0, -8, 0x8BFF | l);
                pPoseStack.popPose();
            }
            String s = "DiamondClient 1.18.2";
            s = this.minecraft.isDemo() ? String.valueOf(s) + " Demo" : String.valueOf(s) + ("release".equalsIgnoreCase(this.minecraft.getVersionType()) ? "" : "/" + this.minecraft.getVersionType());
            if (Minecraft.checkModStatus().shouldReportAsModified()) {
                s = String.valueOf(s) + I18n.a("menu.modded", new Object[0]);
            }
            if (Reflector.BrandingControl.exists()) {
                if (Reflector.BrandingControl_forEachLine.exists()) {
                    BiConsumer<Integer, String> biConsumer = (brdline, brd) -> TitleScreen.drawString(pPoseStack, this.font, brd, 2, this.height - (10 + brdline * 10), 0xFFFFFF | l);
                    Reflector.call(Reflector.BrandingControl_forEachLine, true, true, biConsumer);
                }
                if (Reflector.BrandingControl_forEachAboveCopyrightLine.exists()) {
                    BiConsumer<Integer, String> biConsumer = (brdline, brd) -> TitleScreen.drawString(pPoseStack, this.font, brd, this.width - this.font.width((String)brd), this.height - (10 + (brdline + 1) * 10), 0xFFFFFF | l);
                    Reflector.call(Reflector.BrandingControl_forEachAboveCopyrightLine, biConsumer);
                }
            } else {
                TitleScreen.drawString(pPoseStack, this.font, s, 2, this.height - 10, 0xFFFFFF | l);
            }
            for (GuiEventListener guiEventListener : this.children()) {
                if (!(guiEventListener instanceof AbstractWidget)) continue;
                ((AbstractWidget)guiEventListener).setAlpha(f1);
            }
            super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            if (this.realmsNotificationsEnabled() && f1 >= 1.0f) {
                this.realmsNotificationsScreen.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
        }
        if (this.modUpdateNotification != null && f1 >= 1.0f) {
            this.modUpdateNotification.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_96736_, int pMouseY) {
        if (super.mouseClicked(pMouseX, p_96736_, pMouseY)) {
            return true;
        }
        return this.realmsNotificationsEnabled() && this.realmsNotificationsScreen.mouseClicked(pMouseX, p_96736_, pMouseY);
    }

    @Override
    public void removed() {
        if (this.realmsNotificationsScreen != null) {
            this.realmsNotificationsScreen.removed();
        }
    }

    private void confirmDemo(boolean p_96778_) {
        if (p_96778_) {
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().createAccess(DEMO_LEVEL_ID);){
                levelstoragesource$levelstorageaccess.deleteLevel();
            }
            catch (IOException ioexception1) {
                SystemToast.onWorldDeleteFailure(this.minecraft, DEMO_LEVEL_ID);
                LOGGER.warn("Failed to delete demo world", (Throwable)ioexception1);
            }
        }
        this.minecraft.setScreen(this);
    }

    private /* synthetic */ void lambda$6(Button p_210871_1_) {
        Screen screen = this.minecraft.options.skipMultiplayerWarning ? new JoinMultiplayerScreen(this) : new SafetyScreen(this);
        this.minecraft.setScreen(screen);
    }

    record Warning32Bit(MultiLineLabel label, int x, int y, CompletableFuture<Boolean> realmsSubscriptionFuture) {
    }
}

