/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;

public class WinScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation LOGO_LOCATION = new ResourceLocation("textures/gui/title/minecraft.png");
    private static final ResourceLocation EDITION_LOCATION = new ResourceLocation("textures/gui/title/edition.png");
    private static final ResourceLocation VIGNETTE_LOCATION = new ResourceLocation("textures/misc/vignette.png");
    private static final Component SECTION_HEADING = new TextComponent("============").withStyle(ChatFormatting.WHITE);
    private static final String NAME_PREFIX = "           ";
    private static final String OBFUSCATE_TOKEN = "" + (Object)((Object)ChatFormatting.WHITE) + (Object)((Object)ChatFormatting.OBFUSCATED) + (Object)((Object)ChatFormatting.GREEN) + (Object)((Object)ChatFormatting.AQUA);
    private static final int LOGO_WIDTH = 274;
    private static final float SPEEDUP_FACTOR = 5.0f;
    private static final float SPEEDUP_FACTOR_FAST = 15.0f;
    private final boolean poem;
    private final Runnable onFinished;
    private float scroll;
    private List<FormattedCharSequence> lines;
    private IntSet centeredLines;
    private int totalScrollLength;
    private boolean speedupActive;
    private final IntSet speedupModifiers = new IntOpenHashSet();
    private float scrollSpeed;
    private final float unmodifiedScrollSpeed;

    public WinScreen(boolean pPoem, Runnable pOnFinished) {
        super(NarratorChatListener.NO_TITLE);
        this.poem = pPoem;
        this.onFinished = pOnFinished;
        this.unmodifiedScrollSpeed = !pPoem ? 0.75f : 0.5f;
        this.scrollSpeed = this.unmodifiedScrollSpeed;
    }

    private float calculateScrollSpeed() {
        return this.speedupActive ? this.unmodifiedScrollSpeed * (5.0f + (float)this.speedupModifiers.size() * 15.0f) : this.unmodifiedScrollSpeed;
    }

    @Override
    public void tick() {
        this.minecraft.getMusicManager().tick();
        this.minecraft.getSoundManager().tick(false);
        float f = this.totalScrollLength + this.height + this.height + 24;
        if (this.scroll > f) {
            this.respawn();
        }
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode != 341 && pKeyCode != 345) {
            if (pKeyCode == 32) {
                this.speedupActive = true;
            }
        } else {
            this.speedupModifiers.add(pKeyCode);
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 32) {
            this.speedupActive = false;
        } else if (pKeyCode == 341 || pKeyCode == 345) {
            this.speedupModifiers.remove(pKeyCode);
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public void onClose() {
        this.respawn();
    }

    private void respawn() {
        this.onFinished.run();
        this.minecraft.setScreen(null);
    }

    @Override
    protected void init() {
        if (this.lines == null) {
            this.lines = Lists.newArrayList();
            this.centeredLines = new IntOpenHashSet();
            if (this.poem) {
                this.wrapCreditsIO("texts/end.txt", this::addPoemFile);
            }
            this.wrapCreditsIO("texts/credits.json", this::addCreditsFile);
            if (this.poem) {
                this.wrapCreditsIO("texts/postcredits.txt", this::addPoemFile);
            }
            this.totalScrollLength = this.lines.size() * 12;
        }
    }

    private void wrapCreditsIO(String p_197399_, CreditsReader p_197400_) {
        block5: {
            Resource resource = null;
            try {
                try {
                    resource = this.minecraft.getResourceManager().getResource(new ResourceLocation(p_197399_));
                    InputStreamReader inputstreamreader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);
                    p_197400_.read(inputstreamreader);
                }
                catch (Exception exception) {
                    LOGGER.error("Couldn't load credits", (Throwable)exception);
                    IOUtils.closeQuietly(resource);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)resource);
        }
    }

    private void addPoemFile(InputStreamReader p_197397_) throws IOException {
        String s;
        BufferedReader bufferedreader = new BufferedReader(p_197397_);
        Random random = new Random(8124371L);
        while ((s = bufferedreader.readLine()) != null) {
            int i;
            s = s.replaceAll("PLAYERNAME", this.minecraft.getUser().getName());
            while ((i = s.indexOf(OBFUSCATE_TOKEN)) != -1) {
                String s1 = s.substring(0, i);
                String s2 = s.substring(i + OBFUSCATE_TOKEN.length());
                s = String.valueOf(s1) + (Object)((Object)ChatFormatting.WHITE) + (Object)((Object)ChatFormatting.OBFUSCATED) + "XXXXXXXX".substring(0, random.nextInt(4) + 3) + s2;
            }
            this.addPoemLines(s);
            this.addEmptyLine();
        }
        int j = 0;
        while (j < 8) {
            this.addEmptyLine();
            ++j;
        }
    }

    private void addCreditsFile(InputStreamReader p_197402_) {
        for (JsonElement jsonelement : GsonHelper.parseArray(p_197402_)) {
            JsonObject jsonobject = jsonelement.getAsJsonObject();
            String s = jsonobject.get("section").getAsString();
            this.addCreditsLine(SECTION_HEADING, true);
            this.addCreditsLine(new TextComponent(s).withStyle(ChatFormatting.YELLOW), true);
            this.addCreditsLine(SECTION_HEADING, true);
            this.addEmptyLine();
            this.addEmptyLine();
            for (JsonElement jsonelement1 : jsonobject.getAsJsonArray("titles")) {
                JsonObject jsonobject1 = jsonelement1.getAsJsonObject();
                String s1 = jsonobject1.get("title").getAsString();
                JsonArray jsonarray = jsonobject1.getAsJsonArray("names");
                this.addCreditsLine(new TextComponent(s1).withStyle(ChatFormatting.GRAY), false);
                for (JsonElement jsonelement2 : jsonarray) {
                    String s2 = jsonelement2.getAsString();
                    this.addCreditsLine(new TextComponent(NAME_PREFIX).append(s2).withStyle(ChatFormatting.WHITE), false);
                }
                this.addEmptyLine();
                this.addEmptyLine();
            }
        }
    }

    private void addEmptyLine() {
        this.lines.add(FormattedCharSequence.EMPTY);
    }

    private void addPoemLines(String pText) {
        this.lines.addAll(this.minecraft.font.split(new TextComponent(pText), 274));
    }

    private void addCreditsLine(Component p_169473_, boolean p_169474_) {
        if (p_169474_) {
            this.centeredLines.add(this.lines.size());
        }
        this.lines.add(p_169473_.getVisualOrderText());
    }

    private void renderBg() {
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture(0, GuiComponent.BACKGROUND_LOCATION);
        int i = this.width;
        float f = -this.scroll * 0.5f;
        float f1 = (float)this.height - 0.5f * this.scroll;
        float f2 = 0.015625f;
        float f3 = this.scroll / this.unmodifiedScrollSpeed;
        float f4 = f3 * 0.02f;
        float f5 = (float)(this.totalScrollLength + this.height + this.height + 24) / this.unmodifiedScrollSpeed;
        float f6 = (f5 - 20.0f - f3) * 0.005f;
        if (f6 < f4) {
            f4 = f6;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        f4 *= f4;
        f4 = f4 * 96.0f / 255.0f;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.vertex(0.0, this.height, this.getBlitOffset()).uv(0.0f, f * 0.015625f).color(f4, f4, f4, 1.0f).endVertex();
        bufferbuilder.vertex(i, this.height, this.getBlitOffset()).uv((float)i * 0.015625f, f * 0.015625f).color(f4, f4, f4, 1.0f).endVertex();
        bufferbuilder.vertex(i, 0.0, this.getBlitOffset()).uv((float)i * 0.015625f, f1 * 0.015625f).color(f4, f4, f4, 1.0f).endVertex();
        bufferbuilder.vertex(0.0, 0.0, this.getBlitOffset()).uv(0.0f, f1 * 0.015625f).color(f4, f4, f4, 1.0f).endVertex();
        tesselator.end();
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.scroll += pPartialTick * this.scrollSpeed;
        this.renderBg();
        int i = this.width / 2 - 137;
        int j = this.height + 50;
        float f = -this.scroll;
        pPoseStack.pushPose();
        pPoseStack.translate(0.0, f, 0.0);
        RenderSystem.setShaderTexture(0, LOGO_LOCATION);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.enableBlend();
        this.blitOutlineBlack(i, j, (p_96890_, p_96891_) -> {
            this.blit(pPoseStack, p_96890_ + 0, (int)p_96891_, 0, 0, 155, 44);
            this.blit(pPoseStack, p_96890_ + 155, (int)p_96891_, 0, 45, 155, 44);
        });
        RenderSystem.disableBlend();
        RenderSystem.setShaderTexture(0, EDITION_LOCATION);
        WinScreen.blit(pPoseStack, i + 88, j + 37, 0.0f, 0.0f, 98, 14, 128, 16);
        int k = j + 100;
        int l = 0;
        while (l < this.lines.size()) {
            float f1;
            if (l == this.lines.size() - 1 && (f1 = (float)k + f - (float)(this.height / 2 - 6)) < 0.0f) {
                pPoseStack.translate(0.0, -f1, 0.0);
            }
            if ((float)k + f + 12.0f + 8.0f > 0.0f && (float)k + f < (float)this.height) {
                FormattedCharSequence formattedcharsequence = this.lines.get(l);
                if (this.centeredLines.contains(l)) {
                    this.font.drawShadow(pPoseStack, formattedcharsequence, (float)(i + (274 - this.font.width(formattedcharsequence)) / 2), (float)k, 0xFFFFFF);
                } else {
                    this.font.drawShadow(pPoseStack, formattedcharsequence, (float)i, (float)k, 0xFFFFFF);
                }
            }
            k += 12;
            ++l;
        }
        pPoseStack.popPose();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture(0, VIGNETTE_LOCATION);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE_MINUS_SRC_COLOR);
        int i1 = this.width;
        int j1 = this.height;
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.getBuilder();
        bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.vertex(0.0, j1, this.getBlitOffset()).uv(0.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        bufferbuilder.vertex(i1, j1, this.getBlitOffset()).uv(1.0f, 1.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        bufferbuilder.vertex(i1, 0.0, this.getBlitOffset()).uv(1.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        bufferbuilder.vertex(0.0, 0.0, this.getBlitOffset()).uv(0.0f, 0.0f).color(1.0f, 1.0f, 1.0f, 1.0f).endVertex();
        tesselator.end();
        RenderSystem.disableBlend();
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    @FunctionalInterface
    static interface CreditsReader {
        public void read(InputStreamReader var1) throws IOException;
    }
}

