/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.controls;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.OptionsSubScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.controls.KeyBindsList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.TranslatableComponent;

public class KeyBindsScreen
extends OptionsSubScreen {
    @Nullable
    public KeyMapping selectedKey;
    public long lastKeySelection;
    private KeyBindsList keyBindsList;
    private Button resetButton;

    public KeyBindsScreen(Screen p_193980_, Options p_193981_) {
        super(p_193980_, p_193981_, new TranslatableComponent("controls.keybinds.title"));
    }

    @Override
    protected void init() {
        this.keyBindsList = new KeyBindsList(this, this.minecraft);
        this.addWidget(this.keyBindsList);
        this.resetButton = this.addRenderableWidget(new Button(this.width / 2 - 155, this.height - 29, 150, 20, new TranslatableComponent("controls.resetAll"), p_193999_ -> {
            KeyMapping[] keyMappingArray = this.options.keyMappings;
            int n = this.options.keyMappings.length;
            int n2 = 0;
            while (n2 < n) {
                KeyMapping keymapping = keyMappingArray[n2];
                keymapping.setKey(keymapping.getDefaultKey());
                ++n2;
            }
            KeyMapping.resetMapping();
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, CommonComponents.GUI_DONE, p_193996_ -> this.minecraft.setScreen(this.lastScreen)));
    }

    @Override
    public boolean mouseClicked(double p_193983_, double p_193984_, int p_193985_) {
        if (this.selectedKey != null) {
            this.options.setKey(this.selectedKey, InputConstants.Type.MOUSE.getOrCreate(p_193985_));
            this.selectedKey = null;
            KeyMapping.resetMapping();
            return true;
        }
        return super.mouseClicked(p_193983_, p_193984_, p_193985_);
    }

    @Override
    public boolean keyPressed(int p_193987_, int p_193988_, int p_193989_) {
        if (this.selectedKey != null) {
            if (p_193987_ == 256) {
                this.options.setKey(this.selectedKey, InputConstants.bv);
            } else {
                this.options.setKey(this.selectedKey, InputConstants.getKey(p_193987_, p_193988_));
            }
            this.selectedKey = null;
            this.lastKeySelection = Util.getMillis();
            KeyMapping.resetMapping();
            return true;
        }
        return super.keyPressed(p_193987_, p_193988_, p_193989_);
    }

    @Override
    public void render(PoseStack p_193991_, int p_193992_, int p_193993_, float p_193994_) {
        this.renderBackground(p_193991_);
        this.keyBindsList.render(p_193991_, p_193992_, p_193993_, p_193994_);
        KeyBindsScreen.drawCenteredString(p_193991_, this.font, this.title, this.width / 2, 8, 0xFFFFFF);
        boolean flag = false;
        KeyMapping[] keyMappingArray = this.options.keyMappings;
        int n = this.options.keyMappings.length;
        int n2 = 0;
        while (n2 < n) {
            KeyMapping keymapping = keyMappingArray[n2];
            if (!keymapping.isDefault()) {
                flag = true;
                break;
            }
            ++n2;
        }
        this.resetButton.active = flag;
        super.render(p_193991_, p_193992_, p_193993_, p_193994_);
    }
}

