/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.debug;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Blocks;

public class GameModeSwitcherScreen
extends Screen {
    static final ResourceLocation GAMEMODE_SWITCHER_LOCATION = new ResourceLocation("textures/gui/container/gamemode_switcher.png");
    private static final int SPRITE_SHEET_WIDTH = 128;
    private static final int SPRITE_SHEET_HEIGHT = 128;
    private static final int SLOT_AREA = 26;
    private static final int SLOT_PADDING = 5;
    private static final int SLOT_AREA_PADDED = 31;
    private static final int HELP_TIPS_OFFSET_Y = 5;
    private static final int ALL_SLOTS_WIDTH = GameModeIcon.values().length * 31 - 5;
    private static final Component SELECT_KEY = new TranslatableComponent("debug.gamemodes.select_next", new TranslatableComponent("debug.gamemodes.press_f4").withStyle(ChatFormatting.AQUA));
    private final Optional<GameModeIcon> previousHovered;
    private Optional<GameModeIcon> currentlyHovered = Optional.empty();
    private int firstMouseX;
    private int firstMouseY;
    private boolean setFirstMousePos;
    private final List<GameModeSlot> slots = Lists.newArrayList();

    public GameModeSwitcherScreen() {
        super(NarratorChatListener.NO_TITLE);
        this.previousHovered = GameModeIcon.getFromGameType(this.getDefaultSelected());
    }

    private GameType getDefaultSelected() {
        MultiPlayerGameMode multiplayergamemode = Minecraft.getInstance().gameMode;
        GameType gametype = multiplayergamemode.getPreviousPlayerMode();
        if (gametype != null) {
            return gametype;
        }
        return multiplayergamemode.getPlayerMode() == GameType.CREATIVE ? GameType.SURVIVAL : GameType.CREATIVE;
    }

    @Override
    protected void init() {
        super.init();
        this.currentlyHovered = this.previousHovered.isPresent() ? this.previousHovered : GameModeIcon.getFromGameType(this.minecraft.gameMode.getPlayerMode());
        int i = 0;
        while (i < GameModeIcon.VALUES.length) {
            GameModeIcon gamemodeswitcherscreen$gamemodeicon = GameModeIcon.VALUES[i];
            this.slots.add(new GameModeSlot(gamemodeswitcherscreen$gamemodeicon, this.width / 2 - ALL_SLOTS_WIDTH / 2 + i * 31, this.height / 2 - 31));
            ++i;
        }
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (!this.checkToClose()) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            pPoseStack.pushPose();
            RenderSystem.enableBlend();
            RenderSystem.setShaderTexture(0, GAMEMODE_SWITCHER_LOCATION);
            int i = this.width / 2 - 62;
            int j = this.height / 2 - 31 - 27;
            GameModeSwitcherScreen.blit(pPoseStack, i, j, 0.0f, 0.0f, 125, 75, 128, 128);
            pPoseStack.popPose();
            super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            this.currentlyHovered.ifPresent(p_97563_ -> GameModeSwitcherScreen.drawCenteredString(pPoseStack, this.font, p_97563_.getName(), this.width / 2, this.height / 2 - 31 - 20, -1));
            GameModeSwitcherScreen.drawCenteredString(pPoseStack, this.font, SELECT_KEY, this.width / 2, this.height / 2 + 5, 0xFFFFFF);
            if (!this.setFirstMousePos) {
                this.firstMouseX = pMouseX;
                this.firstMouseY = pMouseY;
                this.setFirstMousePos = true;
            }
            boolean flag = this.firstMouseX == pMouseX && this.firstMouseY == pMouseY;
            for (GameModeSlot gamemodeswitcherscreen$gamemodeslot : this.slots) {
                gamemodeswitcherscreen$gamemodeslot.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
                this.currentlyHovered.ifPresent(p_97569_ -> gamemodeswitcherscreen$gamemodeslot.setSelected(p_97569_ == gameModeSlot.icon));
                if (flag || !gamemodeswitcherscreen$gamemodeslot.isHoveredOrFocused()) continue;
                this.currentlyHovered = Optional.of(gamemodeswitcherscreen$gamemodeslot.icon);
            }
        }
    }

    private void switchToHoveredGameMode() {
        GameModeSwitcherScreen.switchToHoveredGameMode(this.minecraft, this.currentlyHovered);
    }

    private static void switchToHoveredGameMode(Minecraft p_97565_, Optional<GameModeIcon> p_97566_) {
        if (p_97565_.gameMode != null && p_97565_.player != null && p_97566_.isPresent()) {
            Optional<GameModeIcon> optional = GameModeIcon.getFromGameType(p_97565_.gameMode.getPlayerMode());
            GameModeIcon gamemodeswitcherscreen$gamemodeicon = p_97566_.get();
            if (optional.isPresent() && p_97565_.player.hasPermissions(2) && gamemodeswitcherscreen$gamemodeicon != optional.get()) {
                p_97565_.player.chat(gamemodeswitcherscreen$gamemodeicon.getCommand());
            }
        }
    }

    private boolean checkToClose() {
        if (!InputConstants.isKeyDown(this.minecraft.getWindow().getWindow(), 292)) {
            this.switchToHoveredGameMode();
            this.minecraft.setScreen(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 293 && this.currentlyHovered.isPresent()) {
            this.setFirstMousePos = false;
            this.currentlyHovered = this.currentlyHovered.get().getNext();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean isPauseScreen() {
        return false;
    }

    static enum GameModeIcon {
        CREATIVE(new TranslatableComponent("gameMode.creative"), "/gamemode creative", new ItemStack(Blocks.GRASS_BLOCK)),
        SURVIVAL(new TranslatableComponent("gameMode.survival"), "/gamemode survival", new ItemStack(Items.IRON_SWORD)),
        ADVENTURE(new TranslatableComponent("gameMode.adventure"), "/gamemode adventure", new ItemStack(Items.MAP)),
        SPECTATOR(new TranslatableComponent("gameMode.spectator"), "/gamemode spectator", new ItemStack(Items.ENDER_EYE));

        protected static final GameModeIcon[] VALUES;
        private static final int ICON_AREA = 16;
        protected static final int ICON_TOP_LEFT = 5;
        final Component name;
        final String command;
        final ItemStack renderStack;

        static {
            VALUES = GameModeIcon.values();
        }

        private GameModeIcon(Component p_97594_, String p_97595_, ItemStack p_97596_) {
            this.name = p_97594_;
            this.command = p_97595_;
            this.renderStack = p_97596_;
        }

        void drawIcon(ItemRenderer pItemRenderer, int pX, int pY) {
            pItemRenderer.renderAndDecorateItem(this.renderStack, pX, pY);
        }

        Component getName() {
            return this.name;
        }

        String getCommand() {
            return this.command;
        }

        Optional<GameModeIcon> getNext() {
            switch (this) {
                case CREATIVE: {
                    return Optional.of(SURVIVAL);
                }
                case SURVIVAL: {
                    return Optional.of(ADVENTURE);
                }
                case ADVENTURE: {
                    return Optional.of(SPECTATOR);
                }
            }
            return Optional.of(CREATIVE);
        }

        static Optional<GameModeIcon> getFromGameType(GameType pGameType) {
            switch (pGameType) {
                case SPECTATOR: {
                    return Optional.of(SPECTATOR);
                }
                case SURVIVAL: {
                    return Optional.of(SURVIVAL);
                }
                case CREATIVE: {
                    return Optional.of(CREATIVE);
                }
                case ADVENTURE: {
                    return Optional.of(ADVENTURE);
                }
            }
            return Optional.empty();
        }
    }

    public class GameModeSlot
    extends AbstractWidget {
        final GameModeIcon icon;
        private boolean isSelected;

        public GameModeSlot(GameModeIcon p_97627_, int p_97628_, int p_97629_) {
            super(p_97628_, p_97629_, 26, 26, p_97627_.getName());
            this.icon = p_97627_;
        }

        @Override
        public void renderButton(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            Minecraft minecraft = Minecraft.getInstance();
            this.drawSlot(pPoseStack, minecraft.getTextureManager());
            this.icon.drawIcon(GameModeSwitcherScreen.this.itemRenderer, this.x + 5, this.y + 5);
            if (this.isSelected) {
                this.drawSelection(pPoseStack, minecraft.getTextureManager());
            }
        }

        @Override
        public void updateNarration(NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }

        @Override
        public boolean isHoveredOrFocused() {
            return super.isHoveredOrFocused() || this.isSelected;
        }

        public void setSelected(boolean pIsSelected) {
            this.isSelected = pIsSelected;
        }

        private void drawSlot(PoseStack pPoseStack, TextureManager pTextureManager) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, GAMEMODE_SWITCHER_LOCATION);
            pPoseStack.pushPose();
            pPoseStack.translate(this.x, this.y, 0.0);
            GameModeSlot.blit(pPoseStack, 0, 0, 0.0f, 75.0f, 26, 26, 128, 128);
            pPoseStack.popPose();
        }

        private void drawSelection(PoseStack pPoseStack, TextureManager pTextureManager) {
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, GAMEMODE_SWITCHER_LOCATION);
            pPoseStack.pushPose();
            pPoseStack.translate(this.x, this.y, 0.0);
            GameModeSlot.blit(pPoseStack, 0, 0, 26.0f, 75.0f, 26, 26, 128, 128);
            pPoseStack.popPose();
        }
    }
}

