/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.HotbarManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.inventory.CreativeInventoryListener;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.player.inventory.Hotbar;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.searchtree.MutableSearchTree;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class CreativeModeInventoryScreen
extends EffectRenderingInventoryScreen<ItemPickerMenu> {
    private static final ResourceLocation CREATIVE_TABS_LOCATION = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final String GUI_CREATIVE_TAB_PREFIX = "textures/gui/container/creative_inventory/tab_";
    private static final String CUSTOM_SLOT_LOCK = "CustomCreativeLock";
    private static final int NUM_ROWS = 5;
    private static final int NUM_COLS = 9;
    private static final int TAB_WIDTH = 28;
    private static final int TAB_HEIGHT = 32;
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    static final SimpleContainer CONTAINER = new SimpleContainer(45);
    private static final Component TRASH_SLOT_TOOLTIP = new TranslatableComponent("inventory.binSlot");
    private static final int TEXT_COLOR = 0xFFFFFF;
    private static int selectedTab = CreativeModeTab.TAB_BUILDING_BLOCKS.getId();
    private float scrollOffs;
    private boolean scrolling;
    private EditBox searchBox;
    @Nullable
    private List<Slot> originalSlots;
    @Nullable
    private Slot destroyItemSlot;
    private CreativeInventoryListener listener;
    private boolean ignoreTextInput;
    private boolean hasClickedOutside;
    private final Set<TagKey<Item>> visibleTags = new HashSet<TagKey<Item>>();

    public CreativeModeInventoryScreen(Player pPlayer) {
        super(new ItemPickerMenu(pPlayer), pPlayer.getInventory(), TextComponent.EMPTY);
        pPlayer.containerMenu = this.menu;
        this.passEvents = true;
        this.imageHeight = 136;
        this.imageWidth = 195;
    }

    @Override
    public void containerTick() {
        super.containerTick();
        if (!this.minecraft.gameMode.hasInfiniteItems()) {
            this.minecraft.setScreen(new InventoryScreen(this.minecraft.player));
        } else if (this.searchBox != null) {
            this.searchBox.tick();
        }
    }

    @Override
    protected void slotClicked(@Nullable Slot pSlot, int pSlotId, int pMouseButton, ClickType pType) {
        if (this.isCreativeSlot(pSlot)) {
            this.searchBox.moveCursorToEnd();
            this.searchBox.setHighlightPos(0);
        }
        boolean flag = pType == ClickType.QUICK_MOVE;
        ClickType clickType = pType = pSlotId == -999 && pType == ClickType.PICKUP ? ClickType.THROW : pType;
        if (pSlot == null && selectedTab != CreativeModeTab.TAB_INVENTORY.getId() && pType != ClickType.QUICK_CRAFT) {
            if (!((ItemPickerMenu)this.menu).getCarried().isEmpty() && this.hasClickedOutside) {
                if (pMouseButton == 0) {
                    this.minecraft.player.drop(((ItemPickerMenu)this.menu).getCarried(), true);
                    this.minecraft.gameMode.handleCreativeModeItemDrop(((ItemPickerMenu)this.menu).getCarried());
                    ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                }
                if (pMouseButton == 1) {
                    ItemStack itemstack5 = ((ItemPickerMenu)this.menu).getCarried().split(1);
                    this.minecraft.player.drop(itemstack5, true);
                    this.minecraft.gameMode.handleCreativeModeItemDrop(itemstack5);
                }
            }
        } else {
            if (pSlot != null && !pSlot.mayPickup(this.minecraft.player)) {
                return;
            }
            if (pSlot == this.destroyItemSlot && flag) {
                int j = 0;
                while (j < this.minecraft.player.inventoryMenu.getItems().size()) {
                    this.minecraft.gameMode.handleCreativeModeItemAdd(ItemStack.EMPTY, j);
                    ++j;
                }
            } else if (selectedTab == CreativeModeTab.TAB_INVENTORY.getId()) {
                if (pSlot == this.destroyItemSlot) {
                    ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                } else if (pType == ClickType.THROW && pSlot != null && pSlot.hasItem()) {
                    ItemStack itemstack = pSlot.remove(pMouseButton == 0 ? 1 : pSlot.getItem().getMaxStackSize());
                    ItemStack itemstack1 = pSlot.getItem();
                    this.minecraft.player.drop(itemstack, true);
                    this.minecraft.gameMode.handleCreativeModeItemDrop(itemstack);
                    this.minecraft.gameMode.handleCreativeModeItemAdd(itemstack1, ((SlotWrapper)pSlot).target.index);
                } else if (pType == ClickType.THROW && !((ItemPickerMenu)this.menu).getCarried().isEmpty()) {
                    this.minecraft.player.drop(((ItemPickerMenu)this.menu).getCarried(), true);
                    this.minecraft.gameMode.handleCreativeModeItemDrop(((ItemPickerMenu)this.menu).getCarried());
                    ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                } else {
                    this.minecraft.player.inventoryMenu.clicked(pSlot == null ? pSlotId : ((SlotWrapper)pSlot).target.index, pMouseButton, pType, this.minecraft.player);
                    this.minecraft.player.inventoryMenu.broadcastChanges();
                }
            } else if (pType != ClickType.QUICK_CRAFT && pSlot.container == CONTAINER) {
                ItemStack itemstack4 = ((ItemPickerMenu)this.menu).getCarried();
                ItemStack itemstack7 = pSlot.getItem();
                if (pType == ClickType.SWAP) {
                    if (!itemstack7.isEmpty()) {
                        ItemStack itemstack10 = itemstack7.copy();
                        itemstack10.setCount(itemstack10.getMaxStackSize());
                        this.minecraft.player.getInventory().setItem(pMouseButton, itemstack10);
                        this.minecraft.player.inventoryMenu.broadcastChanges();
                    }
                    return;
                }
                if (pType == ClickType.CLONE) {
                    if (((ItemPickerMenu)this.menu).getCarried().isEmpty() && pSlot.hasItem()) {
                        ItemStack itemstack9 = pSlot.getItem().copy();
                        itemstack9.setCount(itemstack9.getMaxStackSize());
                        ((ItemPickerMenu)this.menu).setCarried(itemstack9);
                    }
                    return;
                }
                if (pType == ClickType.THROW) {
                    if (!itemstack7.isEmpty()) {
                        ItemStack itemstack8 = itemstack7.copy();
                        itemstack8.setCount(pMouseButton == 0 ? 1 : itemstack8.getMaxStackSize());
                        this.minecraft.player.drop(itemstack8, true);
                        this.minecraft.gameMode.handleCreativeModeItemDrop(itemstack8);
                    }
                    return;
                }
                if (!itemstack4.isEmpty() && !itemstack7.isEmpty() && itemstack4.sameItem(itemstack7) && ItemStack.tagMatches(itemstack4, itemstack7)) {
                    if (pMouseButton == 0) {
                        if (flag) {
                            itemstack4.setCount(itemstack4.getMaxStackSize());
                        } else if (itemstack4.getCount() < itemstack4.getMaxStackSize()) {
                            itemstack4.grow(1);
                        }
                    } else {
                        itemstack4.shrink(1);
                    }
                } else if (!itemstack7.isEmpty() && itemstack4.isEmpty()) {
                    ((ItemPickerMenu)this.menu).setCarried(itemstack7.copy());
                    itemstack4 = ((ItemPickerMenu)this.menu).getCarried();
                    if (flag) {
                        itemstack4.setCount(itemstack4.getMaxStackSize());
                    }
                } else if (pMouseButton == 0) {
                    ((ItemPickerMenu)this.menu).setCarried(ItemStack.EMPTY);
                } else {
                    ((ItemPickerMenu)this.menu).getCarried().shrink(1);
                }
            } else if (this.menu != null) {
                ItemStack itemstack3 = pSlot == null ? ItemStack.EMPTY : ((ItemPickerMenu)this.menu).getSlot(pSlot.index).getItem();
                ((ItemPickerMenu)this.menu).clicked(pSlot == null ? pSlotId : pSlot.index, pMouseButton, pType, this.minecraft.player);
                if (AbstractContainerMenu.getQuickcraftHeader(pMouseButton) == 2) {
                    int k = 0;
                    while (k < 9) {
                        this.minecraft.gameMode.handleCreativeModeItemAdd(((ItemPickerMenu)this.menu).getSlot(45 + k).getItem(), 36 + k);
                        ++k;
                    }
                } else if (pSlot != null) {
                    ItemStack itemstack6 = ((ItemPickerMenu)this.menu).getSlot(pSlot.index).getItem();
                    this.minecraft.gameMode.handleCreativeModeItemAdd(itemstack6, pSlot.index - ((ItemPickerMenu)this.menu).slots.size() + 9 + 36);
                    int i = 45 + pMouseButton;
                    if (pType == ClickType.SWAP) {
                        this.minecraft.gameMode.handleCreativeModeItemAdd(itemstack3, i - ((ItemPickerMenu)this.menu).slots.size() + 9 + 36);
                    } else if (pType == ClickType.THROW && !itemstack3.isEmpty()) {
                        ItemStack itemstack2 = itemstack3.copy();
                        itemstack2.setCount(pMouseButton == 0 ? 1 : itemstack2.getMaxStackSize());
                        this.minecraft.player.drop(itemstack2, true);
                        this.minecraft.gameMode.handleCreativeModeItemDrop(itemstack2);
                    }
                    this.minecraft.player.inventoryMenu.broadcastChanges();
                }
            }
        }
    }

    private boolean isCreativeSlot(@Nullable Slot pSlot) {
        return pSlot != null && pSlot.container == CONTAINER;
    }

    @Override
    protected void init() {
        if (this.minecraft.gameMode.hasInfiniteItems()) {
            super.init();
            this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
            this.searchBox = new EditBox(this.font, this.leftPos + 82, this.topPos + 6, 80, 9, new TranslatableComponent("itemGroup.search"));
            this.searchBox.setMaxLength(50);
            this.searchBox.setBordered(false);
            this.searchBox.setVisible(false);
            this.searchBox.setTextColor(0xFFFFFF);
            this.addWidget(this.searchBox);
            int i = selectedTab;
            selectedTab = -1;
            this.selectTab(CreativeModeTab.TABS[i]);
            this.minecraft.player.inventoryMenu.removeSlotListener(this.listener);
            this.listener = new CreativeInventoryListener(this.minecraft);
            this.minecraft.player.inventoryMenu.addSlotListener(this.listener);
        } else {
            this.minecraft.setScreen(new InventoryScreen(this.minecraft.player));
        }
    }

    @Override
    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.searchBox.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.searchBox.setValue(s);
        if (!this.searchBox.getValue().isEmpty()) {
            this.refreshSearchResults();
        }
    }

    @Override
    public void removed() {
        super.removed();
        if (this.minecraft.player != null && this.minecraft.player.getInventory() != null) {
            this.minecraft.player.inventoryMenu.removeSlotListener(this.listener);
        }
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    @Override
    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (this.ignoreTextInput) {
            return false;
        }
        if (selectedTab != CreativeModeTab.TAB_SEARCH.getId()) {
            return false;
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.charTyped(pCodePoint, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        if (selectedTab != CreativeModeTab.TAB_SEARCH.getId()) {
            if (this.minecraft.options.keyChat.matches(pKeyCode, pScanCode)) {
                this.ignoreTextInput = true;
                this.selectTab(CreativeModeTab.TAB_SEARCH);
                return true;
            }
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        boolean flag = !this.isCreativeSlot(this.hoveredSlot) || this.hoveredSlot.hasItem();
        boolean flag1 = InputConstants.getKey(pKeyCode, pScanCode).getNumericKeyValue().isPresent();
        if (flag && flag1 && this.checkHotbarKeyPressed(pKeyCode, pScanCode)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.getValue();
        if (this.searchBox.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            if (!Objects.equals(s, this.searchBox.getValue())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.isFocused() && this.searchBox.isVisible() && pKeyCode != 256 ? true : super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        this.ignoreTextInput = false;
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    private void refreshSearchResults() {
        ((ItemPickerMenu)this.menu).items.clear();
        this.visibleTags.clear();
        String s = this.searchBox.getValue();
        if (s.isEmpty()) {
            for (Item item : Registry.ITEM) {
                item.fillItemCategory(CreativeModeTab.TAB_SEARCH, ((ItemPickerMenu)this.menu).items);
            }
        } else {
            MutableSearchTree<ItemStack> searchtree;
            if (s.startsWith("#")) {
                s = s.substring(1);
                searchtree = this.minecraft.getSearchTree(SearchRegistry.CREATIVE_TAGS);
                this.updateVisibleTags(s);
            } else {
                searchtree = this.minecraft.getSearchTree(SearchRegistry.CREATIVE_NAMES);
            }
            ((ItemPickerMenu)this.menu).items.addAll(searchtree.search(s.toLowerCase(Locale.ROOT)));
        }
        this.scrollOffs = 0.0f;
        ((ItemPickerMenu)this.menu).scrollTo(0.0f);
    }

    private void updateVisibleTags(String pSearch) {
        Predicate<ResourceLocation> predicate;
        int i = pSearch.indexOf(58);
        if (i == -1) {
            predicate = p_98609_ -> p_98609_.getPath().contains(pSearch);
        } else {
            String s = pSearch.substring(0, i).trim();
            String s1 = pSearch.substring(i + 1).trim();
            predicate = p_98606_ -> p_98606_.getNamespace().contains(s) && p_98606_.getPath().contains(s1);
        }
        Registry.ITEM.getTagNames().filter(p_205410_ -> predicate.test(p_205410_.location())).forEach(this.visibleTags::add);
    }

    @Override
    protected void renderLabels(PoseStack pPoseStack, int pX, int pY) {
        CreativeModeTab creativemodetab = CreativeModeTab.TABS[selectedTab];
        if (creativemodetab.showTitle()) {
            RenderSystem.disableBlend();
            this.font.draw(pPoseStack, creativemodetab.getDisplayName(), 8.0f, 6.0f, 0x404040);
        }
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_98532_, int pMouseY) {
        if (pMouseY == 0) {
            double d0 = pMouseX - (double)this.leftPos;
            double d1 = p_98532_ - (double)this.topPos;
            CreativeModeTab[] creativeModeTabArray = CreativeModeTab.TABS;
            int n = CreativeModeTab.TABS.length;
            int n2 = 0;
            while (n2 < n) {
                CreativeModeTab creativemodetab = creativeModeTabArray[n2];
                if (this.checkTabClicked(creativemodetab, d0, d1)) {
                    return true;
                }
                ++n2;
            }
            if (selectedTab != CreativeModeTab.TAB_INVENTORY.getId() && this.insideScrollbar(pMouseX, p_98532_)) {
                this.scrolling = this.canScroll();
                return true;
            }
        }
        return super.mouseClicked(pMouseX, p_98532_, pMouseY);
    }

    @Override
    public boolean mouseReleased(double pMouseX, double p_98623_, int pMouseY) {
        if (pMouseY == 0) {
            double d0 = pMouseX - (double)this.leftPos;
            double d1 = p_98623_ - (double)this.topPos;
            this.scrolling = false;
            CreativeModeTab[] creativeModeTabArray = CreativeModeTab.TABS;
            int n = CreativeModeTab.TABS.length;
            int n2 = 0;
            while (n2 < n) {
                CreativeModeTab creativemodetab = creativeModeTabArray[n2];
                if (this.checkTabClicked(creativemodetab, d0, d1)) {
                    this.selectTab(creativemodetab);
                    return true;
                }
                ++n2;
            }
        }
        return super.mouseReleased(pMouseX, p_98623_, pMouseY);
    }

    private boolean canScroll() {
        return selectedTab != CreativeModeTab.TAB_INVENTORY.getId() && CreativeModeTab.TABS[selectedTab].canScroll() && ((ItemPickerMenu)this.menu).canScroll();
    }

    private void selectTab(CreativeModeTab pTab) {
        int i = selectedTab;
        selectedTab = pTab.getId();
        this.quickCraftSlots.clear();
        ((ItemPickerMenu)this.menu).items.clear();
        if (pTab == CreativeModeTab.TAB_HOTBAR) {
            HotbarManager hotbarmanager = this.minecraft.getHotbarManager();
            int j = 0;
            while (j < 9) {
                Hotbar hotbar = hotbarmanager.get(j);
                if (hotbar.isEmpty()) {
                    int k = 0;
                    while (k < 9) {
                        if (k == j) {
                            ItemStack itemstack = new ItemStack(Items.PAPER);
                            itemstack.getOrCreateTagElement(CUSTOM_SLOT_LOCK);
                            Component component = this.minecraft.options.keyHotbarSlots[j].getTranslatedKeyMessage();
                            Component component1 = this.minecraft.options.keySaveHotbarActivator.getTranslatedKeyMessage();
                            itemstack.setHoverName(new TranslatableComponent("inventory.hotbarInfo", component1, component));
                            ((ItemPickerMenu)this.menu).items.add(itemstack);
                        } else {
                            ((ItemPickerMenu)this.menu).items.add(ItemStack.EMPTY);
                        }
                        ++k;
                    }
                } else {
                    ((ItemPickerMenu)this.menu).items.addAll((Collection<ItemStack>)((Object)hotbar));
                }
                ++j;
            }
        } else if (pTab != CreativeModeTab.TAB_SEARCH) {
            pTab.fillItemList(((ItemPickerMenu)this.menu).items);
        }
        if (pTab == CreativeModeTab.TAB_INVENTORY) {
            InventoryMenu abstractcontainermenu = this.minecraft.player.inventoryMenu;
            if (this.originalSlots == null) {
                this.originalSlots = ImmutableList.copyOf((Collection)((ItemPickerMenu)this.menu).slots);
            }
            ((ItemPickerMenu)this.menu).slots.clear();
            int l = 0;
            while (l < abstractcontainermenu.slots.size()) {
                int j1;
                int i1;
                if (l >= 5 && l < 9) {
                    int l1 = l - 5;
                    int j2 = l1 / 2;
                    int l2 = l1 % 2;
                    i1 = 54 + j2 * 54;
                    j1 = 6 + l2 * 27;
                } else if (l >= 0 && l < 5) {
                    i1 = -2000;
                    j1 = -2000;
                } else if (l == 45) {
                    i1 = 35;
                    j1 = 20;
                } else {
                    int k1 = l - 9;
                    int i2 = k1 % 9;
                    int k2 = k1 / 9;
                    i1 = 9 + i2 * 18;
                    j1 = l >= 36 ? 112 : 54 + k2 * 18;
                }
                SlotWrapper slot = new SlotWrapper(abstractcontainermenu.slots.get(l), l, i1, j1);
                ((ItemPickerMenu)this.menu).slots.add(slot);
                ++l;
            }
            this.destroyItemSlot = new Slot(CONTAINER, 0, 173, 112);
            ((ItemPickerMenu)this.menu).slots.add(this.destroyItemSlot);
        } else if (i == CreativeModeTab.TAB_INVENTORY.getId()) {
            ((ItemPickerMenu)this.menu).slots.clear();
            ((ItemPickerMenu)this.menu).slots.addAll(this.originalSlots);
            this.originalSlots = null;
        }
        if (this.searchBox != null) {
            if (pTab == CreativeModeTab.TAB_SEARCH) {
                this.searchBox.setVisible(true);
                this.searchBox.setCanLoseFocus(false);
                this.searchBox.setFocus(true);
                if (i != pTab.getId()) {
                    this.searchBox.setValue("");
                }
                this.refreshSearchResults();
            } else {
                this.searchBox.setVisible(false);
                this.searchBox.setCanLoseFocus(true);
                this.searchBox.setFocus(false);
                this.searchBox.setValue("");
            }
        }
        this.scrollOffs = 0.0f;
        ((ItemPickerMenu)this.menu).scrollTo(0.0f);
    }

    @Override
    public boolean mouseScrolled(double pMouseX, double p_98528_, double pMouseY) {
        if (!this.canScroll()) {
            return false;
        }
        int i = (((ItemPickerMenu)this.menu).items.size() + 9 - 1) / 9 - 5;
        float f = (float)(pMouseY / (double)i);
        this.scrollOffs = Mth.clamp(this.scrollOffs - f, 0.0f, 1.0f);
        ((ItemPickerMenu)this.menu).scrollTo(this.scrollOffs);
        return true;
    }

    @Override
    protected boolean hasClickedOutside(double pMouseX, double p_98542_, int pMouseY, int p_98544_, int pGuiLeft) {
        boolean flag = pMouseX < (double)pMouseY || p_98542_ < (double)p_98544_ || pMouseX >= (double)(pMouseY + this.imageWidth) || p_98542_ >= (double)(p_98544_ + this.imageHeight);
        this.hasClickedOutside = flag && !this.checkTabClicked(CreativeModeTab.TABS[selectedTab], pMouseX, p_98542_);
        return this.hasClickedOutside;
    }

    protected boolean insideScrollbar(double pMouseX, double p_98525_) {
        int i = this.leftPos;
        int j = this.topPos;
        int k = i + 175;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + 112;
        return pMouseX >= (double)k && p_98525_ >= (double)l && pMouseX < (double)i1 && p_98525_ < (double)j1;
    }

    @Override
    public boolean mouseDragged(double pMouseX, double p_98536_, int pMouseY, double p_98538_, double pButton) {
        if (this.scrolling) {
            int i = this.topPos + 18;
            int j = i + 112;
            this.scrollOffs = ((float)p_98536_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp(this.scrollOffs, 0.0f, 1.0f);
            ((ItemPickerMenu)this.menu).scrollTo(this.scrollOffs);
            return true;
        }
        return super.mouseDragged(pMouseX, p_98536_, pMouseY, p_98538_, pButton);
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        CreativeModeTab[] creativeModeTabArray = CreativeModeTab.TABS;
        int n = CreativeModeTab.TABS.length;
        int n2 = 0;
        while (n2 < n) {
            CreativeModeTab creativemodetab = creativeModeTabArray[n2];
            if (this.checkTabHovering(pPoseStack, creativemodetab, pMouseX, pMouseY)) break;
            ++n2;
        }
        if (this.destroyItemSlot != null && selectedTab == CreativeModeTab.TAB_INVENTORY.getId() && this.isHovering(this.destroyItemSlot.x, this.destroyItemSlot.y, 16, 16, pMouseX, pMouseY)) {
            this.renderTooltip(pPoseStack, TRASH_SLOT_TOOLTIP, pMouseX, pMouseY);
        }
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        this.renderTooltip(pPoseStack, pMouseX, pMouseY);
    }

    @Override
    protected void renderTooltip(PoseStack pPoseStack, ItemStack pItemStack, int pMouseX, int pMouseY) {
        if (selectedTab == CreativeModeTab.TAB_SEARCH.getId()) {
            Map<Enchantment, Integer> map;
            List<Component> list = pItemStack.getTooltipLines(this.minecraft.player, this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL);
            ArrayList list1 = Lists.newArrayList(list);
            Item item = pItemStack.getItem();
            CreativeModeTab creativemodetab = item.getItemCategory();
            if (creativemodetab == null && pItemStack.is(Items.ENCHANTED_BOOK) && (map = EnchantmentHelper.getEnchantments(pItemStack)).size() == 1) {
                Enchantment enchantment = map.keySet().iterator().next();
                CreativeModeTab[] creativeModeTabArray = CreativeModeTab.TABS;
                int n = CreativeModeTab.TABS.length;
                int n2 = 0;
                while (n2 < n) {
                    CreativeModeTab creativemodetab1 = creativeModeTabArray[n2];
                    if (creativemodetab1.hasEnchantmentCategory(enchantment.category)) {
                        creativemodetab = creativemodetab1;
                        break;
                    }
                    ++n2;
                }
            }
            this.visibleTags.forEach(p_205407_ -> {
                if (pItemStack.is((TagKey<Item>)p_205407_)) {
                    list1.add(1, new TextComponent("#" + p_205407_.location()).withStyle(ChatFormatting.DARK_PURPLE));
                }
            });
            if (creativemodetab != null) {
                list1.add(1, creativemodetab.getDisplayName().copy().withStyle(ChatFormatting.BLUE));
            }
            this.renderTooltip(pPoseStack, list1, pItemStack.getTooltipImage(), pMouseX, pMouseY);
        } else {
            super.renderTooltip(pPoseStack, pItemStack, pMouseX, pMouseY);
        }
    }

    @Override
    protected void renderBg(PoseStack pPoseStack, float pPartialTick, int pX, int pY) {
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        CreativeModeTab creativemodetab = CreativeModeTab.TABS[selectedTab];
        CreativeModeTab[] creativeModeTabArray = CreativeModeTab.TABS;
        int n = CreativeModeTab.TABS.length;
        int n2 = 0;
        while (n2 < n) {
            CreativeModeTab creativemodetab1 = creativeModeTabArray[n2];
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, CREATIVE_TABS_LOCATION);
            if (creativemodetab1.getId() != selectedTab) {
                this.renderTabButton(pPoseStack, creativemodetab1);
            }
            ++n2;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, new ResourceLocation(GUI_CREATIVE_TAB_PREFIX + creativemodetab.getBackgroundSuffix()));
        this.blit(pPoseStack, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        this.searchBox.render(pPoseStack, pX, pY, pPartialTick);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.leftPos + 175;
        int j = this.topPos + 18;
        int k = j + 112;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, CREATIVE_TABS_LOCATION);
        if (creativemodetab.canScroll()) {
            this.blit(pPoseStack, i, j + (int)((float)(k - j - 17) * this.scrollOffs), 232 + (this.canScroll() ? 0 : 12), 0, 12, 15);
        }
        this.renderTabButton(pPoseStack, creativemodetab);
        if (creativemodetab == CreativeModeTab.TAB_INVENTORY) {
            InventoryScreen.renderEntityInInventory(this.leftPos + 88, this.topPos + 45, 20, this.leftPos + 88 - pX, this.topPos + 45 - 30 - pY, this.minecraft.player);
        }
    }

    protected boolean checkTabClicked(CreativeModeTab pCreativeModeTab, double pRelativeMouseX, double p_98565_) {
        int i = pCreativeModeTab.getColumn();
        int j = 28 * i;
        int k = 0;
        if (pCreativeModeTab.isAlignedRight()) {
            j = this.imageWidth - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = pCreativeModeTab.isTopRow() ? (k -= 32) : (k += this.imageHeight);
        return pRelativeMouseX >= (double)j && pRelativeMouseX <= (double)(j + 28) && p_98565_ >= (double)k && p_98565_ <= (double)(k + 32);
    }

    protected boolean checkTabHovering(PoseStack pPoseStack, CreativeModeTab pCreativeModeTab, int pMouseX, int pMouseY) {
        int i = pCreativeModeTab.getColumn();
        int j = 28 * i;
        int k = 0;
        if (pCreativeModeTab.isAlignedRight()) {
            j = this.imageWidth - 28 * (6 - i) + 2;
        } else if (i > 0) {
            j += i;
        }
        k = pCreativeModeTab.isTopRow() ? (k -= 32) : (k += this.imageHeight);
        if (this.isHovering(j + 3, k + 3, 23, 27, pMouseX, pMouseY)) {
            this.renderTooltip(pPoseStack, pCreativeModeTab.getDisplayName(), pMouseX, pMouseY);
            return true;
        }
        return false;
    }

    protected void renderTabButton(PoseStack pPoseStack, CreativeModeTab pCreativeModeTab) {
        boolean flag = pCreativeModeTab.getId() == selectedTab;
        boolean flag1 = pCreativeModeTab.isTopRow();
        int i = pCreativeModeTab.getColumn();
        int j = i * 28;
        int k = 0;
        int l = this.leftPos + 28 * i;
        int i1 = this.topPos;
        int j1 = 32;
        if (flag) {
            k += 32;
        }
        if (pCreativeModeTab.isAlignedRight()) {
            l = this.leftPos + this.imageWidth - 28 * (6 - i);
        } else if (i > 0) {
            l += i;
        }
        if (flag1) {
            i1 -= 28;
        } else {
            k += 64;
            i1 += this.imageHeight - 4;
        }
        this.blit(pPoseStack, l, i1, j, k, 28, 32);
        this.itemRenderer.blitOffset = 100.0f;
        int n = flag1 ? 1 : -1;
        ItemStack itemstack = pCreativeModeTab.getIconItem();
        this.itemRenderer.renderAndDecorateItem(itemstack, l += 6, i1 += 8 + n);
        this.itemRenderer.renderGuiItemDecorations(this.font, itemstack, l, i1);
        this.itemRenderer.blitOffset = 0.0f;
    }

    public int getSelectedTab() {
        return selectedTab;
    }

    public static void handleHotbarLoadOrSave(Minecraft pClient, int pIndex, boolean pLoad, boolean pSave) {
        LocalPlayer localplayer = pClient.player;
        HotbarManager hotbarmanager = pClient.getHotbarManager();
        Hotbar hotbar = hotbarmanager.get(pIndex);
        if (pLoad) {
            int i = 0;
            while (i < Inventory.getSelectionSize()) {
                ItemStack itemstack = ((ItemStack)hotbar.get(i)).copy();
                localplayer.getInventory().setItem(i, itemstack);
                pClient.gameMode.handleCreativeModeItemAdd(itemstack, 36 + i);
                ++i;
            }
            localplayer.inventoryMenu.broadcastChanges();
        } else if (pSave) {
            int j = 0;
            while (j < Inventory.getSelectionSize()) {
                hotbar.set(j, localplayer.getInventory().getItem(j).copy());
                ++j;
            }
            Component component = pClient.options.keyHotbarSlots[pIndex].getTranslatedKeyMessage();
            Component component1 = pClient.options.keyLoadHotbarActivator.getTranslatedKeyMessage();
            pClient.gui.setOverlayMessage(new TranslatableComponent("inventory.hotbarSaved", component1, component), false);
            hotbarmanager.save();
        }
    }

    static class CustomCreativeSlot
    extends Slot {
        public CustomCreativeSlot(Container p_98633_, int p_98634_, int p_98635_, int p_98636_) {
            super(p_98633_, p_98634_, p_98635_, p_98636_);
        }

        @Override
        public boolean mayPickup(Player pPlayer) {
            if (super.mayPickup(pPlayer) && this.hasItem()) {
                return this.getItem().getTagElement(CreativeModeInventoryScreen.CUSTOM_SLOT_LOCK) == null;
            }
            return !this.hasItem();
        }
    }

    public static class ItemPickerMenu
    extends AbstractContainerMenu {
        public final NonNullList<ItemStack> items = NonNullList.create();
        private final AbstractContainerMenu inventoryMenu;

        public ItemPickerMenu(Player pPlayer) {
            super(null, 0);
            this.inventoryMenu = pPlayer.inventoryMenu;
            Inventory inventory = pPlayer.getInventory();
            int i = 0;
            while (i < 5) {
                int j = 0;
                while (j < 9) {
                    this.addSlot(new CustomCreativeSlot(CONTAINER, i * 9 + j, 9 + j * 18, 18 + i * 18));
                    ++j;
                }
                ++i;
            }
            int k = 0;
            while (k < 9) {
                this.addSlot(new Slot(inventory, k, 9 + k * 18, 112));
                ++k;
            }
            this.scrollTo(0.0f);
        }

        @Override
        public boolean stillValid(Player pPlayer) {
            return true;
        }

        public void scrollTo(float pPos) {
            int i = (this.items.size() + 9 - 1) / 9 - 5;
            int j = (int)((double)(pPos * (float)i) + 0.5);
            if (j < 0) {
                j = 0;
            }
            int k = 0;
            while (k < 5) {
                int l = 0;
                while (l < 9) {
                    int i1 = l + (k + j) * 9;
                    if (i1 >= 0 && i1 < this.items.size()) {
                        CONTAINER.setItem(l + k * 9, this.items.get(i1));
                    } else {
                        CONTAINER.setItem(l + k * 9, ItemStack.EMPTY);
                    }
                    ++l;
                }
                ++k;
            }
        }

        public boolean canScroll() {
            return this.items.size() > 45;
        }

        @Override
        public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
            Slot slot;
            if (pIndex >= this.slots.size() - 9 && pIndex < this.slots.size() && (slot = (Slot)this.slots.get(pIndex)) != null && slot.hasItem()) {
                slot.set(ItemStack.EMPTY);
            }
            return ItemStack.EMPTY;
        }

        @Override
        public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
            return pSlot.container != CONTAINER;
        }

        @Override
        public boolean canDragTo(Slot pSlot) {
            return pSlot.container != CONTAINER;
        }

        @Override
        public ItemStack getCarried() {
            return this.inventoryMenu.getCarried();
        }

        @Override
        public void setCarried(ItemStack pStack) {
            this.inventoryMenu.setCarried(pStack);
        }
    }

    static class SlotWrapper
    extends Slot {
        final Slot target;

        public SlotWrapper(Slot pSlot, int pIndex, int pX, int pY) {
            super(pSlot.container, pIndex, pX, pY);
            this.target = pSlot;
        }

        @Override
        public void onTake(Player pPlayer, ItemStack pStack) {
            this.target.onTake(pPlayer, pStack);
        }

        @Override
        public boolean mayPlace(ItemStack pStack) {
            return this.target.mayPlace(pStack);
        }

        @Override
        public ItemStack getItem() {
            return this.target.getItem();
        }

        @Override
        public boolean hasItem() {
            return this.target.hasItem();
        }

        @Override
        public void set(ItemStack pStack) {
            this.target.set(pStack);
        }

        @Override
        public void setChanged() {
            this.target.setChanged();
        }

        @Override
        public int getMaxStackSize() {
            return this.target.getMaxStackSize();
        }

        @Override
        public int getMaxStackSize(ItemStack pStack) {
            return this.target.getMaxStackSize(pStack);
        }

        @Override
        @Nullable
        public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
            return this.target.getNoItemIcon();
        }

        @Override
        public ItemStack remove(int pAmount) {
            return this.target.remove(pAmount);
        }

        @Override
        public boolean isActive() {
            return this.target.isActive();
        }

        @Override
        public boolean mayPickup(Player pPlayer) {
            return this.target.mayPickup(pPlayer);
        }
    }
}

