/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentScreen
extends AbstractContainerScreen<EnchantmentMenu> {
    private static final ResourceLocation ENCHANTING_TABLE_LOCATION = new ResourceLocation("textures/gui/container/enchanting_table.png");
    private static final ResourceLocation ENCHANTING_BOOK_LOCATION = new ResourceLocation("textures/entity/enchanting_table_book.png");
    private final Random random = new Random();
    private BookModel bookModel;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;

    public EnchantmentScreen(EnchantmentMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle);
    }

    @Override
    protected void init() {
        super.init();
        this.bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.tickBook();
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_98759_, int pMouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        int k = 0;
        while (k < 3) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = p_98759_ - (double)(j + 14 + 19 * k);
            if (d0 >= 0.0 && d1 >= 0.0 && d0 < 108.0 && d1 < 19.0 && ((EnchantmentMenu)this.menu).clickMenuButton(this.minecraft.player, k)) {
                this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, k);
                return true;
            }
            ++k;
        }
        return super.mouseClicked(pMouseX, p_98759_, pMouseY);
    }

    @Override
    protected void renderBg(PoseStack pPoseStack, float pPartialTick, int pX, int pY) {
        Lighting.setupForFlatItems();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.setShaderTexture(0, ENCHANTING_TABLE_LOCATION);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.blit(pPoseStack, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)this.minecraft.getWindow().getGuiScale();
        RenderSystem.viewport((this.width - 320) / 2 * k, (this.height - 240) / 2 * k, 320 * k, 240 * k);
        Matrix4f matrix4f = Matrix4f.createTranslateMatrix(-0.34f, 0.23f, 0.0f);
        matrix4f.multiply(Matrix4f.perspective(90.0, 1.3333334f, 9.0f, 80.0f));
        RenderSystem.backupProjectionMatrix();
        RenderSystem.setProjectionMatrix(matrix4f);
        pPoseStack.pushPose();
        PoseStack.Pose posestack$pose = pPoseStack.last();
        posestack$pose.pose().setIdentity();
        posestack$pose.normal().setIdentity();
        pPoseStack.translate(0.0, 3.3f, 1984.0);
        float f = 5.0f;
        pPoseStack.scale(5.0f, 5.0f, 5.0f);
        pPoseStack.mulPose(Vector3f.ZP.rotationDegrees(180.0f));
        pPoseStack.mulPose(Vector3f.XP.rotationDegrees(20.0f));
        float f1 = Mth.lerp(pPartialTick, this.oOpen, this.open);
        pPoseStack.translate((1.0f - f1) * 0.2f, (1.0f - f1) * 0.1f, (1.0f - f1) * 0.25f);
        float f2 = -(1.0f - f1) * 90.0f - 90.0f;
        pPoseStack.mulPose(Vector3f.YP.rotationDegrees(f2));
        pPoseStack.mulPose(Vector3f.XP.rotationDegrees(180.0f));
        float f3 = Mth.lerp(pPartialTick, this.oFlip, this.flip) + 0.25f;
        float f4 = Mth.lerp(pPartialTick, this.oFlip, this.flip) + 0.75f;
        f3 = (f3 - (float)Mth.fastFloor(f3)) * 1.6f - 0.3f;
        f4 = (f4 - (float)Mth.fastFloor(f4)) * 1.6f - 0.3f;
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        if (f4 < 0.0f) {
            f4 = 0.0f;
        }
        if (f3 > 1.0f) {
            f3 = 1.0f;
        }
        if (f4 > 1.0f) {
            f4 = 1.0f;
        }
        this.bookModel.setupAnim(0.0f, f3, f4, f1);
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.immediate(Tesselator.getInstance().getBuilder());
        VertexConsumer vertexconsumer = multibuffersource$buffersource.getBuffer(this.bookModel.renderType(ENCHANTING_BOOK_LOCATION));
        this.bookModel.renderToBuffer(pPoseStack, vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY, 1.0f, 1.0f, 1.0f, 1.0f);
        multibuffersource$buffersource.endBatch();
        pPoseStack.popPose();
        RenderSystem.viewport(0, 0, this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
        RenderSystem.restoreProjectionMatrix();
        Lighting.setupFor3DItems();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        EnchantmentNames.getInstance().initSeed(((EnchantmentMenu)this.menu).getEnchantmentSeed());
        int l = ((EnchantmentMenu)this.menu).getGoldCount();
        int i1 = 0;
        while (i1 < 3) {
            int j1 = i + 60;
            int k1 = j1 + 20;
            this.setBlitOffset(0);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, ENCHANTING_TABLE_LOCATION);
            int l1 = ((EnchantmentMenu)this.menu).costs[i1];
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (l1 == 0) {
                this.blit(pPoseStack, j1, j + 14 + 19 * i1, 0, 185, 108, 19);
            } else {
                String s = "" + l1;
                int i2 = 86 - this.font.width(s);
                FormattedText formattedtext = EnchantmentNames.getInstance().getRandomName(this.font, i2);
                int j2 = 6839882;
                if (!(l >= i1 + 1 && this.minecraft.player.experienceLevel >= l1 || this.minecraft.player.getAbilities().instabuild)) {
                    this.blit(pPoseStack, j1, j + 14 + 19 * i1, 0, 185, 108, 19);
                    this.blit(pPoseStack, j1 + 1, j + 15 + 19 * i1, 16 * i1, 239, 16, 16);
                    this.font.drawWordWrap(formattedtext, k1, j + 16 + 19 * i1, i2, (j2 & 0xFEFEFE) >> 1);
                    j2 = 4226832;
                } else {
                    int k2 = pX - (i + 60);
                    int l2 = pY - (j + 14 + 19 * i1);
                    if (k2 >= 0 && l2 >= 0 && k2 < 108 && l2 < 19) {
                        this.blit(pPoseStack, j1, j + 14 + 19 * i1, 0, 204, 108, 19);
                        j2 = 0xFFFF80;
                    } else {
                        this.blit(pPoseStack, j1, j + 14 + 19 * i1, 0, 166, 108, 19);
                    }
                    this.blit(pPoseStack, j1 + 1, j + 15 + 19 * i1, 16 * i1, 223, 16, 16);
                    this.font.drawWordWrap(formattedtext, k1, j + 16 + 19 * i1, i2, j2);
                    j2 = 8453920;
                }
                this.font.drawShadow(pPoseStack, s, (float)(k1 + 86 - this.font.width(s)), (float)(j + 16 + 19 * i1 + 7), j2);
            }
            ++i1;
        }
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        pPartialTick = this.minecraft.getFrameTime();
        this.renderBackground(pPoseStack);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pPoseStack, pMouseX, pMouseY);
        boolean flag = this.minecraft.player.getAbilities().instabuild;
        int i = ((EnchantmentMenu)this.menu).getGoldCount();
        int j = 0;
        while (j < 3) {
            int k = ((EnchantmentMenu)this.menu).costs[j];
            Enchantment enchantment = Enchantment.byId(((EnchantmentMenu)this.menu).enchantClue[j]);
            int l = ((EnchantmentMenu)this.menu).levelClue[j];
            int i1 = j + 1;
            if (this.isHovering(60, 14 + 19 * j, 108, 17, pMouseX, pMouseY) && k > 0 && l >= 0 && enchantment != null) {
                ArrayList list = Lists.newArrayList();
                list.add(new TranslatableComponent("container.enchant.clue", enchantment.getFullname(l)).withStyle(ChatFormatting.WHITE));
                if (!flag) {
                    list.add(TextComponent.EMPTY);
                    if (this.minecraft.player.experienceLevel < k) {
                        list.add(new TranslatableComponent("container.enchant.level.requirement", ((EnchantmentMenu)this.menu).costs[j]).withStyle(ChatFormatting.RED));
                    } else {
                        TranslatableComponent mutablecomponent = i1 == 1 ? new TranslatableComponent("container.enchant.lapis.one") : new TranslatableComponent("container.enchant.lapis.many", i1);
                        list.add(mutablecomponent.withStyle(i >= i1 ? ChatFormatting.GRAY : ChatFormatting.RED));
                        TranslatableComponent mutablecomponent1 = i1 == 1 ? new TranslatableComponent("container.enchant.level.one") : new TranslatableComponent("container.enchant.level.many", i1);
                        list.add(mutablecomponent1.withStyle(ChatFormatting.GRAY));
                    }
                }
                this.renderComponentTooltip(pPoseStack, list, pMouseX, pMouseY);
                break;
            }
            ++j;
        }
    }

    public void tickBook() {
        ItemStack itemstack = ((EnchantmentMenu)this.menu).getSlot(0).getItem();
        if (!ItemStack.matches(itemstack, this.last)) {
            this.last = itemstack;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.time;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean flag = false;
        int i = 0;
        while (i < 3) {
            if (((EnchantmentMenu)this.menu).costs[i] != 0) {
                flag = true;
            }
            ++i;
        }
        this.open = flag ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.clamp(this.open, 0.0f, 1.0f);
        float f1 = (this.flipT - this.flip) * 0.4f;
        float f = 0.2f;
        f1 = Mth.clamp(f1, -0.2f, 0.2f);
        this.flipA += (f1 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

