/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.stream.IntStream;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;

public class SignEditScreen
extends Screen {
    private final SignBlockEntity sign;
    private int frame;
    private int line;
    private TextFieldHelper signField;
    private WoodType woodType;
    private SignRenderer.SignModel signModel;
    private final String[] messages = (String[])IntStream.range(0, 4).mapToObj(p_169818_ -> pSign.getMessage(p_169818_, pIsTextFilteringEnabled)).map(Component::getString).toArray(String[]::new);

    public SignEditScreen(SignBlockEntity pSign, boolean pIsTextFilteringEnabled) {
        super(new TranslatableComponent("sign.edit"));
        this.sign = pSign;
    }

    @Override
    protected void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 120, 200, 20, CommonComponents.GUI_DONE, p_169820_ -> this.onDone()));
        this.sign.setEditable(false);
        this.signField = new TextFieldHelper(() -> this.messages[this.line], p_169824_ -> {
            this.messages[this.line] = p_169824_;
            this.sign.setMessage(this.line, new TextComponent((String)p_169824_));
        }, TextFieldHelper.createClipboardGetter(this.minecraft), TextFieldHelper.createClipboardSetter(this.minecraft), p_169822_ -> this.minecraft.font.width((String)p_169822_) <= 90);
        BlockState blockstate = this.sign.getBlockState();
        this.woodType = SignRenderer.getWoodType(blockstate.getBlock());
        this.signModel = SignRenderer.createSignModel(this.minecraft.getEntityModels(), this.woodType);
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
        ClientPacketListener clientpacketlistener = this.minecraft.getConnection();
        if (clientpacketlistener != null) {
            clientpacketlistener.send(new ServerboundSignUpdatePacket(this.sign.getBlockPos(), this.messages[0], this.messages[1], this.messages[2], this.messages[3]));
        }
        this.sign.setEditable(true);
    }

    @Override
    public void tick() {
        ++this.frame;
        if (!this.sign.getType().isValid(this.sign.getBlockState())) {
            this.onDone();
        }
    }

    private void onDone() {
        this.sign.setChanged();
        this.minecraft.setScreen(null);
    }

    @Override
    public boolean charTyped(char pCodePoint, int pModifiers) {
        this.signField.charTyped(pCodePoint);
        return true;
    }

    @Override
    public void onClose() {
        this.onDone();
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 265) {
            this.line = this.line - 1 & 3;
            this.signField.setCursorToEnd();
            return true;
        }
        if (pKeyCode != 264 && pKeyCode != 257 && pKeyCode != 335) {
            return this.signField.keyPressed(pKeyCode) ? true : super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }
        this.line = this.line + 1 & 3;
        this.signField.setCursorToEnd();
        return true;
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        Lighting.setupForFlatItems();
        this.renderBackground(pPoseStack);
        SignEditScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 40, 0xFFFFFF);
        pPoseStack.pushPose();
        pPoseStack.translate(this.width / 2, 0.0, 50.0);
        float f = 93.75f;
        pPoseStack.scale(93.75f, -93.75f, 93.75f);
        pPoseStack.translate(0.0, -1.3125, 0.0);
        BlockState blockstate = this.sign.getBlockState();
        boolean flag = blockstate.getBlock() instanceof StandingSignBlock;
        if (!flag) {
            pPoseStack.translate(0.0, -0.3125, 0.0);
        }
        boolean flag1 = this.frame / 6 % 2 == 0;
        float f1 = 0.6666667f;
        pPoseStack.pushPose();
        pPoseStack.scale(0.6666667f, -0.6666667f, -0.6666667f);
        MultiBufferSource.BufferSource multibuffersource$buffersource = this.minecraft.renderBuffers().bufferSource();
        Material material = Sheets.getSignMaterial(this.woodType);
        VertexConsumer vertexconsumer = material.buffer(multibuffersource$buffersource, this.signModel::renderType);
        this.signModel.stick.visible = flag;
        this.signModel.root.render(pPoseStack, vertexconsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        pPoseStack.popPose();
        float f2 = 0.010416667f;
        pPoseStack.translate(0.0, 0.3333333432674408, 0.046666666865348816);
        pPoseStack.scale(0.010416667f, -0.010416667f, 0.010416667f);
        int i = this.sign.getColor().getTextColor();
        int j = this.signField.getCursorPos();
        int k = this.signField.getSelectionPos();
        int l = this.line * 10 - this.messages.length * 5;
        Matrix4f matrix4f = pPoseStack.last().pose();
        int i1 = 0;
        while (i1 < this.messages.length) {
            String s = this.messages[i1];
            if (s != null) {
                if (this.font.isBidirectional()) {
                    s = this.font.bidirectionalShaping(s);
                }
                float f3 = -this.minecraft.font.width(s) / 2;
                this.minecraft.font.drawInBatch(s, f3, i1 * 10 - this.messages.length * 5, i, false, matrix4f, multibuffersource$buffersource, false, 0, 0xF000F0, false);
                if (i1 == this.line && j >= 0 && flag1) {
                    int j1 = this.minecraft.font.width(s.substring(0, Math.max(Math.min(j, s.length()), 0)));
                    int k1 = j1 - this.minecraft.font.width(s) / 2;
                    if (j >= s.length()) {
                        this.minecraft.font.drawInBatch("_", k1, l, i, false, matrix4f, multibuffersource$buffersource, false, 0, 0xF000F0, false);
                    }
                }
            }
            ++i1;
        }
        multibuffersource$buffersource.endBatch();
        int i3 = 0;
        while (i3 < this.messages.length) {
            String s1 = this.messages[i3];
            if (s1 != null && i3 == this.line && j >= 0) {
                int j3 = this.minecraft.font.width(s1.substring(0, Math.max(Math.min(j, s1.length()), 0)));
                int k3 = j3 - this.minecraft.font.width(s1) / 2;
                if (flag1 && j < s1.length()) {
                    SignEditScreen.fill(pPoseStack, k3, l - 1, k3 + 1, l + 9, 0xFF000000 | i);
                }
                if (k != j) {
                    int l3 = Math.min(j, k);
                    int l1 = Math.max(j, k);
                    int i2 = this.minecraft.font.width(s1.substring(0, l3)) - this.minecraft.font.width(s1) / 2;
                    int j2 = this.minecraft.font.width(s1.substring(0, l1)) - this.minecraft.font.width(s1) / 2;
                    int k2 = Math.min(i2, j2);
                    int l2 = Math.max(i2, j2);
                    Tesselator tesselator = Tesselator.getInstance();
                    BufferBuilder bufferbuilder = tesselator.getBuilder();
                    RenderSystem.setShader(GameRenderer::getPositionColorShader);
                    RenderSystem.disableTexture();
                    RenderSystem.enableColorLogicOp();
                    RenderSystem.logicOp(GlStateManager.LogicOp.OR_REVERSE);
                    bufferbuilder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
                    bufferbuilder.vertex(matrix4f, k2, l + 9, 0.0f).color(0, 0, 255, 255).endVertex();
                    bufferbuilder.vertex(matrix4f, l2, l + 9, 0.0f).color(0, 0, 255, 255).endVertex();
                    bufferbuilder.vertex(matrix4f, l2, l, 0.0f).color(0, 0, 255, 255).endVertex();
                    bufferbuilder.vertex(matrix4f, k2, l, 0.0f).color(0, 0, 255, 255).endVertex();
                    bufferbuilder.end();
                    BufferUploader.end(bufferbuilder);
                    RenderSystem.disableColorLogicOp();
                    RenderSystem.enableTexture();
                }
            }
            ++i3;
        }
        pPoseStack.popPose();
        Lighting.setupFor3DItems();
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

