/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory.tooltip;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientBundleTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.tooltip.BundleTooltip;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public interface ClientTooltipComponent {
    public static ClientTooltipComponent create(FormattedCharSequence pText) {
        return new ClientTextTooltip(pText);
    }

    public static ClientTooltipComponent create(TooltipComponent pText) {
        if (pText instanceof BundleTooltip) {
            return new ClientBundleTooltip((BundleTooltip)pText);
        }
        throw new IllegalArgumentException("Unknown TooltipComponent");
    }

    public int getHeight();

    public int getWidth(Font var1);

    default public void renderText(Font pFont, int pX, int pY, Matrix4f pMatrix4f, MultiBufferSource.BufferSource pBufferSource) {
    }

    default public void renderImage(Font p_194048_, int p_194049_, int p_194050_, PoseStack p_194051_, ItemRenderer p_194052_, int p_194053_) {
    }
}

