/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.server.LanServer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class ServerSelectionList
extends ObjectSelectionList<Entry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER)).build());
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/server_selection.png");
    static final Component SCANNING_LABEL = new TranslatableComponent("lanServer.scanning");
    static final Component CANT_RESOLVE_TEXT = new TranslatableComponent("multiplayer.status.cannot_resolve").withStyle(ChatFormatting.DARK_RED);
    static final Component CANT_CONNECT_TEXT = new TranslatableComponent("multiplayer.status.cannot_connect").withStyle(ChatFormatting.DARK_RED);
    static final Component INCOMPATIBLE_TOOLTIP = new TranslatableComponent("multiplayer.status.incompatible");
    static final Component NO_CONNECTION_TOOLTIP = new TranslatableComponent("multiplayer.status.no_connection");
    static final Component PINGING_TOOLTIP = new TranslatableComponent("multiplayer.status.pinging");
    private final JoinMultiplayerScreen screen;
    private final List<OnlineServerEntry> onlineServers = Lists.newArrayList();
    private final Entry lanHeader = new LANHeader();
    private final List<NetworkServerEntry> networkServers = Lists.newArrayList();

    public ServerSelectionList(JoinMultiplayerScreen pScreen, Minecraft pMinecraft, int pWidth, int pHeight, int pY0, int pY1, int pItemHeight) {
        super(pMinecraft, pWidth, pHeight, pY0, pY1, pItemHeight);
        this.screen = pScreen;
    }

    private void refreshEntries() {
        this.clearEntries();
        this.onlineServers.forEach(p_169979_ -> this.addEntry(p_169979_));
        this.addEntry(this.lanHeader);
        this.networkServers.forEach(p_169976_ -> this.addEntry(p_169976_));
    }

    @Override
    public void setSelected(@Nullable Entry pEntry) {
        super.setSelected(pEntry);
        this.screen.onSelectedChange();
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        Entry serverselectionlist$entry = (Entry)this.getSelected();
        return serverselectionlist$entry != null && serverselectionlist$entry.keyPressed(pKeyCode, pScanCode, pModifiers) || super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    protected void moveSelection(AbstractSelectionList.SelectionDirection pOrdering) {
        this.moveSelection(pOrdering, p_169973_ -> !(p_169973_ instanceof LANHeader));
    }

    public void updateOnlineServers(ServerList p_99798_) {
        this.onlineServers.clear();
        int i = 0;
        while (i < p_99798_.size()) {
            this.onlineServers.add(new OnlineServerEntry(this.screen, p_99798_.get(i)));
            ++i;
        }
        this.refreshEntries();
    }

    public void updateNetworkServers(List<LanServer> p_99800_) {
        this.networkServers.clear();
        for (LanServer lanserver : p_99800_) {
            this.networkServers.add(new NetworkServerEntry(this.screen, lanserver));
        }
        this.refreshEntries();
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 30;
    }

    @Override
    public int getRowWidth() {
        return super.getRowWidth() + 85;
    }

    @Override
    protected boolean isFocused() {
        return this.screen.getFocused() == this;
    }

    public static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
    }

    public static class LANHeader
    extends Entry {
        private final Minecraft minecraft = Minecraft.getInstance();

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            int i = pTop + pHeight / 2 - 4;
            this.minecraft.font.draw(pPoseStack, SCANNING_LABEL, (float)(this.minecraft.screen.width / 2 - this.minecraft.font.width(SCANNING_LABEL) / 2), (float)i, 0xFFFFFF);
            String s = switch ((int)(Util.getMillis() / 300L % 4L)) {
                default -> "O o o";
                case 1, 3 -> "o O o";
                case 2 -> "o o O";
            };
            this.minecraft.font.draw(pPoseStack, s, (float)(this.minecraft.screen.width / 2 - this.minecraft.font.width(s) / 2), (float)(i + 9), 0x808080);
        }

        @Override
        public Component getNarration() {
            return TextComponent.EMPTY;
        }
    }

    public static class NetworkServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final Component LAN_SERVER_HEADER = new TranslatableComponent("lanServer.title");
        private static final Component HIDDEN_ADDRESS_TEXT = new TranslatableComponent("selectServer.hiddenAddress");
        private final JoinMultiplayerScreen screen;
        protected final Minecraft minecraft;
        protected final LanServer serverData;
        private long lastClickTime;

        protected NetworkServerEntry(JoinMultiplayerScreen pScreen, LanServer pServerData) {
            this.screen = pScreen;
            this.serverData = pServerData;
            this.minecraft = Minecraft.getInstance();
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.minecraft.font.draw(pPoseStack, LAN_SERVER_HEADER, (float)(pLeft + 32 + 3), (float)(pTop + 1), 0xFFFFFF);
            this.minecraft.font.draw(pPoseStack, this.serverData.getMotd(), (float)(pLeft + 32 + 3), (float)(pTop + 12), 0x808080);
            if (this.minecraft.options.hideServerAddress) {
                this.minecraft.font.draw(pPoseStack, HIDDEN_ADDRESS_TEXT, (float)(pLeft + 32 + 3), (float)(pTop + 12 + 11), 0x303030);
            } else {
                this.minecraft.font.draw(pPoseStack, this.serverData.getAddress(), (float)(pLeft + 32 + 3), (float)(pTop + 12 + 11), 0x303030);
            }
        }

        @Override
        public boolean mouseClicked(double pMouseX, double p_99841_, int pMouseY) {
            this.screen.setSelected(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }

        public LanServer getServerData() {
            return this.serverData;
        }

        @Override
        public Component getNarration() {
            return new TranslatableComponent("narrator.select", new TextComponent("").append(LAN_SERVER_HEADER).append(" ").append(this.serverData.getMotd()));
        }
    }

    public class OnlineServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_OVERLAY_X_MOVE_RIGHT = 0;
        private static final int ICON_OVERLAY_X_MOVE_LEFT = 32;
        private static final int ICON_OVERLAY_X_MOVE_DOWN = 64;
        private static final int ICON_OVERLAY_X_MOVE_UP = 96;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final JoinMultiplayerScreen screen;
        private final Minecraft minecraft;
        private final ServerData serverData;
        private final ResourceLocation iconLocation;
        @Nullable
        private String lastIconB64;
        @Nullable
        private DynamicTexture icon;
        private long lastClickTime;

        protected OnlineServerEntry(JoinMultiplayerScreen p_99864_, ServerData p_99865_) {
            this.screen = p_99864_;
            this.serverData = p_99865_;
            this.minecraft = Minecraft.getInstance();
            this.iconLocation = new ResourceLocation("servers/" + Hashing.sha1().hashUnencodedChars((CharSequence)p_99865_.ip) + "/icon");
            AbstractTexture abstracttexture = this.minecraft.getTextureManager().getTexture(this.iconLocation, MissingTextureAtlasSprite.getTexture());
            if (abstracttexture != MissingTextureAtlasSprite.getTexture() && abstracttexture instanceof DynamicTexture) {
                this.icon = (DynamicTexture)abstracttexture;
            }
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            List<Component> list1;
            Component component;
            int l;
            if (!this.serverData.pinged) {
                this.serverData.pinged = true;
                this.serverData.ping = -2L;
                this.serverData.motd = TextComponent.EMPTY;
                this.serverData.status = TextComponent.EMPTY;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().pingServer(this.serverData, () -> this.minecraft.execute(this::updateServerList));
                    }
                    catch (UnknownHostException unknownhostexception) {
                        this.serverData.ping = -1L;
                        this.serverData.motd = CANT_RESOLVE_TEXT;
                    }
                    catch (Exception exception) {
                        this.serverData.ping = -1L;
                        this.serverData.motd = CANT_CONNECT_TEXT;
                    }
                });
            }
            boolean flag = this.serverData.protocol != SharedConstants.getCurrentVersion().getProtocolVersion();
            this.minecraft.font.draw(pPoseStack, this.serverData.name, (float)(pLeft + 32 + 3), (float)(pTop + 1), 0xFFFFFF);
            List<FormattedCharSequence> list = this.minecraft.font.split(this.serverData.motd, pWidth - 32 - 2);
            int i = 0;
            while (i < Math.min(list.size(), 2)) {
                this.minecraft.font.draw(pPoseStack, list.get(i), (float)(pLeft + 32 + 3), (float)(pTop + 12 + 9 * i), 0x808080);
                ++i;
            }
            Component component1 = flag ? this.serverData.version.copy().withStyle(ChatFormatting.RED) : this.serverData.status;
            int j = this.minecraft.font.width(component1);
            this.minecraft.font.draw(pPoseStack, component1, (float)(pLeft + pWidth - j - 15 - 2), (float)(pTop + 1), 0x808080);
            int k = 0;
            if (flag) {
                l = 5;
                component = INCOMPATIBLE_TOOLTIP;
                list1 = this.serverData.playerList;
            } else if (this.serverData.pinged && this.serverData.ping != -2L) {
                l = this.serverData.ping < 0L ? 5 : (this.serverData.ping < 150L ? 0 : (this.serverData.ping < 300L ? 1 : (this.serverData.ping < 600L ? 2 : (this.serverData.ping < 1000L ? 3 : 4))));
                if (this.serverData.ping < 0L) {
                    component = NO_CONNECTION_TOOLTIP;
                    list1 = Collections.emptyList();
                } else {
                    component = new TranslatableComponent("multiplayer.status.ping", this.serverData.ping);
                    list1 = this.serverData.playerList;
                }
            } else {
                k = 1;
                l = (int)(Util.getMillis() / 100L + (long)(pIndex * 2) & 7L);
                if (l > 4) {
                    l = 8 - l;
                }
                component = PINGING_TOOLTIP;
                list1 = Collections.emptyList();
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShaderTexture(0, GuiComponent.GUI_ICONS_LOCATION);
            GuiComponent.blit(pPoseStack, pLeft + pWidth - 15, pTop, k * 10, 176 + l * 8, 10, 8, 256, 256);
            String s = this.serverData.getIconB64();
            if (!Objects.equals(s, this.lastIconB64)) {
                if (this.uploadServerIcon(s)) {
                    this.lastIconB64 = s;
                } else {
                    this.serverData.setIconB64(null);
                    this.updateServerList();
                }
            }
            if (this.icon == null) {
                this.drawIcon(pPoseStack, pLeft, pTop, ICON_MISSING);
            } else {
                this.drawIcon(pPoseStack, pLeft, pTop, this.iconLocation);
            }
            int i1 = pMouseX - pLeft;
            int j1 = pMouseY - pTop;
            if (i1 >= pWidth - 15 && i1 <= pWidth - 5 && j1 >= 0 && j1 <= 8) {
                this.screen.setToolTip(Collections.singletonList(component));
            } else if (i1 >= pWidth - j - 15 - 2 && i1 <= pWidth - 15 - 2 && j1 >= 0 && j1 <= 8) {
                this.screen.setToolTip(list1);
            }
            if (this.minecraft.options.touchscreen || pIsMouseOver) {
                RenderSystem.setShaderTexture(0, ICON_OVERLAY_LOCATION);
                GuiComponent.fill(pPoseStack, pLeft, pTop, pLeft + 32, pTop + 32, -1601138544);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                int k1 = pMouseX - pLeft;
                int l1 = pMouseY - pTop;
                if (this.canJoin()) {
                    if (k1 < 32 && k1 > 16) {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
                if (pIndex > 0) {
                    if (k1 < 16 && l1 < 16) {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
                if (pIndex < this.screen.getServers().size() - 1) {
                    if (k1 < 16 && l1 > 16) {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 64.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 64.0f, 0.0f, 32, 32, 256, 256);
                    }
                }
            }
        }

        public void updateServerList() {
            this.screen.getServers().save();
        }

        protected void drawIcon(PoseStack pPoseStack, int pX, int pY, ResourceLocation pTextureLocation) {
            RenderSystem.setShaderTexture(0, pTextureLocation);
            RenderSystem.enableBlend();
            GuiComponent.blit(pPoseStack, pX, pY, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
        }

        private boolean canJoin() {
            return true;
        }

        private boolean uploadServerIcon(@Nullable String p_99897_) {
            if (p_99897_ == null) {
                this.minecraft.getTextureManager().release(this.iconLocation);
                if (this.icon != null && this.icon.getPixels() != null) {
                    this.icon.getPixels().close();
                }
                this.icon = null;
            } else {
                try {
                    NativeImage nativeimage = NativeImage.fromBase64(p_99897_);
                    Validate.validState((nativeimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                    Validate.validState((nativeimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                    if (this.icon == null) {
                        this.icon = new DynamicTexture(nativeimage);
                    } else {
                        this.icon.setPixels(nativeimage);
                        this.icon.upload();
                    }
                    this.minecraft.getTextureManager().register(this.iconLocation, (AbstractTexture)this.icon);
                }
                catch (Throwable throwable) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, throwable});
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (Screen.hasShiftDown()) {
                ServerSelectionList serverselectionlist = this.screen.serverSelectionList;
                int i = serverselectionlist.children().indexOf(this);
                if (i == -1) {
                    return true;
                }
                if (pKeyCode == 264 && i < this.screen.getServers().size() - 1 || pKeyCode == 265 && i > 0) {
                    this.swap(i, pKeyCode == 264 ? i + 1 : i - 1);
                    return true;
                }
            }
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }

        private void swap(int p_99872_, int p_99873_) {
            this.screen.getServers().swap(p_99872_, p_99873_);
            this.screen.serverSelectionList.updateOnlineServers(this.screen.getServers());
            Entry serverselectionlist$entry = (Entry)this.screen.serverSelectionList.children().get(p_99873_);
            this.screen.serverSelectionList.setSelected(serverselectionlist$entry);
            ServerSelectionList.this.ensureVisible(serverselectionlist$entry);
        }

        @Override
        public boolean mouseClicked(double pMouseX, double p_99869_, int pMouseY) {
            double d0 = pMouseX - (double)ServerSelectionList.this.getRowLeft();
            double d1 = p_99869_ - (double)ServerSelectionList.this.getRowTop(ServerSelectionList.this.children().indexOf(this));
            if (d0 <= 32.0) {
                if (d0 < 32.0 && d0 > 16.0 && this.canJoin()) {
                    this.screen.setSelected(this);
                    this.screen.joinSelectedServer();
                    return true;
                }
                int i = this.screen.serverSelectionList.children().indexOf(this);
                if (d0 < 16.0 && d1 < 16.0 && i > 0) {
                    this.swap(i, i - 1);
                    return true;
                }
                if (d0 < 16.0 && d1 > 16.0 && i < this.screen.getServers().size() - 1) {
                    this.swap(i, i + 1);
                    return true;
                }
            }
            this.screen.setSelected(this);
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }

        public ServerData getServerData() {
            return this.serverData;
        }

        @Override
        public Component getNarration() {
            return new TranslatableComponent("narrator.select", this.serverData.name);
        }
    }
}

