/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.packs;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionModel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.util.FormattedCharSequence;

public class TransferableSelectionList
extends ObjectSelectionList<PackEntry> {
    static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/resource_packs.png");
    static final Component INCOMPATIBLE_TITLE = new TranslatableComponent("pack.incompatible");
    static final Component INCOMPATIBLE_CONFIRM_TITLE = new TranslatableComponent("pack.incompatible.confirm.title");
    private final Component title;

    public TransferableSelectionList(Minecraft pMinecraft, int pWidth, int pHeight, Component pTitle) {
        super(pMinecraft, pWidth, pHeight, 32, pHeight - 55 + 4, 36);
        this.title = pTitle;
        this.centerListVertically = false;
        this.setRenderHeader(true, 13);
    }

    @Override
    protected void renderHeader(PoseStack pPoseStack, int pX, int pY, Tesselator pTessellator) {
        MutableComponent component = new TextComponent("").append(this.title).a(ChatFormatting.UNDERLINE, ChatFormatting.BOLD);
        this.minecraft.font.draw(pPoseStack, component, (float)(pX + this.width / 2 - this.minecraft.font.width(component) / 2), (float)Math.min(this.y0 + 3, pY), 0xFFFFFF);
    }

    @Override
    public int getRowWidth() {
        return this.width;
    }

    @Override
    protected int getScrollbarPosition() {
        return this.x1 - 6;
    }

    public static class PackEntry
    extends ObjectSelectionList.Entry<PackEntry> {
        private static final int ICON_OVERLAY_X_MOVE_RIGHT = 0;
        private static final int ICON_OVERLAY_X_MOVE_LEFT = 32;
        private static final int ICON_OVERLAY_X_MOVE_DOWN = 64;
        private static final int ICON_OVERLAY_X_MOVE_UP = 96;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private static final int MAX_DESCRIPTION_WIDTH_PIXELS = 157;
        private static final int MAX_NAME_WIDTH_PIXELS = 157;
        private static final String TOO_LONG_NAME_SUFFIX = "...";
        private final TransferableSelectionList parent;
        protected final Minecraft minecraft;
        protected final Screen screen;
        private final PackSelectionModel.Entry pack;
        private final FormattedCharSequence nameDisplayCache;
        private final MultiLineLabel descriptionDisplayCache;
        private final FormattedCharSequence incompatibleNameDisplayCache;
        private final MultiLineLabel incompatibleDescriptionDisplayCache;

        public PackEntry(Minecraft pMinecraft, TransferableSelectionList pParent, Screen pScreen, PackSelectionModel.Entry pPack) {
            this.minecraft = pMinecraft;
            this.screen = pScreen;
            this.pack = pPack;
            this.parent = pParent;
            this.nameDisplayCache = PackEntry.cacheName(pMinecraft, pPack.getTitle());
            this.descriptionDisplayCache = PackEntry.cacheDescription(pMinecraft, pPack.getExtendedDescription());
            this.incompatibleNameDisplayCache = PackEntry.cacheName(pMinecraft, INCOMPATIBLE_TITLE);
            this.incompatibleDescriptionDisplayCache = PackEntry.cacheDescription(pMinecraft, pPack.getCompatibility().getDescription());
        }

        private static FormattedCharSequence cacheName(Minecraft pMinecraft, Component pName) {
            int i = pMinecraft.font.width(pName);
            if (i > 157) {
                FormattedText formattedtext = FormattedText.a(pMinecraft.font.substrByWidth(pName, 157 - pMinecraft.font.width(TOO_LONG_NAME_SUFFIX)), FormattedText.of(TOO_LONG_NAME_SUFFIX));
                return Language.getInstance().getVisualOrder(formattedtext);
            }
            return pName.getVisualOrderText();
        }

        private static MultiLineLabel cacheDescription(Minecraft p_100110_, Component p_100111_) {
            return MultiLineLabel.create(p_100110_.font, p_100111_, 157, 2);
        }

        @Override
        public Component getNarration() {
            return new TranslatableComponent("narrator.select", this.pack.getTitle());
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            PackCompatibility packcompatibility = this.pack.getCompatibility();
            if (!packcompatibility.isCompatible()) {
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                GuiComponent.fill(pPoseStack, pLeft - 1, pTop - 1, pLeft + pWidth - 9, pTop + pHeight + 1, -8978432);
            }
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderTexture(0, this.pack.getIconTexture());
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, 0.0f, 32, 32, 32, 32);
            FormattedCharSequence formattedcharsequence = this.nameDisplayCache;
            MultiLineLabel multilinelabel = this.descriptionDisplayCache;
            if (this.showHoverOverlay() && (this.minecraft.options.touchscreen || pIsMouseOver)) {
                RenderSystem.setShaderTexture(0, ICON_OVERLAY_LOCATION);
                GuiComponent.fill(pPoseStack, pLeft, pTop, pLeft + 32, pTop + 32, -1601138544);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                int i = pMouseX - pLeft;
                int j = pMouseY - pTop;
                if (!this.pack.getCompatibility().isCompatible()) {
                    formattedcharsequence = this.incompatibleNameDisplayCache;
                    multilinelabel = this.incompatibleDescriptionDisplayCache;
                }
                if (this.pack.canSelect()) {
                    if (i < 32) {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, 32.0f, 32, 32, 256, 256);
                    } else {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, 0.0f, 32, 32, 256, 256);
                    }
                } else {
                    if (this.pack.canUnselect()) {
                        if (i < 16) {
                            GuiComponent.blit(pPoseStack, pLeft, pTop, 32.0f, 32.0f, 32, 32, 256, 256);
                        } else {
                            GuiComponent.blit(pPoseStack, pLeft, pTop, 32.0f, 0.0f, 32, 32, 256, 256);
                        }
                    }
                    if (this.pack.canMoveUp()) {
                        if (i < 32 && i > 16 && j < 16) {
                            GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, 32.0f, 32, 32, 256, 256);
                        } else {
                            GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, 0.0f, 32, 32, 256, 256);
                        }
                    }
                    if (this.pack.canMoveDown()) {
                        if (i < 32 && i > 16 && j > 16) {
                            GuiComponent.blit(pPoseStack, pLeft, pTop, 64.0f, 32.0f, 32, 32, 256, 256);
                        } else {
                            GuiComponent.blit(pPoseStack, pLeft, pTop, 64.0f, 0.0f, 32, 32, 256, 256);
                        }
                    }
                }
            }
            this.minecraft.font.drawShadow(pPoseStack, formattedcharsequence, (float)(pLeft + 32 + 2), (float)(pTop + 1), 0xFFFFFF);
            multilinelabel.renderLeftAligned(pPoseStack, pLeft + 32 + 2, pTop + 12, 10, 0x808080);
        }

        private boolean showHoverOverlay() {
            return !this.pack.isFixedPosition() || !this.pack.isRequired();
        }

        @Override
        public boolean mouseClicked(double pMouseX, double p_100091_, int pMouseY) {
            double d0 = pMouseX - (double)this.parent.getRowLeft();
            double d1 = p_100091_ - (double)this.parent.getRowTop(this.parent.children().indexOf(this));
            if (this.showHoverOverlay() && d0 <= 32.0) {
                if (this.pack.canSelect()) {
                    PackCompatibility packcompatibility = this.pack.getCompatibility();
                    if (packcompatibility.isCompatible()) {
                        this.pack.select();
                    } else {
                        Component component = packcompatibility.getConfirmation();
                        this.minecraft.setScreen(new ConfirmScreen(p_100108_ -> {
                            this.minecraft.setScreen(this.screen);
                            if (p_100108_) {
                                this.pack.select();
                            }
                        }, INCOMPATIBLE_CONFIRM_TITLE, component));
                    }
                    return true;
                }
                if (d0 < 16.0 && this.pack.canUnselect()) {
                    this.pack.unselect();
                    return true;
                }
                if (d0 > 16.0 && d1 < 16.0 && this.pack.canMoveUp()) {
                    this.pack.moveUp();
                    return true;
                }
                if (d0 > 16.0 && d1 > 16.0 && this.pack.canMoveDown()) {
                    this.pack.moveDown();
                    return true;
                }
            }
            return false;
        }
    }
}

