/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class GhostRecipe {
    @Nullable
    private Recipe<?> recipe;
    private final List<GhostIngredient> ingredients = Lists.newArrayList();
    float time;

    public void clear() {
        this.recipe = null;
        this.ingredients.clear();
        this.time = 0.0f;
    }

    public void addIngredient(Ingredient pIngredient, int pX, int pY) {
        this.ingredients.add(new GhostIngredient(pIngredient, pX, pY));
    }

    public GhostIngredient get(int pIndex) {
        return this.ingredients.get(pIndex);
    }

    public int size() {
        return this.ingredients.size();
    }

    @Nullable
    public Recipe<?> getRecipe() {
        return this.recipe;
    }

    public void setRecipe(Recipe<?> pRecipe) {
        this.recipe = pRecipe;
    }

    public void render(PoseStack p_100150_, Minecraft p_100151_, int p_100152_, int p_100153_, boolean p_100154_, float p_100155_) {
        if (!Screen.hasControlDown()) {
            this.time += p_100155_;
        }
        int i = 0;
        while (i < this.ingredients.size()) {
            GhostIngredient ghostrecipe$ghostingredient = this.ingredients.get(i);
            int j = ghostrecipe$ghostingredient.getX() + p_100152_;
            int k = ghostrecipe$ghostingredient.getY() + p_100153_;
            if (i == 0 && p_100154_) {
                GuiComponent.fill(p_100150_, j - 4, k - 4, j + 20, k + 20, 0x30FF0000);
            } else {
                GuiComponent.fill(p_100150_, j, k, j + 16, k + 16, 0x30FF0000);
            }
            ItemStack itemstack = ghostrecipe$ghostingredient.getItem();
            ItemRenderer itemrenderer = p_100151_.getItemRenderer();
            itemrenderer.renderAndDecorateFakeItem(itemstack, j, k);
            RenderSystem.depthFunc(516);
            GuiComponent.fill(p_100150_, j, k, j + 16, k + 16, 0x30FFFFFF);
            RenderSystem.depthFunc(515);
            if (i == 0) {
                itemrenderer.renderGuiItemDecorations(p_100151_.font, itemstack, j, k);
            }
            ++i;
        }
    }

    public class GhostIngredient {
        private final Ingredient ingredient;
        private final int x;
        private final int y;

        public GhostIngredient(Ingredient p_100166_, int p_100167_, int p_100168_) {
            this.ingredient = p_100166_;
            this.x = p_100167_;
            this.y = p_100168_;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public ItemStack getItem() {
            ItemStack[] aitemstack = this.ingredient.getItems();
            return aitemstack.length == 0 ? ItemStack.EMPTY : aitemstack[Mth.floor(GhostRecipe.this.time / 30.0f) % aitemstack.length];
        }
    }
}

