/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class OverlayRecipeComponent
extends GuiComponent
implements Widget,
GuiEventListener {
    static final ResourceLocation RECIPE_BOOK_LOCATION = new ResourceLocation("textures/gui/recipe_book.png");
    private static final int MAX_ROW = 4;
    private static final int MAX_ROW_LARGE = 5;
    private static final float ITEM_RENDER_SCALE = 0.375f;
    private final List<OverlayRecipeButton> recipeButtons = Lists.newArrayList();
    private boolean isVisible;
    private int x;
    private int y;
    Minecraft minecraft;
    private RecipeCollection collection;
    @Nullable
    private Recipe<?> lastRecipeClicked;
    float time;
    boolean isFurnaceMenu;

    public void init(Minecraft p_100195_, RecipeCollection p_100196_, int p_100197_, int p_100198_, int p_100199_, int p_100200_, float p_100201_) {
        float f5;
        float f4;
        float f3;
        float f2;
        float f1;
        this.minecraft = p_100195_;
        this.collection = p_100196_;
        if (p_100195_.player.containerMenu instanceof AbstractFurnaceMenu) {
            this.isFurnaceMenu = true;
        }
        boolean flag = p_100195_.player.getRecipeBook().isFiltering((RecipeBookMenu)p_100195_.player.containerMenu);
        List<Recipe<?>> list = p_100196_.getDisplayRecipes(true);
        List list1 = flag ? Collections.emptyList() : p_100196_.getDisplayRecipes(false);
        int i = list.size();
        int j = i + list1.size();
        int k = j <= 16 ? 4 : 5;
        int l = (int)Math.ceil((float)j / (float)k);
        this.x = p_100197_;
        this.y = p_100198_;
        int i1 = 25;
        float f = this.x + Math.min(j, k) * 25;
        if (f > (f1 = (float)(p_100199_ + 50))) {
            this.x = (int)((float)this.x - p_100201_ * (float)((int)((f - f1) / p_100201_)));
        }
        if ((f2 = (float)(this.y + l * 25)) > (f3 = (float)(p_100200_ + 50))) {
            this.y = (int)((float)this.y - p_100201_ * (float)Mth.ceil((f2 - f3) / p_100201_));
        }
        if ((f4 = (float)this.y) < (f5 = (float)(p_100200_ - 100))) {
            this.y = (int)((float)this.y - p_100201_ * (float)Mth.ceil((f4 - f5) / p_100201_));
        }
        this.isVisible = true;
        this.recipeButtons.clear();
        int j1 = 0;
        while (j1 < j) {
            boolean flag1 = j1 < i;
            Recipe recipe = flag1 ? list.get(j1) : (Recipe)list1.get(j1 - i);
            int k1 = this.x + 4 + 25 * (j1 % k);
            int l1 = this.y + 5 + 25 * (j1 / k);
            if (this.isFurnaceMenu) {
                this.recipeButtons.add(new OverlaySmeltingRecipeButton(k1, l1, recipe, flag1));
            } else {
                this.recipeButtons.add(new OverlayRecipeButton(k1, l1, recipe, flag1));
            }
            ++j1;
        }
        this.lastRecipeClicked = null;
    }

    @Override
    public boolean changeFocus(boolean pFocus) {
        return false;
    }

    public RecipeCollection getRecipeCollection() {
        return this.collection;
    }

    @Nullable
    public Recipe<?> getLastRecipeClicked() {
        return this.lastRecipeClicked;
    }

    @Override
    public boolean mouseClicked(double pMouseX, double p_100187_, int pMouseY) {
        if (pMouseY != 0) {
            return false;
        }
        for (OverlayRecipeButton overlayrecipecomponent$overlayrecipebutton : this.recipeButtons) {
            if (!overlayrecipecomponent$overlayrecipebutton.mouseClicked(pMouseX, p_100187_, pMouseY)) continue;
            this.lastRecipeClicked = overlayrecipecomponent$overlayrecipebutton.recipe;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMouseOver(double pMouseX, double p_100209_) {
        return false;
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.isVisible) {
            this.time += pPartialTick;
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShaderTexture(0, RECIPE_BOOK_LOCATION);
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, 0.0, 170.0);
            int i = this.recipeButtons.size() <= 16 ? 4 : 5;
            int j = Math.min(this.recipeButtons.size(), i);
            int k = Mth.ceil((float)this.recipeButtons.size() / (float)i);
            int l = 24;
            int i1 = 4;
            int j1 = 82;
            int k1 = 208;
            this.nineInchSprite(pPoseStack, j, k, 24, 4, 82, 208);
            RenderSystem.disableBlend();
            for (OverlayRecipeButton overlayrecipecomponent$overlayrecipebutton : this.recipeButtons) {
                overlayrecipecomponent$overlayrecipebutton.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
            pPoseStack.popPose();
        }
    }

    private void nineInchSprite(PoseStack p_100214_, int p_100215_, int p_100216_, int p_100217_, int p_100218_, int p_100219_, int p_100220_) {
        this.blit(p_100214_, this.x, this.y, p_100219_, p_100220_, p_100218_, p_100218_);
        this.blit(p_100214_, this.x + p_100218_ * 2 + p_100215_ * p_100217_, this.y, p_100219_ + p_100217_ + p_100218_, p_100220_, p_100218_, p_100218_);
        this.blit(p_100214_, this.x, this.y + p_100218_ * 2 + p_100216_ * p_100217_, p_100219_, p_100220_ + p_100217_ + p_100218_, p_100218_, p_100218_);
        this.blit(p_100214_, this.x + p_100218_ * 2 + p_100215_ * p_100217_, this.y + p_100218_ * 2 + p_100216_ * p_100217_, p_100219_ + p_100217_ + p_100218_, p_100220_ + p_100217_ + p_100218_, p_100218_, p_100218_);
        int i = 0;
        while (i < p_100215_) {
            this.blit(p_100214_, this.x + p_100218_ + i * p_100217_, this.y, p_100219_ + p_100218_, p_100220_, p_100217_, p_100218_);
            this.blit(p_100214_, this.x + p_100218_ + (i + 1) * p_100217_, this.y, p_100219_ + p_100218_, p_100220_, p_100218_, p_100218_);
            int j = 0;
            while (j < p_100216_) {
                if (i == 0) {
                    this.blit(p_100214_, this.x, this.y + p_100218_ + j * p_100217_, p_100219_, p_100220_ + p_100218_, p_100218_, p_100217_);
                    this.blit(p_100214_, this.x, this.y + p_100218_ + (j + 1) * p_100217_, p_100219_, p_100220_ + p_100218_, p_100218_, p_100218_);
                }
                this.blit(p_100214_, this.x + p_100218_ + i * p_100217_, this.y + p_100218_ + j * p_100217_, p_100219_ + p_100218_, p_100220_ + p_100218_, p_100217_, p_100217_);
                this.blit(p_100214_, this.x + p_100218_ + (i + 1) * p_100217_, this.y + p_100218_ + j * p_100217_, p_100219_ + p_100218_, p_100220_ + p_100218_, p_100218_, p_100217_);
                this.blit(p_100214_, this.x + p_100218_ + i * p_100217_, this.y + p_100218_ + (j + 1) * p_100217_, p_100219_ + p_100218_, p_100220_ + p_100218_, p_100217_, p_100218_);
                this.blit(p_100214_, this.x + p_100218_ + (i + 1) * p_100217_ - 1, this.y + p_100218_ + (j + 1) * p_100217_ - 1, p_100219_ + p_100218_, p_100220_ + p_100218_, p_100218_ + 1, p_100218_ + 1);
                if (i == p_100215_ - 1) {
                    this.blit(p_100214_, this.x + p_100218_ * 2 + p_100215_ * p_100217_, this.y + p_100218_ + j * p_100217_, p_100219_ + p_100217_ + p_100218_, p_100220_ + p_100218_, p_100218_, p_100217_);
                    this.blit(p_100214_, this.x + p_100218_ * 2 + p_100215_ * p_100217_, this.y + p_100218_ + (j + 1) * p_100217_, p_100219_ + p_100217_ + p_100218_, p_100220_ + p_100218_, p_100218_, p_100218_);
                }
                ++j;
            }
            this.blit(p_100214_, this.x + p_100218_ + i * p_100217_, this.y + p_100218_ * 2 + p_100216_ * p_100217_, p_100219_ + p_100218_, p_100220_ + p_100217_ + p_100218_, p_100217_, p_100218_);
            this.blit(p_100214_, this.x + p_100218_ + (i + 1) * p_100217_, this.y + p_100218_ * 2 + p_100216_ * p_100217_, p_100219_ + p_100218_, p_100220_ + p_100217_ + p_100218_, p_100218_, p_100218_);
            ++i;
        }
    }

    public void setVisible(boolean pIsVisible) {
        this.isVisible = pIsVisible;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    class OverlayRecipeButton
    extends AbstractWidget
    implements PlaceRecipe<Ingredient> {
        final Recipe<?> recipe;
        private final boolean isCraftable;
        protected final List<Pos> ingredientPos;

        public OverlayRecipeButton(int p_100232_, int p_100233_, Recipe<?> p_100234_, boolean p_100235_) {
            super(p_100232_, p_100233_, 200, 20, TextComponent.EMPTY);
            this.ingredientPos = Lists.newArrayList();
            this.width = 24;
            this.height = 24;
            this.recipe = p_100234_;
            this.isCraftable = p_100235_;
            this.calculateIngredientsPositions(p_100234_);
        }

        protected void calculateIngredientsPositions(Recipe<?> pRecipe) {
            this.placeRecipe(3, 3, -1, pRecipe, pRecipe.getIngredients().iterator(), 0);
        }

        @Override
        public void updateNarration(NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }

        @Override
        public void addItemToSlot(Iterator<Ingredient> pIngredients, int pSlot, int pMaxAmount, int pY, int pX) {
            ItemStack[] aitemstack = pIngredients.next().getItems();
            if (aitemstack.length != 0) {
                this.ingredientPos.add(new Pos(3 + pX * 7, 3 + pY * 7, aitemstack));
            }
        }

        @Override
        public void renderButton(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int j;
            RenderSystem.setShaderTexture(0, RECIPE_BOOK_LOCATION);
            int i = 152;
            if (!this.isCraftable) {
                i += 26;
            }
            int n = j = OverlayRecipeComponent.this.isFurnaceMenu ? 130 : 78;
            if (this.isHoveredOrFocused()) {
                j += 26;
            }
            this.blit(pPoseStack, this.x, this.y, i, j, this.width, this.height);
            PoseStack posestack = RenderSystem.getModelViewStack();
            posestack.pushPose();
            posestack.translate(this.x + 2, this.y + 2, 125.0);
            for (Pos overlayrecipecomponent$overlayrecipebutton$pos : this.ingredientPos) {
                posestack.pushPose();
                posestack.translate(overlayrecipecomponent$overlayrecipebutton$pos.x, overlayrecipecomponent$overlayrecipebutton$pos.y, 0.0);
                posestack.scale(0.375f, 0.375f, 1.0f);
                posestack.translate(-8.0, -8.0, 0.0);
                RenderSystem.applyModelViewMatrix();
                OverlayRecipeComponent.this.minecraft.getItemRenderer().renderAndDecorateItem(overlayrecipecomponent$overlayrecipebutton$pos.ingredients[Mth.floor(OverlayRecipeComponent.this.time / 30.0f) % overlayrecipecomponent$overlayrecipebutton$pos.ingredients.length], 0, 0);
                posestack.popPose();
            }
            posestack.popPose();
            RenderSystem.applyModelViewMatrix();
        }

        protected class Pos {
            public final ItemStack[] ingredients;
            public final int x;
            public final int y;

            public Pos(int p_100256_, int p_100257_, ItemStack[] p_100258_) {
                this.x = p_100256_;
                this.y = p_100257_;
                this.ingredients = p_100258_;
            }
        }
    }

    class OverlaySmeltingRecipeButton
    extends OverlayRecipeButton {
        public OverlaySmeltingRecipeButton(int p_100262_, int p_100263_, Recipe<?> p_100264_, boolean p_100265_) {
            super(p_100262_, p_100263_, p_100264_, p_100265_);
        }

        @Override
        protected void calculateIngredientsPositions(Recipe<?> p_100267_) {
            ItemStack[] aitemstack = p_100267_.getIngredients().get(0).getItems();
            this.ingredientPos.add(new OverlayRecipeButton.Pos(10, 10, aitemstack));
        }
    }
}

