/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeButton;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.Recipe;

public class RecipeBookPage {
    public static final int ITEMS_PER_PAGE = 20;
    private final List<RecipeButton> buttons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private RecipeButton hoveredButton;
    private final OverlayRecipeComponent overlay = new OverlayRecipeComponent();
    private Minecraft minecraft;
    private final List<RecipeShownListener> showListeners = Lists.newArrayList();
    private List<RecipeCollection> recipeCollections = ImmutableList.of();
    private StateSwitchingButton forwardButton;
    private StateSwitchingButton backButton;
    private int totalPages;
    private int currentPage;
    private RecipeBook recipeBook;
    @Nullable
    private Recipe<?> lastClickedRecipe;
    @Nullable
    private RecipeCollection lastClickedRecipeCollection;

    public RecipeBookPage() {
        int i = 0;
        while (i < 20) {
            this.buttons.add(new RecipeButton());
            ++i;
        }
    }

    public void init(Minecraft pMinecraft, int pX, int pY) {
        this.minecraft = pMinecraft;
        this.recipeBook = pMinecraft.player.getRecipeBook();
        int i = 0;
        while (i < this.buttons.size()) {
            this.buttons.get(i).setPosition(pX + 11 + 25 * (i % 5), pY + 31 + 25 * (i / 5));
            ++i;
        }
        this.forwardButton = new StateSwitchingButton(pX + 93, pY + 137, 12, 17, false);
        this.forwardButton.initTextureValues(1, 208, 13, 18, RecipeBookComponent.RECIPE_BOOK_LOCATION);
        this.backButton = new StateSwitchingButton(pX + 38, pY + 137, 12, 17, true);
        this.backButton.initTextureValues(1, 208, 13, 18, RecipeBookComponent.RECIPE_BOOK_LOCATION);
    }

    public void addListener(RecipeBookComponent p_100433_) {
        this.showListeners.remove(p_100433_);
        this.showListeners.add(p_100433_);
    }

    public void updateCollections(List<RecipeCollection> p_100437_, boolean p_100438_) {
        this.recipeCollections = p_100437_;
        this.totalPages = (int)Math.ceil((double)p_100437_.size() / 20.0);
        if (this.totalPages <= this.currentPage || p_100438_) {
            this.currentPage = 0;
        }
        this.updateButtonsForPage();
    }

    private void updateButtonsForPage() {
        int i = 20 * this.currentPage;
        int j = 0;
        while (j < this.buttons.size()) {
            RecipeButton recipebutton = this.buttons.get(j);
            if (i + j < this.recipeCollections.size()) {
                RecipeCollection recipecollection = this.recipeCollections.get(i + j);
                recipebutton.init(recipecollection, this);
                recipebutton.visible = true;
            } else {
                recipebutton.visible = false;
            }
            ++j;
        }
        this.updateArrowButtons();
    }

    private void updateArrowButtons() {
        this.forwardButton.visible = this.totalPages > 1 && this.currentPage < this.totalPages - 1;
        this.backButton.visible = this.totalPages > 1 && this.currentPage > 0;
    }

    public void render(PoseStack p_100422_, int p_100423_, int p_100424_, int p_100425_, int p_100426_, float p_100427_) {
        if (this.totalPages > 1) {
            String s = String.valueOf(this.currentPage + 1) + "/" + this.totalPages;
            int i = this.minecraft.font.width(s);
            this.minecraft.font.draw(p_100422_, s, (float)(p_100423_ - i / 2 + 73), (float)(p_100424_ + 141), -1);
        }
        this.hoveredButton = null;
        for (RecipeButton recipebutton : this.buttons) {
            recipebutton.render(p_100422_, p_100425_, p_100426_, p_100427_);
            if (!recipebutton.visible || !recipebutton.isHoveredOrFocused()) continue;
            this.hoveredButton = recipebutton;
        }
        this.backButton.render(p_100422_, p_100425_, p_100426_, p_100427_);
        this.forwardButton.render(p_100422_, p_100425_, p_100426_, p_100427_);
        this.overlay.render(p_100422_, p_100425_, p_100426_, p_100427_);
    }

    public void renderTooltip(PoseStack pPoseStack, int pX, int pY) {
        if (this.minecraft.screen != null && this.hoveredButton != null && !this.overlay.isVisible()) {
            this.minecraft.screen.renderComponentTooltip(pPoseStack, this.hoveredButton.getTooltipText(this.minecraft.screen), pX, pY);
        }
    }

    @Nullable
    public Recipe<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    @Nullable
    public RecipeCollection getLastClickedRecipeCollection() {
        return this.lastClickedRecipeCollection;
    }

    public void setInvisible() {
        this.overlay.setVisible(false);
    }

    public boolean mouseClicked(double p_100410_, double p_100411_, int p_100412_, int p_100413_, int p_100414_, int p_100415_, int p_100416_) {
        this.lastClickedRecipe = null;
        this.lastClickedRecipeCollection = null;
        if (this.overlay.isVisible()) {
            if (this.overlay.mouseClicked(p_100410_, p_100411_, p_100412_)) {
                this.lastClickedRecipe = this.overlay.getLastRecipeClicked();
                this.lastClickedRecipeCollection = this.overlay.getRecipeCollection();
            } else {
                this.overlay.setVisible(false);
            }
            return true;
        }
        if (this.forwardButton.mouseClicked(p_100410_, p_100411_, p_100412_)) {
            ++this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        if (this.backButton.mouseClicked(p_100410_, p_100411_, p_100412_)) {
            --this.currentPage;
            this.updateButtonsForPage();
            return true;
        }
        for (RecipeButton recipebutton : this.buttons) {
            if (!recipebutton.mouseClicked(p_100410_, p_100411_, p_100412_)) continue;
            if (p_100412_ == 0) {
                this.lastClickedRecipe = recipebutton.getRecipe();
                this.lastClickedRecipeCollection = recipebutton.getCollection();
            } else if (p_100412_ == 1 && !this.overlay.isVisible() && !recipebutton.isOnlyOption()) {
                this.overlay.init(this.minecraft, recipebutton.getCollection(), recipebutton.x, recipebutton.y, p_100413_ + p_100415_ / 2, p_100414_ + 13 + p_100416_ / 2, recipebutton.getWidth());
            }
            return true;
        }
        return false;
    }

    public void recipesShown(List<Recipe<?>> pRecipes) {
        for (RecipeShownListener recipeshownlistener : this.showListeners) {
            recipeshownlistener.recipesShown(pRecipes);
        }
    }

    public Minecraft getMinecraft() {
        return this.minecraft;
    }

    public RecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    protected void listButtons(Consumer<AbstractWidget> p_170054_) {
        p_170054_.accept(this.forwardButton);
        p_170054_.accept(this.backButton);
        this.buttons.forEach(p_170054_);
    }
}

