/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.recipebook;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class RecipeCollection {
    private final List<Recipe<?>> recipes;
    private final boolean singleResultItem;
    private final Set<Recipe<?>> craftable = Sets.newHashSet();
    private final Set<Recipe<?>> fitsDimensions = Sets.newHashSet();
    private final Set<Recipe<?>> known = Sets.newHashSet();

    public RecipeCollection(List<Recipe<?>> pRecipes) {
        this.recipes = ImmutableList.copyOf(pRecipes);
        this.singleResultItem = pRecipes.size() <= 1 ? true : RecipeCollection.allRecipesHaveSameResult(pRecipes);
    }

    private static boolean allRecipesHaveSameResult(List<Recipe<?>> pRecipes) {
        int i = pRecipes.size();
        ItemStack itemstack = pRecipes.get(0).getResultItem();
        int j = 1;
        while (j < i) {
            ItemStack itemstack1 = pRecipes.get(j).getResultItem();
            if (!ItemStack.isSame(itemstack, itemstack1) || !ItemStack.tagMatches(itemstack, itemstack1)) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean hasKnownRecipes() {
        return !this.known.isEmpty();
    }

    public void updateKnownRecipes(RecipeBook pBook) {
        for (Recipe<?> recipe : this.recipes) {
            if (!pBook.contains(recipe)) continue;
            this.known.add(recipe);
        }
    }

    public void canCraft(StackedContents pHandler, int pWidth, int pHeight, RecipeBook pBook) {
        for (Recipe<?> recipe : this.recipes) {
            boolean flag;
            boolean bl = flag = recipe.canCraftInDimensions(pWidth, pHeight) && pBook.contains(recipe);
            if (flag) {
                this.fitsDimensions.add(recipe);
            } else {
                this.fitsDimensions.remove(recipe);
            }
            if (flag && pHandler.canCraft(recipe, null)) {
                this.craftable.add(recipe);
                continue;
            }
            this.craftable.remove(recipe);
        }
    }

    public boolean isCraftable(Recipe<?> pRecipe) {
        return this.craftable.contains(pRecipe);
    }

    public boolean hasCraftable() {
        return !this.craftable.isEmpty();
    }

    public boolean hasFitting() {
        return !this.fitsDimensions.isEmpty();
    }

    public List<Recipe<?>> getRecipes() {
        return this.recipes;
    }

    public List<Recipe<?>> getRecipes(boolean pOnlyCraftable) {
        ArrayList list = Lists.newArrayList();
        Set<Recipe<?>> set = pOnlyCraftable ? this.craftable : this.fitsDimensions;
        for (Recipe<?> recipe : this.recipes) {
            if (!set.contains(recipe)) continue;
            list.add(recipe);
        }
        return list;
    }

    public List<Recipe<?>> getDisplayRecipes(boolean pOnlyCraftable) {
        ArrayList list = Lists.newArrayList();
        for (Recipe<?> recipe : this.recipes) {
            if (!this.fitsDimensions.contains(recipe) || this.craftable.contains(recipe) != pOnlyCraftable) continue;
            list.add(recipe);
        }
        return list;
    }

    public boolean hasSingleResultItem() {
        return this.singleResultItem;
    }
}

