/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.social;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.UserApiService;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.multiplayer.PlayerInfo;

public class PlayerSocialManager {
    private final Minecraft minecraft;
    private final Set<UUID> hiddenPlayers = Sets.newHashSet();
    private final UserApiService service;
    private final Map<String, UUID> discoveredNamesToUUID = Maps.newHashMap();
    private boolean onlineMode;
    private CompletableFuture<?> pendingBlockListRefresh = CompletableFuture.completedFuture(null);

    public PlayerSocialManager(Minecraft p_194057_, UserApiService p_194058_) {
        this.minecraft = p_194057_;
        this.service = p_194058_;
    }

    public void hidePlayer(UUID pId) {
        this.hiddenPlayers.add(pId);
    }

    public void showPlayer(UUID pId) {
        this.hiddenPlayers.remove(pId);
    }

    public boolean shouldHideMessageFrom(UUID pId) {
        return this.isHidden(pId) || this.isBlocked(pId);
    }

    public boolean isHidden(UUID pId) {
        return this.hiddenPlayers.contains(pId);
    }

    public void startOnlineMode() {
        this.onlineMode = true;
        this.pendingBlockListRefresh = this.pendingBlockListRefresh.thenRunAsync(() -> ((UserApiService)this.service).refreshBlockList(), Util.ioPool());
    }

    public void stopOnlineMode() {
        this.onlineMode = false;
    }

    public boolean isBlocked(UUID pId) {
        if (!this.onlineMode) {
            return false;
        }
        this.pendingBlockListRefresh.join();
        return this.service.isBlockedPlayer(pId);
    }

    public Set<UUID> getHiddenPlayers() {
        return this.hiddenPlayers;
    }

    public UUID getDiscoveredUUID(String p_100679_) {
        return this.discoveredNamesToUUID.getOrDefault(p_100679_, Util.NIL_UUID);
    }

    public void addPlayer(PlayerInfo pPlayerInfo) {
        Screen screen;
        GameProfile gameprofile = pPlayerInfo.getProfile();
        if (gameprofile.isComplete()) {
            this.discoveredNamesToUUID.put(gameprofile.getName(), gameprofile.getId());
        }
        if ((screen = this.minecraft.screen) instanceof SocialInteractionsScreen) {
            SocialInteractionsScreen socialinteractionsscreen = (SocialInteractionsScreen)screen;
            socialinteractionsscreen.onAddPlayer(pPlayerInfo);
        }
    }

    public void removePlayer(UUID pId) {
        Screen screen = this.minecraft.screen;
        if (screen instanceof SocialInteractionsScreen) {
            SocialInteractionsScreen socialinteractionsscreen = (SocialInteractionsScreen)screen;
            socialinteractionsscreen.onRemovePlayer(pId);
        }
    }
}

