/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.client.gui.screens.worldselection.EditGameRulesScreen;
import net.minecraft.client.gui.screens.worldselection.WorldGenSettingsComponent;
import net.minecraft.client.gui.screens.worldselection.WorldPreset;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.Commands;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.WorldStem;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.DataPackConfig;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;

public class CreateWorldScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TEMP_WORLD_PREFIX = "mcworld-";
    private static final Component GAME_MODEL_LABEL = new TranslatableComponent("selectWorld.gameMode");
    private static final Component SEED_LABEL = new TranslatableComponent("selectWorld.enterSeed");
    private static final Component SEED_INFO = new TranslatableComponent("selectWorld.seedInfo");
    private static final Component NAME_LABEL = new TranslatableComponent("selectWorld.enterName");
    private static final Component OUTPUT_DIR_INFO = new TranslatableComponent("selectWorld.resultFolder");
    private static final Component COMMANDS_INFO = new TranslatableComponent("selectWorld.allowCommands.info");
    @Nullable
    private final Screen lastScreen;
    private EditBox nameEdit;
    String resultFolder;
    private SelectedGameMode gameMode = SelectedGameMode.SURVIVAL;
    @Nullable
    private SelectedGameMode oldGameMode;
    private Difficulty difficulty = Difficulty.NORMAL;
    private boolean commands;
    private boolean commandsChanged;
    public boolean hardCore;
    protected DataPackConfig dataPacks;
    @Nullable
    private Path tempDataPackDir;
    @Nullable
    private PackRepository tempDataPackRepository;
    private boolean worldGenSettingsVisible;
    private Button createButton;
    private CycleButton<SelectedGameMode> modeButton;
    private CycleButton<Difficulty> difficultyButton;
    private Button moreOptionsButton;
    private Button gameRulesButton;
    private Button dataPacksButton;
    private CycleButton<Boolean> commandsButton;
    private Component gameModeHelp1;
    private Component gameModeHelp2;
    private String initName;
    private GameRules gameRules = new GameRules();
    public final WorldGenSettingsComponent worldGenSettingsComponent;

    public static CreateWorldScreen createFresh(@Nullable Screen p_205425_) {
        RegistryAccess.Frozen registryaccess$frozen = RegistryAccess.BUILTIN.get();
        return new CreateWorldScreen(p_205425_, DataPackConfig.DEFAULT, new WorldGenSettingsComponent(registryaccess$frozen, WorldGenSettings.makeDefault(registryaccess$frozen), Optional.of(WorldPreset.NORMAL), OptionalLong.empty()));
    }

    public static CreateWorldScreen createFromExisting(@Nullable Screen p_205427_, WorldStem p_205428_, @Nullable Path p_205429_) {
        WorldData worlddata = p_205428_.worldData();
        LevelSettings levelsettings = worlddata.getLevelSettings();
        WorldGenSettings worldgensettings = worlddata.worldGenSettings();
        RegistryAccess.Frozen registryaccess$frozen = p_205428_.registryAccess();
        DataPackConfig datapackconfig = levelsettings.getDataPackConfig();
        CreateWorldScreen createworldscreen = new CreateWorldScreen(p_205427_, datapackconfig, new WorldGenSettingsComponent(registryaccess$frozen, worldgensettings, WorldPreset.of(worldgensettings), OptionalLong.of(worldgensettings.seed())));
        createworldscreen.initName = levelsettings.levelName();
        createworldscreen.commands = levelsettings.allowCommands();
        createworldscreen.commandsChanged = true;
        createworldscreen.difficulty = levelsettings.difficulty();
        createworldscreen.gameRules.assignFrom(levelsettings.gameRules(), null);
        if (levelsettings.hardcore()) {
            createworldscreen.gameMode = SelectedGameMode.HARDCORE;
        } else if (levelsettings.gameType().isSurvival()) {
            createworldscreen.gameMode = SelectedGameMode.SURVIVAL;
        } else if (levelsettings.gameType().isCreative()) {
            createworldscreen.gameMode = SelectedGameMode.CREATIVE;
        }
        createworldscreen.tempDataPackDir = p_205429_;
        return createworldscreen;
    }

    private CreateWorldScreen(@Nullable Screen pLastScreen, DataPackConfig pDataPacks, WorldGenSettingsComponent pWorldGenSettingsComponent) {
        super(new TranslatableComponent("selectWorld.create"));
        this.lastScreen = pLastScreen;
        this.initName = I18n.a("selectWorld.newWorld", new Object[0]);
        this.dataPacks = pDataPacks;
        this.worldGenSettingsComponent = pWorldGenSettingsComponent;
    }

    @Override
    public void tick() {
        this.nameEdit.tick();
        this.worldGenSettingsComponent.tick();
    }

    @Override
    protected void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        this.nameEdit = new EditBox(this.font, this.width / 2 - 100, 60, 200, 20, (Component)new TranslatableComponent("selectWorld.enterName")){

            @Override
            protected MutableComponent createNarrationMessage() {
                return CommonComponents.joinForNarration(super.createNarrationMessage(), new TranslatableComponent("selectWorld.resultFolder")).append(" ").append(CreateWorldScreen.this.resultFolder);
            }
        };
        this.nameEdit.setValue(this.initName);
        this.nameEdit.setResponder(p_100932_ -> {
            this.initName = p_100932_;
            this.createButton.active = !this.nameEdit.getValue().isEmpty();
            this.updateResultFolder();
        });
        this.addWidget(this.nameEdit);
        int i = this.width / 2 - 155;
        int j = this.width / 2 + 5;
        this.modeButton = this.addRenderableWidget((GuiEventListener & Widget)CycleButton.builder(SelectedGameMode::getDisplayName).a((SelectedGameMode[])new SelectedGameMode[]{SelectedGameMode.SURVIVAL, SelectedGameMode.HARDCORE, SelectedGameMode.CREATIVE}).withInitialValue(this.gameMode).withCustomNarration(p_170190_ -> AbstractWidget.wrapDefaultNarrationMessage(p_170190_.getMessage()).append(CommonComponents.NARRATION_SEPARATOR).append(this.gameModeHelp1).append(" ").append(this.gameModeHelp2)).create(i, 100, 150, 20, GAME_MODEL_LABEL, (p_170165_, p_170166_) -> this.setGameMode((SelectedGameMode)((Object)p_170166_))));
        this.difficultyButton = this.addRenderableWidget((GuiEventListener & Widget)CycleButton.builder(Difficulty::getDisplayName).a((Difficulty[])Difficulty.values()).withInitialValue(this.getEffectiveDifficulty()).create(j, 100, 150, 20, new TranslatableComponent("options.difficulty"), (p_170162_, p_170163_) -> {
            this.difficulty = p_170163_;
        }));
        this.commandsButton = this.addRenderableWidget((GuiEventListener & Widget)CycleButton.onOffBuilder(this.commands && !this.hardCore).withCustomNarration(p_170160_ -> CommonComponents.joinForNarration(p_170160_.createDefaultNarrationMessage(), new TranslatableComponent("selectWorld.allowCommands.info"))).create(i, 151, 150, 20, new TranslatableComponent("selectWorld.allowCommands"), (p_170168_, p_170169_) -> {
            this.commandsChanged = true;
            this.commands = p_170169_;
        }));
        this.dataPacksButton = this.addRenderableWidget(new Button(j, 151, 150, 20, new TranslatableComponent("selectWorld.dataPacks"), p_170201_ -> this.openDataPackSelectionScreen()));
        this.gameRulesButton = this.addRenderableWidget(new Button(i, 185, 150, 20, new TranslatableComponent("selectWorld.gameRules"), p_100928_ -> this.minecraft.setScreen(new EditGameRulesScreen(this.gameRules.copy(), p_170182_ -> {
            this.minecraft.setScreen(this);
            p_170182_.ifPresent(p_170156_ -> {
                this.gameRules = p_170156_;
            });
        }))));
        this.worldGenSettingsComponent.init(this, this.minecraft, this.font);
        this.moreOptionsButton = this.addRenderableWidget(new Button(j, 185, 150, 20, new TranslatableComponent("selectWorld.moreWorldOptions"), p_100897_ -> this.toggleWorldGenSettingsVisibility()));
        this.createButton = this.addRenderableWidget(new Button(i, this.height - 28, 150, 20, new TranslatableComponent("selectWorld.create"), p_170188_ -> this.onCreate()));
        this.createButton.active = !this.initName.isEmpty();
        this.addRenderableWidget(new Button(j, this.height - 28, 150, 20, CommonComponents.GUI_CANCEL, p_170158_ -> this.popScreen()));
        this.refreshWorldGenSettingsVisibility();
        this.setInitialFocus(this.nameEdit);
        this.setGameMode(this.gameMode);
        this.updateResultFolder();
    }

    private Difficulty getEffectiveDifficulty() {
        return this.gameMode == SelectedGameMode.HARDCORE ? Difficulty.HARD : this.difficulty;
    }

    private void updateGameModeHelp() {
        this.gameModeHelp1 = new TranslatableComponent("selectWorld.gameMode." + this.gameMode.name + ".line1");
        this.gameModeHelp2 = new TranslatableComponent("selectWorld.gameMode." + this.gameMode.name + ".line2");
    }

    private void updateResultFolder() {
        this.resultFolder = this.nameEdit.getValue().trim();
        if (this.resultFolder.isEmpty()) {
            this.resultFolder = "World";
        }
        try {
            this.resultFolder = FileUtil.findAvailableName(this.minecraft.getLevelSource().getBaseDir(), this.resultFolder, "");
        }
        catch (Exception exception1) {
            this.resultFolder = "World";
            try {
                this.resultFolder = FileUtil.findAvailableName(this.minecraft.getLevelSource().getBaseDir(), this.resultFolder, "");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create save folder", exception);
            }
        }
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    private void onCreate() {
        this.minecraft.forceSetScreen(new GenericDirtMessageScreen(new TranslatableComponent("createWorld.preparing")));
        if (this.copyTempDataPackDirToNewWorld()) {
            this.cleanupTempResources();
            WorldGenSettings worldgensettings = this.worldGenSettingsComponent.makeSettings(this.hardCore);
            LevelSettings levelsettings = this.createLevelSettings(worldgensettings.isDebug());
            this.minecraft.createLevel(this.resultFolder, levelsettings, this.worldGenSettingsComponent.registryHolder(), worldgensettings);
        }
    }

    private LevelSettings createLevelSettings(boolean p_205448_) {
        String s = this.nameEdit.getValue().trim();
        if (p_205448_) {
            GameRules gamerules = new GameRules();
            gamerules.getRule(GameRules.RULE_DAYLIGHT).set(false, null);
            return new LevelSettings(s, GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, gamerules, DataPackConfig.DEFAULT);
        }
        return new LevelSettings(s, this.gameMode.gameType, this.hardCore, this.getEffectiveDifficulty(), this.commands && !this.hardCore, this.gameRules, this.dataPacks);
    }

    private void toggleWorldGenSettingsVisibility() {
        this.setWorldGenSettingsVisible(!this.worldGenSettingsVisible);
    }

    private void setGameMode(SelectedGameMode pGameMode) {
        if (!this.commandsChanged) {
            this.commands = pGameMode == SelectedGameMode.CREATIVE;
            this.commandsButton.setValue(this.commands);
        }
        if (pGameMode == SelectedGameMode.HARDCORE) {
            this.hardCore = true;
            this.commandsButton.active = false;
            this.commandsButton.setValue(false);
            this.worldGenSettingsComponent.switchToHardcore();
            this.difficultyButton.setValue(Difficulty.HARD);
            this.difficultyButton.active = false;
        } else {
            this.hardCore = false;
            this.commandsButton.active = true;
            this.commandsButton.setValue(this.commands);
            this.worldGenSettingsComponent.switchOutOfHardcode();
            this.difficultyButton.setValue(this.difficulty);
            this.difficultyButton.active = true;
        }
        this.gameMode = pGameMode;
        this.updateGameModeHelp();
    }

    public void refreshWorldGenSettingsVisibility() {
        this.setWorldGenSettingsVisible(this.worldGenSettingsVisible);
    }

    private void setWorldGenSettingsVisible(boolean pWorldGenSettingsVisible) {
        this.worldGenSettingsVisible = pWorldGenSettingsVisible;
        this.modeButton.visible = !pWorldGenSettingsVisible;
        boolean bl = this.difficultyButton.visible = !pWorldGenSettingsVisible;
        if (this.worldGenSettingsComponent.isDebug()) {
            this.dataPacksButton.visible = false;
            this.modeButton.active = false;
            if (this.oldGameMode == null) {
                this.oldGameMode = this.gameMode;
            }
            this.setGameMode(SelectedGameMode.DEBUG);
            this.commandsButton.visible = false;
        } else {
            this.modeButton.active = true;
            if (this.oldGameMode != null) {
                this.setGameMode(this.oldGameMode);
            }
            this.commandsButton.visible = !pWorldGenSettingsVisible;
            this.dataPacksButton.visible = !pWorldGenSettingsVisible;
        }
        this.worldGenSettingsComponent.setVisibility(pWorldGenSettingsVisible);
        this.nameEdit.setVisible(!pWorldGenSettingsVisible);
        if (pWorldGenSettingsVisible) {
            this.moreOptionsButton.setMessage(CommonComponents.GUI_DONE);
        } else {
            this.moreOptionsButton.setMessage(new TranslatableComponent("selectWorld.moreWorldOptions"));
        }
        this.gameRulesButton.visible = !pWorldGenSettingsVisible;
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        if (pKeyCode != 257 && pKeyCode != 335) {
            return false;
        }
        this.onCreate();
        return true;
    }

    @Override
    public void onClose() {
        if (this.worldGenSettingsVisible) {
            this.setWorldGenSettingsVisible(false);
        } else {
            this.popScreen();
        }
    }

    public void popScreen() {
        this.minecraft.setScreen(this.lastScreen);
        this.cleanupTempResources();
    }

    private void cleanupTempResources() {
        if (this.tempDataPackRepository != null) {
            this.tempDataPackRepository.close();
        }
        this.removeTempDataPackDir();
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        CreateWorldScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 20, -1);
        if (this.worldGenSettingsVisible) {
            CreateWorldScreen.drawString(pPoseStack, this.font, SEED_LABEL, this.width / 2 - 100, 47, -6250336);
            CreateWorldScreen.drawString(pPoseStack, this.font, SEED_INFO, this.width / 2 - 100, 85, -6250336);
            this.worldGenSettingsComponent.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        } else {
            CreateWorldScreen.drawString(pPoseStack, this.font, NAME_LABEL, this.width / 2 - 100, 47, -6250336);
            CreateWorldScreen.drawString(pPoseStack, this.font, new TextComponent("").append(OUTPUT_DIR_INFO).append(" ").append(this.resultFolder), this.width / 2 - 100, 85, -6250336);
            this.nameEdit.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            CreateWorldScreen.drawString(pPoseStack, this.font, this.gameModeHelp1, this.width / 2 - 150, 122, -6250336);
            CreateWorldScreen.drawString(pPoseStack, this.font, this.gameModeHelp2, this.width / 2 - 150, 134, -6250336);
            if (this.commandsButton.visible) {
                CreateWorldScreen.drawString(pPoseStack, this.font, COMMANDS_INFO, this.width / 2 - 150, 172, -6250336);
            }
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }

    @Override
    protected <T extends GuiEventListener & NarratableEntry> T addWidget(T pListener) {
        return super.addWidget(pListener);
    }

    @Override
    protected <T extends GuiEventListener & Widget> T addRenderableWidget(T pWidget) {
        return super.addRenderableWidget(pWidget);
    }

    @Nullable
    protected Path getTempDataPackDir() {
        if (this.tempDataPackDir == null) {
            try {
                this.tempDataPackDir = Files.createTempDirectory(TEMP_WORLD_PREFIX, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to create temporary dir", (Throwable)ioexception);
                SystemToast.onPackCopyFailure(this.minecraft, this.resultFolder);
                this.popScreen();
            }
        }
        return this.tempDataPackDir;
    }

    private void openDataPackSelectionScreen() {
        Pair<File, PackRepository> pair = this.getDataPackSelectionSettings();
        if (pair != null) {
            this.minecraft.setScreen(new PackSelectionScreen(this, (PackRepository)pair.getSecond(), this::tryApplyNewDataPacks, (File)pair.getFirst(), new TranslatableComponent("dataPack.title")));
        }
    }

    private void tryApplyNewDataPacks(PackRepository p_100879_) {
        ImmutableList list = ImmutableList.copyOf(p_100879_.getSelectedIds());
        List list1 = (List)p_100879_.getAvailableIds().stream().filter(arg_0 -> CreateWorldScreen.lambda$16((List)list, arg_0)).collect(ImmutableList.toImmutableList());
        DataPackConfig datapackconfig = new DataPackConfig((List<String>)list, list1);
        if (list.equals(this.dataPacks.getEnabled())) {
            this.dataPacks = datapackconfig;
        } else {
            this.minecraft.tell(() -> this.minecraft.setScreen(new GenericDirtMessageScreen(new TranslatableComponent("dataPack.validation.working"))));
            ((CompletableFuture)WorldStem.load(new WorldStem.InitConfig(p_100879_, Commands.CommandSelection.INTEGRATED, 2, false), () -> datapackconfig, (p_205414_, p_205415_) -> {
                RegistryAccess registryaccess = this.worldGenSettingsComponent.registryHolder();
                RegistryAccess.Writable registryaccess$writable = RegistryAccess.builtinCopy();
                RegistryOps dynamicops = RegistryOps.create(JsonOps.INSTANCE, registryaccess);
                RegistryOps dynamicops1 = RegistryOps.createAndLoad(JsonOps.INSTANCE, registryaccess$writable, p_205414_);
                DataResult dataresult = WorldGenSettings.CODEC.encodeStart(dynamicops, (Object)this.worldGenSettingsComponent.makeSettings(this.hardCore)).flatMap(p_205423_ -> WorldGenSettings.CODEC.parse(dynamicops1, p_205423_));
                WorldGenSettings worldgensettings = (WorldGenSettings)dataresult.getOrThrow(false, Util.prefix("Error parsing worldgen settings after loading data packs: ", arg_0 -> ((Logger)LOGGER).error(arg_0)));
                LevelSettings levelsettings = this.createLevelSettings(worldgensettings.isDebug());
                return Pair.of((Object)new PrimaryLevelData(levelsettings, worldgensettings, dataresult.lifecycle()), (Object)registryaccess$writable.freeze());
            }, Util.backgroundExecutor(), this.minecraft).thenAcceptAsync(p_205420_ -> {
                this.dataPacks = datapackconfig;
                this.worldGenSettingsComponent.updateDataPacks((WorldStem)p_205420_);
                p_205420_.close();
            }, (Executor)this.minecraft)).handle((p_205431_, p_205432_) -> {
                if (p_205432_ != null) {
                    LOGGER.warn("Failed to validate datapack", p_205432_);
                    this.minecraft.tell(() -> this.minecraft.setScreen(new ConfirmScreen(p_205450_ -> {
                        if (p_205450_) {
                            this.openDataPackSelectionScreen();
                        } else {
                            this.dataPacks = DataPackConfig.DEFAULT;
                            this.minecraft.setScreen(this);
                        }
                    }, new TranslatableComponent("dataPack.validation.failed"), TextComponent.EMPTY, new TranslatableComponent("dataPack.validation.back"), new TranslatableComponent("dataPack.validation.reset"))));
                } else {
                    this.minecraft.tell(() -> this.minecraft.setScreen(this));
                }
                return null;
            });
        }
    }

    private void removeTempDataPackDir() {
        if (this.tempDataPackDir != null) {
            try (Stream<Path> stream = Files.walk(this.tempDataPackDir, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p_205443_ -> {
                    try {
                        Files.delete(p_205443_);
                    }
                    catch (IOException ioexception1) {
                        LOGGER.warn("Failed to remove temporary file {}", p_205443_, (Object)ioexception1);
                    }
                });
            }
            catch (IOException ioexception) {
                LOGGER.warn("Failed to list temporary dir {}", (Object)this.tempDataPackDir);
            }
            this.tempDataPackDir = null;
        }
    }

    private static void copyBetweenDirs(Path p_100913_, Path p_100914_, Path p_100915_) {
        try {
            Util.copyBetweenDirs(p_100913_, p_100914_, p_100915_);
        }
        catch (IOException ioexception) {
            LOGGER.warn("Failed to copy datapack file from {} to {}", (Object)p_100915_, (Object)p_100914_);
            throw new OperationFailedException(ioexception);
        }
    }

    private boolean copyTempDataPackDirToNewWorld() {
        if (this.tempDataPackDir != null) {
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().createAccess(this.resultFolder);
                 Stream<Path> stream = Files.walk(this.tempDataPackDir, new FileVisitOption[0]);){
                Path path = levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.DATAPACK_DIR);
                Files.createDirectories(path, new FileAttribute[0]);
                stream.filter(p_205434_ -> !p_205434_.equals(this.tempDataPackDir)).forEach(p_205446_ -> CreateWorldScreen.copyBetweenDirs(this.tempDataPackDir, path, p_205446_));
            }
            catch (IOException | OperationFailedException ioexception) {
                LOGGER.warn("Failed to copy datapacks to world {}", (Object)this.resultFolder, (Object)ioexception);
                SystemToast.onPackCopyFailure(this.minecraft, this.resultFolder);
                this.popScreen();
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Path createTempDataPackDirFromExistingWorld(Path p_100907_, Minecraft p_100908_) {
        MutableObject mutableobject = new MutableObject();
        try (Stream<Path> stream = Files.walk(p_100907_, new FileVisitOption[0]);){
            stream.filter(p_205437_ -> !p_205437_.equals(p_100907_)).forEach(p_205441_ -> {
                Path path2 = (Path)mutableobject.getValue();
                if (path2 == null) {
                    try {
                        path2 = Files.createTempDirectory(TEMP_WORLD_PREFIX, new FileAttribute[0]);
                    }
                    catch (IOException ioexception1) {
                        LOGGER.warn("Failed to create temporary dir");
                        throw new OperationFailedException(ioexception1);
                    }
                    mutableobject.setValue((Object)path2);
                }
                CreateWorldScreen.copyBetweenDirs(p_100907_, path2, p_205441_);
            });
        }
        catch (IOException | OperationFailedException ioexception) {
            LOGGER.warn("Failed to copy datapacks from world {}", (Object)p_100907_, (Object)ioexception);
            SystemToast.onPackCopyFailure(p_100908_, p_100907_.toString());
            return null;
        }
        return (Path)mutableobject.getValue();
    }

    @Nullable
    private Pair<File, PackRepository> getDataPackSelectionSettings() {
        Path path = this.getTempDataPackDir();
        if (path != null) {
            File file1 = path.toFile();
            if (this.tempDataPackRepository == null) {
                this.tempDataPackRepository = new PackRepository(PackType.SERVER_DATA, new ServerPacksSource(), new FolderRepositorySource(file1, PackSource.DEFAULT));
                this.tempDataPackRepository.reload();
            }
            this.tempDataPackRepository.setSelected(this.dataPacks.getEnabled());
            return Pair.of((Object)file1, (Object)this.tempDataPackRepository);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$16(List list, String p_170180_) {
        return !list.contains(p_170180_);
    }

    static class OperationFailedException
    extends RuntimeException {
        public OperationFailedException(Throwable p_101023_) {
            super(p_101023_);
        }
    }

    static enum SelectedGameMode {
        SURVIVAL("survival", GameType.SURVIVAL),
        HARDCORE("hardcore", GameType.SURVIVAL),
        CREATIVE("creative", GameType.CREATIVE),
        DEBUG("spectator", GameType.SPECTATOR);

        final String name;
        final GameType gameType;
        private final Component displayName;

        private SelectedGameMode(String p_101035_, GameType p_101036_) {
            this.name = p_101035_;
            this.gameType = p_101036_;
            this.displayName = new TranslatableComponent("selectWorld.gameMode." + p_101035_);
        }

        public Component getDisplayName() {
            return this.displayName;
        }
    }
}

