/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.GameRules;

public class EditGameRulesScreen
extends Screen {
    private final Consumer<Optional<GameRules>> exitCallback;
    private RuleList rules;
    private final Set<RuleEntry> invalidEntries = Sets.newHashSet();
    private Button doneButton;
    @Nullable
    private List<FormattedCharSequence> tooltip;
    private final GameRules gameRules;

    public EditGameRulesScreen(GameRules pGameRules, Consumer<Optional<GameRules>> pExitCallback) {
        super(new TranslatableComponent("editGamerule.title"));
        this.gameRules = pGameRules;
        this.exitCallback = pExitCallback;
    }

    @Override
    protected void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        super.init();
        this.rules = new RuleList(this.gameRules);
        this.addWidget(this.rules);
        this.addRenderableWidget(new Button(this.width / 2 - 155 + 160, this.height - 29, 150, 20, CommonComponents.GUI_CANCEL, p_101073_ -> this.exitCallback.accept(Optional.empty())));
        this.doneButton = this.addRenderableWidget(new Button(this.width / 2 - 155, this.height - 29, 150, 20, CommonComponents.GUI_DONE, p_101059_ -> this.exitCallback.accept(Optional.of(this.gameRules))));
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    @Override
    public void onClose() {
        this.exitCallback.accept(Optional.empty());
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.tooltip = null;
        this.rules.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        EditGameRulesScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        if (this.tooltip != null) {
            this.renderTooltip(pPoseStack, this.tooltip, pMouseX, pMouseY);
        }
    }

    void setTooltip(@Nullable List<FormattedCharSequence> pTooltip) {
        this.tooltip = pTooltip;
    }

    private void updateDoneButton() {
        this.doneButton.active = this.invalidEntries.isEmpty();
    }

    void markInvalid(RuleEntry pRuleEntry) {
        this.invalidEntries.add(pRuleEntry);
        this.updateDoneButton();
    }

    void clearInvalid(RuleEntry pRuleEntry) {
        this.invalidEntries.remove(pRuleEntry);
        this.updateDoneButton();
    }

    public class BooleanRuleEntry
    extends GameRuleEntry {
        private final CycleButton<Boolean> checkbox;

        public BooleanRuleEntry(Component p_101101_, List<FormattedCharSequence> p_101102_, String p_101103_, GameRules.BooleanValue p_101104_) {
            super(p_101102_, p_101101_);
            this.checkbox = CycleButton.onOffBuilder(p_101104_.get()).displayOnlyValue().withCustomNarration(p_170219_ -> p_170219_.createDefaultNarrationMessage().append("\n").append(p_101103_)).create(10, 5, 44, 20, p_101101_, (p_170215_, p_170216_) -> p_101104_.set((boolean)p_170216_, null));
            this.children.add(this.checkbox);
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderLabel(pPoseStack, pTop, pLeft);
            this.checkbox.x = pLeft + pWidth - 45;
            this.checkbox.y = pTop;
            this.checkbox.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }

    public class CategoryRuleEntry
    extends RuleEntry {
        final Component label;

        public CategoryRuleEntry(Component p_101141_) {
            super(null);
            this.label = p_101141_;
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            GuiComponent.drawCenteredString(pPoseStack, ((EditGameRulesScreen)EditGameRulesScreen.this).minecraft.font, this.label, pLeft + pWidth / 2, pTop + 5, 0xFFFFFF);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return ImmutableList.of();
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)new NarratableEntry(){

                @Override
                public NarratableEntry.NarrationPriority narrationPriority() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                @Override
                public void updateNarration(NarrationElementOutput p_170225_) {
                    p_170225_.add(NarratedElementType.TITLE, CategoryRuleEntry.this.label);
                }
            });
        }
    }

    @FunctionalInterface
    static interface EntryFactory<T extends GameRules.Value<T>> {
        public RuleEntry create(Component var1, List<FormattedCharSequence> var2, String var3, T var4);
    }

    public abstract class GameRuleEntry
    extends RuleEntry {
        private final List<FormattedCharSequence> label;
        protected final List<AbstractWidget> children;

        public GameRuleEntry(List<FormattedCharSequence> p_101164_, Component p_101165_) {
            super(p_101164_);
            this.children = Lists.newArrayList();
            this.label = ((EditGameRulesScreen)EditGameRulesScreen.this).minecraft.font.split(p_101165_, 175);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.children;
        }

        protected void renderLabel(PoseStack pPoseStack, int pX, int pY) {
            if (this.label.size() == 1) {
                ((EditGameRulesScreen)EditGameRulesScreen.this).minecraft.font.draw(pPoseStack, this.label.get(0), (float)pY, (float)(pX + 5), 0xFFFFFF);
            } else if (this.label.size() >= 2) {
                ((EditGameRulesScreen)EditGameRulesScreen.this).minecraft.font.draw(pPoseStack, this.label.get(0), (float)pY, (float)pX, 0xFFFFFF);
                ((EditGameRulesScreen)EditGameRulesScreen.this).minecraft.font.draw(pPoseStack, this.label.get(1), (float)pY, (float)(pX + 10), 0xFFFFFF);
            }
        }
    }

    public class IntegerRuleEntry
    extends GameRuleEntry {
        private final EditBox input;

        public IntegerRuleEntry(Component p_101175_, List<FormattedCharSequence> p_101176_, String p_101177_, GameRules.IntegerValue p_101178_) {
            super(p_101176_, p_101175_);
            this.input = new EditBox(((EditGameRulesScreen)EditGameRulesScreen.this).minecraft.font, 10, 5, 42, 20, p_101175_.copy().append("\n").append(p_101177_).append("\n"));
            this.input.setValue(Integer.toString(p_101178_.get()));
            this.input.setResponder(p_101181_ -> {
                if (p_101178_.tryDeserialize((String)p_101181_)) {
                    this.input.setTextColor(0xE0E0E0);
                    EditGameRulesScreen.this.clearInvalid(this);
                } else {
                    this.input.setTextColor(0xFF0000);
                    EditGameRulesScreen.this.markInvalid(this);
                }
            });
            this.children.add(this.input);
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            this.renderLabel(pPoseStack, pTop, pLeft);
            this.input.x = pLeft + pWidth - 44;
            this.input.y = pTop;
            this.input.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        }
    }

    public static abstract class RuleEntry
    extends ContainerObjectSelectionList.Entry<RuleEntry> {
        @Nullable
        final List<FormattedCharSequence> tooltip;

        public RuleEntry(@Nullable List<FormattedCharSequence> p_194062_) {
            this.tooltip = p_194062_;
        }
    }

    public class RuleList
    extends ContainerObjectSelectionList<RuleEntry> {
        public RuleList(final GameRules p_101203_) {
            super(EditGameRulesScreen.this.minecraft, EditGameRulesScreen.this.width, EditGameRulesScreen.this.height, 43, EditGameRulesScreen.this.height - 32, 24);
            final HashMap map = Maps.newHashMap();
            GameRules.visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

                @Override
                public void visitBoolean(GameRules.Key<GameRules.BooleanValue> p_101238_, GameRules.Type<GameRules.BooleanValue> p_101239_) {
                    this.addEntry(p_101238_, (p_101228_, p_101229_, p_101230_, p_101231_) -> {
                        EditGameRulesScreen editGameRulesScreen = EditGameRulesScreen.this;
                        editGameRulesScreen.getClass();
                        return editGameRulesScreen.new BooleanRuleEntry(p_101228_, p_101229_, p_101230_, (GameRules.BooleanValue)p_101231_);
                    });
                }

                @Override
                public void visitInteger(GameRules.Key<GameRules.IntegerValue> p_101241_, GameRules.Type<GameRules.IntegerValue> p_101242_) {
                    this.addEntry(p_101241_, (p_101233_, p_101234_, p_101235_, p_101236_) -> {
                        EditGameRulesScreen editGameRulesScreen = EditGameRulesScreen.this;
                        editGameRulesScreen.getClass();
                        return editGameRulesScreen.new IntegerRuleEntry(p_101233_, p_101234_, p_101235_, (GameRules.IntegerValue)p_101236_);
                    });
                }

                private <T extends GameRules.Value<T>> void addEntry(GameRules.Key<T> p_101225_, EntryFactory<T> p_101226_) {
                    String s2;
                    ImmutableList list;
                    TranslatableComponent component = new TranslatableComponent(p_101225_.getDescriptionId());
                    MutableComponent component1 = new TextComponent(p_101225_.getId()).withStyle(ChatFormatting.YELLOW);
                    T t = p_101203_.getRule(p_101225_);
                    String s = ((GameRules.Value)t).serialize();
                    MutableComponent component2 = new TranslatableComponent("editGamerule.default", new TextComponent(s)).withStyle(ChatFormatting.GRAY);
                    String s1 = String.valueOf(p_101225_.getDescriptionId()) + ".description";
                    if (I18n.exists(s1)) {
                        ImmutableList.Builder builder = ImmutableList.builder().add((Object)component1.getVisualOrderText());
                        TranslatableComponent component3 = new TranslatableComponent(s1);
                        EditGameRulesScreen.this.font.split(component3, 150).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                        list = builder.add((Object)component2.getVisualOrderText()).build();
                        s2 = String.valueOf(component3.getString()) + "\n" + component2.getString();
                    } else {
                        list = ImmutableList.of((Object)component1.getVisualOrderText(), (Object)component2.getVisualOrderText());
                        s2 = component2.getString();
                    }
                    map.computeIfAbsent(p_101225_.getCategory(), p_101223_ -> Maps.newHashMap()).put(p_101225_, p_101226_.create(component, (List<FormattedCharSequence>)list, s2, t));
                }
            });
            map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(p_101210_ -> {
                EditGameRulesScreen editGameRulesScreen = EditGameRulesScreen.this;
                editGameRulesScreen.getClass();
                this.addEntry(editGameRulesScreen.new CategoryRuleEntry(new TranslatableComponent(((GameRules.Category)((Object)((Object)p_101210_.getKey()))).getDescriptionId()).a(ChatFormatting.BOLD, ChatFormatting.YELLOW)));
                ((Map)p_101210_.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparing(GameRules.Key::getId))).forEach(p_170229_ -> this.addEntry((RuleEntry)p_170229_.getValue()));
            });
        }

        @Override
        public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
            RuleEntry editgamerulesscreen$ruleentry = (RuleEntry)this.getHovered();
            if (editgamerulesscreen$ruleentry != null) {
                EditGameRulesScreen.this.setTooltip(editgamerulesscreen$ruleentry.tooltip);
            }
        }
    }
}

