/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.OptimizeWorldScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.WorldStem;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class EditWorldScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson WORLD_GEN_SETTINGS_GSON = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();
    private static final Component NAME_LABEL = new TranslatableComponent("selectWorld.enterName");
    private Button renameButton;
    private final BooleanConsumer callback;
    private EditBox nameEdit;
    private final LevelStorageSource.LevelStorageAccess levelAccess;

    public EditWorldScreen(BooleanConsumer pCallback, LevelStorageSource.LevelStorageAccess pLevelAccess) {
        super(new TranslatableComponent("selectWorld.edit.title"));
        this.callback = pCallback;
        this.levelAccess = pLevelAccess;
    }

    @Override
    public void tick() {
        this.nameEdit.tick();
    }

    @Override
    protected void init() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(true);
        Button button = this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 0 + 5, 200, 20, new TranslatableComponent("selectWorld.edit.resetIcon"), p_101297_ -> {
            this.levelAccess.getIconFile().ifPresent(p_182594_ -> FileUtils.deleteQuietly((File)p_182594_.toFile()));
            p_101297_.active = false;
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 24 + 5, 200, 20, new TranslatableComponent("selectWorld.edit.openFolder"), p_101294_ -> Util.getPlatform().openFile(this.levelAccess.getLevelPath(LevelResource.ROOT).toFile())));
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 48 + 5, 200, 20, new TranslatableComponent("selectWorld.edit.backup"), p_101292_ -> {
            boolean flag = EditWorldScreen.makeBackupAndShowToast(this.levelAccess);
            this.callback.accept(!flag);
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 72 + 5, 200, 20, new TranslatableComponent("selectWorld.edit.backupFolder"), p_101290_ -> {
            LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
            Path path = levelstoragesource.getBackupPath();
            try {
                Files.createDirectories(Files.exists(path, new LinkOption[0]) ? path.toRealPath(new LinkOption[0]) : path, new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                throw new RuntimeException(ioexception);
            }
            Util.getPlatform().openFile(path.toFile());
        }));
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 96 + 5, 200, 20, new TranslatableComponent("selectWorld.edit.optimize"), p_101287_ -> this.minecraft.setScreen(new BackupConfirmScreen(this, (p_170235_, p_170236_) -> {
            if (p_170235_) {
                EditWorldScreen.makeBackupAndShowToast(this.levelAccess);
            }
            this.minecraft.setScreen(OptimizeWorldScreen.create(this.minecraft, this.callback, this.minecraft.getFixerUpper(), this.levelAccess, p_170236_));
        }, new TranslatableComponent("optimizeWorld.confirm.title"), new TranslatableComponent("optimizeWorld.confirm.description"), true))));
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 120 + 5, 200, 20, new TranslatableComponent("selectWorld.edit.export_worldgen_settings"), p_101284_ -> {
            DataResult dataresult;
            try (WorldStem worldstem = this.minecraft.makeWorldStem(this.levelAccess, false);){
                RegistryOps dynamicops = RegistryOps.create(JsonOps.INSTANCE, worldstem.registryAccess());
                DataResult dataresult1 = WorldGenSettings.CODEC.encodeStart(dynamicops, (Object)worldstem.worldData().worldGenSettings());
                dataresult = dataresult1.flatMap(p_170231_ -> {
                    Path path = this.levelAccess.getLevelPath(LevelResource.ROOT).resolve("worldgen_settings_export.json");
                    try (JsonWriter jsonwriter = WORLD_GEN_SETTINGS_GSON.newJsonWriter((Writer)Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));){
                        WORLD_GEN_SETTINGS_GSON.toJson(p_170231_, jsonwriter);
                    }
                    catch (JsonIOException | IOException ioexception) {
                        return DataResult.error((String)("Error writing file: " + ioexception.getMessage()));
                    }
                    return DataResult.success((Object)path.toString());
                });
            }
            catch (Exception exception) {
                LOGGER.warn("Could not parse level data", (Throwable)exception);
                dataresult = DataResult.error((String)("Could not parse level data: " + exception.getMessage()));
            }
            TextComponent component = new TextComponent((String)dataresult.get().map(Function.identity(), DataResult.PartialResult::message));
            TranslatableComponent component1 = new TranslatableComponent(dataresult.result().isPresent() ? "selectWorld.edit.export_worldgen_settings.success" : "selectWorld.edit.export_worldgen_settings.failure");
            dataresult.error().ifPresent(p_170233_ -> LOGGER.error("Error exporting world settings: {}", p_170233_));
            this.minecraft.getToasts().addToast(SystemToast.multiline(this.minecraft, SystemToast.SystemToastIds.WORLD_GEN_SETTINGS_TRANSFER, component1, component));
        }));
        this.renameButton = this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 144 + 5, 98, 20, new TranslatableComponent("selectWorld.edit.save"), p_101280_ -> this.onRename()));
        this.addRenderableWidget(new Button(this.width / 2 + 2, this.height / 4 + 144 + 5, 98, 20, CommonComponents.GUI_CANCEL, p_101273_ -> this.callback.accept(false)));
        button.active = this.levelAccess.getIconFile().filter(p_182587_ -> Files.isRegularFile(p_182587_, new LinkOption[0])).isPresent();
        LevelSummary levelsummary = this.levelAccess.getSummary();
        String s = levelsummary == null ? "" : levelsummary.getLevelName();
        this.nameEdit = new EditBox(this.font, this.width / 2 - 100, 38, 200, 20, new TranslatableComponent("selectWorld.enterName"));
        this.nameEdit.setValue(s);
        this.nameEdit.setResponder(p_101282_ -> {
            this.renameButton.active = !p_101282_.trim().isEmpty();
        });
        this.addWidget(this.nameEdit);
        this.setInitialFocus(this.nameEdit);
    }

    @Override
    public void resize(Minecraft pMinecraft, int pWidth, int pHeight) {
        String s = this.nameEdit.getValue();
        this.init(pMinecraft, pWidth, pHeight);
        this.nameEdit.setValue(s);
    }

    @Override
    public void onClose() {
        this.callback.accept(false);
    }

    @Override
    public void removed() {
        this.minecraft.keyboardHandler.setSendRepeatsToGui(false);
    }

    private void onRename() {
        try {
            this.levelAccess.renameLevel(this.nameEdit.getValue().trim());
            this.callback.accept(true);
        }
        catch (IOException ioexception) {
            LOGGER.error("Failed to access world '{}'", (Object)this.levelAccess.getLevelId(), (Object)ioexception);
            SystemToast.onWorldAccessFailure(this.minecraft, this.levelAccess.getLevelId());
            this.callback.accept(true);
        }
    }

    public static void makeBackupAndShowToast(LevelStorageSource p_101261_, String p_101262_) {
        boolean flag = false;
        try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = p_101261_.createAccess(p_101262_);){
            flag = true;
            EditWorldScreen.makeBackupAndShowToast(levelstoragesource$levelstorageaccess);
        }
        catch (IOException ioexception) {
            if (!flag) {
                SystemToast.onWorldAccessFailure(Minecraft.getInstance(), p_101262_);
            }
            LOGGER.warn("Failed to create backup of level {}", (Object)p_101262_, (Object)ioexception);
        }
    }

    public static boolean makeBackupAndShowToast(LevelStorageSource.LevelStorageAccess p_101259_) {
        long i = 0L;
        IOException ioexception = null;
        try {
            i = p_101259_.makeWorldBackup();
        }
        catch (IOException ioexception1) {
            ioexception = ioexception1;
        }
        if (ioexception != null) {
            TranslatableComponent component2 = new TranslatableComponent("selectWorld.edit.backupFailed");
            TextComponent component3 = new TextComponent(ioexception.getMessage());
            Minecraft.getInstance().getToasts().addToast(new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, component2, component3));
            return false;
        }
        TranslatableComponent component = new TranslatableComponent("selectWorld.edit.backupCreated", p_101259_.getLevelId());
        TranslatableComponent component1 = new TranslatableComponent("selectWorld.edit.backupSize", Mth.ceil((double)i / 1048576.0));
        Minecraft.getInstance().getToasts().addToast(new SystemToast(SystemToast.SystemToastIds.WORLD_BACKUP, component, component1));
        return true;
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        EditWorldScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 15, 0xFFFFFF);
        EditWorldScreen.drawString(pPoseStack, this.font, NAME_LABEL, this.width / 2 - 100, 24, 0xA0A0A0);
        this.nameEdit.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

