/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.WorldStem;
import net.minecraft.util.Mth;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.WorldData;
import org.slf4j.Logger;

public class OptimizeWorldScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Object2IntMap<ResourceKey<Level>> DIMENSION_COLORS = (Object2IntMap)Util.make(new Object2IntOpenCustomHashMap(Util.identityStrategy()), p_101324_ -> {
        p_101324_.put(Level.OVERWORLD, -13408734);
        p_101324_.put(Level.NETHER, -10075085);
        p_101324_.put(Level.END, -8943531);
        p_101324_.defaultReturnValue(-2236963);
    });
    private final BooleanConsumer callback;
    private final WorldUpgrader upgrader;

    @Nullable
    public static OptimizeWorldScreen create(Minecraft pMinecraft, BooleanConsumer pCallback, DataFixer pDataFixer, LevelStorageSource.LevelStorageAccess pLevelStorage, boolean pEraseCache) {
        try {
            OptimizeWorldScreen optimizeworldscreen;
            try (WorldStem worldstem = pMinecraft.makeWorldStem(pLevelStorage, false);){
                WorldData worlddata = worldstem.worldData();
                pLevelStorage.saveDataTag(worldstem.registryAccess(), worlddata);
                optimizeworldscreen = new OptimizeWorldScreen(pCallback, pDataFixer, pLevelStorage, worlddata.getLevelSettings(), pEraseCache, worlddata.worldGenSettings());
            }
            return optimizeworldscreen;
        }
        catch (Exception exception) {
            LOGGER.warn("Failed to load datapacks, can't optimize world", (Throwable)exception);
            return null;
        }
    }

    private OptimizeWorldScreen(BooleanConsumer p_194064_, DataFixer p_194065_, LevelStorageSource.LevelStorageAccess p_194066_, LevelSettings p_194067_, boolean p_194068_, WorldGenSettings p_194069_) {
        super(new TranslatableComponent("optimizeWorld.title", p_194067_.levelName()));
        this.callback = p_194064_;
        this.upgrader = new WorldUpgrader(p_194066_, p_194065_, p_194069_, p_194068_);
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget(new Button(this.width / 2 - 100, this.height / 4 + 150, 200, 20, CommonComponents.GUI_CANCEL, p_101322_ -> {
            this.upgrader.cancel();
            this.callback.accept(false);
        }));
    }

    @Override
    public void tick() {
        if (this.upgrader.isFinished()) {
            this.callback.accept(true);
        }
    }

    @Override
    public void onClose() {
        this.callback.accept(false);
    }

    @Override
    public void removed() {
        this.upgrader.cancel();
    }

    @Override
    public void render(PoseStack pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pPoseStack);
        OptimizeWorldScreen.drawCenteredString(pPoseStack, this.font, this.title, this.width / 2, 20, 0xFFFFFF);
        int i = this.width / 2 - 150;
        int j = this.width / 2 + 150;
        int k = this.height / 4 + 100;
        int l = k + 10;
        OptimizeWorldScreen.drawCenteredString(pPoseStack, this.font, this.upgrader.getStatus(), this.width / 2, k - 9 - 2, 0xA0A0A0);
        if (this.upgrader.getTotalChunks() > 0) {
            OptimizeWorldScreen.fill(pPoseStack, i - 1, k - 1, j + 1, l + 1, -16777216);
            OptimizeWorldScreen.drawString(pPoseStack, this.font, new TranslatableComponent("optimizeWorld.info.converted", this.upgrader.getConverted()), i, 40, 0xA0A0A0);
            OptimizeWorldScreen.drawString(pPoseStack, this.font, new TranslatableComponent("optimizeWorld.info.skipped", this.upgrader.getSkipped()), i, 52, 0xA0A0A0);
            OptimizeWorldScreen.drawString(pPoseStack, this.font, new TranslatableComponent("optimizeWorld.info.total", this.upgrader.getTotalChunks()), i, 64, 0xA0A0A0);
            int i1 = 0;
            for (ResourceKey resourcekey : this.upgrader.levels()) {
                int j1 = Mth.floor(this.upgrader.dimensionProgress(resourcekey) * (float)(j - i));
                OptimizeWorldScreen.fill(pPoseStack, i + i1, k, i + i1 + j1, l, DIMENSION_COLORS.getInt((Object)resourcekey));
                i1 += j1;
            }
            int k1 = this.upgrader.getConverted() + this.upgrader.getSkipped();
            OptimizeWorldScreen.drawCenteredString(pPoseStack, this.font, String.valueOf(k1) + " / " + this.upgrader.getTotalChunks(), this.width / 2, k + 18 + 2, 0xA0A0A0);
            OptimizeWorldScreen.drawCenteredString(pPoseStack, this.font, String.valueOf(Mth.floor(this.upgrader.getProgress() * 100.0f)) + "%", this.width / 2, k + (l - k) / 2 - 4, 0xA0A0A0);
        }
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
    }
}

