/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.BackupConfirmScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ErrorScreen;
import net.minecraft.client.gui.screens.GenericDirtMessageScreen;
import net.minecraft.client.gui.screens.ProgressScreen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.client.gui.screens.worldselection.EditWorldScreen;
import net.minecraft.client.gui.screens.worldselection.SelectWorldScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.WorldStem;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageException;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;

public class WorldSelectionList
extends ObjectSelectionList<WorldListEntry> {
    static final Logger LOGGER = LogUtils.getLogger();
    static final DateFormat DATE_FORMAT = new SimpleDateFormat();
    static final ResourceLocation ICON_MISSING = new ResourceLocation("textures/misc/unknown_server.png");
    static final ResourceLocation ICON_OVERLAY_LOCATION = new ResourceLocation("textures/gui/world_selection.png");
    static final Component FROM_NEWER_TOOLTIP_1 = new TranslatableComponent("selectWorld.tooltip.fromNewerVersion1").withStyle(ChatFormatting.RED);
    static final Component FROM_NEWER_TOOLTIP_2 = new TranslatableComponent("selectWorld.tooltip.fromNewerVersion2").withStyle(ChatFormatting.RED);
    static final Component SNAPSHOT_TOOLTIP_1 = new TranslatableComponent("selectWorld.tooltip.snapshot1").withStyle(ChatFormatting.GOLD);
    static final Component SNAPSHOT_TOOLTIP_2 = new TranslatableComponent("selectWorld.tooltip.snapshot2").withStyle(ChatFormatting.GOLD);
    static final Component WORLD_LOCKED_TOOLTIP = new TranslatableComponent("selectWorld.locked").withStyle(ChatFormatting.RED);
    static final Component WORLD_REQUIRES_CONVERSION = new TranslatableComponent("selectWorld.conversion.tooltip").withStyle(ChatFormatting.RED);
    private final SelectWorldScreen screen;
    @Nullable
    private List<LevelSummary> cachedList;

    public WorldSelectionList(SelectWorldScreen p_101658_, Minecraft p_101659_, int p_101660_, int p_101661_, int p_101662_, int p_101663_, int p_101664_, Supplier<String> p_101665_, @Nullable WorldSelectionList p_101666_) {
        super(p_101659_, p_101660_, p_101661_, p_101662_, p_101663_, p_101664_);
        this.screen = p_101658_;
        if (p_101666_ != null) {
            this.cachedList = p_101666_.cachedList;
        }
        this.refreshList(p_101665_, false);
    }

    public void refreshList(Supplier<String> p_101677_, boolean p_101678_) {
        this.clearEntries();
        LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
        if (this.cachedList == null || p_101678_) {
            try {
                this.cachedList = levelstoragesource.getLevelList();
            }
            catch (LevelStorageException levelstorageexception) {
                LOGGER.error("Couldn't load level list", (Throwable)levelstorageexception);
                this.minecraft.setScreen(new ErrorScreen(new TranslatableComponent("selectWorld.unable_to_load"), new TextComponent(levelstorageexception.getMessage())));
                return;
            }
            Collections.sort(this.cachedList);
        }
        if (this.cachedList.isEmpty()) {
            this.minecraft.setScreen(CreateWorldScreen.createFresh(null));
        } else {
            String s = p_101677_.get().toLowerCase(Locale.ROOT);
            for (LevelSummary levelsummary : this.cachedList) {
                if (!levelsummary.getLevelName().toLowerCase(Locale.ROOT).contains(s) && !levelsummary.getLevelId().toLowerCase(Locale.ROOT).contains(s)) continue;
                this.addEntry(new WorldListEntry(this, levelsummary));
            }
        }
    }

    @Override
    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    @Override
    public int getRowWidth() {
        return super.getRowWidth() + 50;
    }

    @Override
    protected boolean isFocused() {
        return this.screen.getFocused() == this;
    }

    @Override
    public void setSelected(@Nullable WorldListEntry pEntry) {
        super.setSelected(pEntry);
        this.screen.updateButtonStatus(pEntry != null && !pEntry.summary.isDisabled());
    }

    @Override
    protected void moveSelection(AbstractSelectionList.SelectionDirection pOrdering) {
        this.moveSelection(pOrdering, p_101681_ -> !p_101681_.summary.isDisabled());
    }

    public Optional<WorldListEntry> getSelectedOpt() {
        return Optional.ofNullable((WorldListEntry)this.getSelected());
    }

    public SelectWorldScreen getScreen() {
        return this.screen;
    }

    public final class WorldListEntry
    extends ObjectSelectionList.Entry<WorldListEntry>
    implements AutoCloseable {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int ICON_OVERLAY_X_JOIN = 0;
        private static final int ICON_OVERLAY_X_JOIN_WITH_NOTIFY = 32;
        private static final int ICON_OVERLAY_X_WARNING = 64;
        private static final int ICON_OVERLAY_X_ERROR = 96;
        private static final int ICON_OVERLAY_Y_UNSELECTED = 0;
        private static final int ICON_OVERLAY_Y_SELECTED = 32;
        private final Minecraft minecraft;
        private final SelectWorldScreen screen;
        final LevelSummary summary;
        private final ResourceLocation iconLocation;
        @Nullable
        private File iconFile;
        @Nullable
        private final DynamicTexture icon;
        private long lastClickTime;

        public WorldListEntry(WorldSelectionList p_101702_, LevelSummary p_101703_) {
            this.screen = p_101702_.getScreen();
            this.summary = p_101703_;
            this.minecraft = Minecraft.getInstance();
            String s = p_101703_.getLevelId();
            this.iconLocation = new ResourceLocation("minecraft", "worlds/" + Util.sanitizeName(s, ResourceLocation::validPathChar) + "/" + Hashing.sha1().hashUnencodedChars((CharSequence)s) + "/icon");
            this.iconFile = p_101703_.getIcon();
            if (!this.iconFile.isFile()) {
                this.iconFile = null;
            }
            this.icon = this.loadServerIcon();
        }

        @Override
        public Component getNarration() {
            TranslatableComponent translatablecomponent = new TranslatableComponent("narrator.select.world", this.summary.getLevelName(), new Date(this.summary.getLastPlayed()), this.summary.isHardcore() ? new TranslatableComponent("gameMode.hardcore") : new TranslatableComponent("gameMode." + this.summary.getGameMode().getName()), this.summary.hasCheats() ? new TranslatableComponent("selectWorld.cheats") : TextComponent.EMPTY, this.summary.getWorldVersionName());
            MutableComponent component = this.summary.isLocked() ? CommonComponents.joinForNarration(translatablecomponent, WORLD_LOCKED_TOOLTIP) : translatablecomponent;
            return new TranslatableComponent("narrator.select", component);
        }

        @Override
        public void render(PoseStack pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            String s = this.summary.getLevelName();
            String s1 = String.valueOf(this.summary.getLevelId()) + " (" + DATE_FORMAT.format(new Date(this.summary.getLastPlayed())) + ")";
            if (StringUtils.isEmpty((CharSequence)s)) {
                s = String.valueOf(I18n.a("selectWorld.world", new Object[0])) + " " + (pIndex + 1);
            }
            Component component = this.summary.getInfo();
            this.minecraft.font.draw(pPoseStack, s, (float)(pLeft + 32 + 3), (float)(pTop + 1), 0xFFFFFF);
            this.minecraft.font.draw(pPoseStack, s1, (float)(pLeft + 32 + 3), (float)(pTop + 9 + 3), 0x808080);
            this.minecraft.font.draw(pPoseStack, component, (float)(pLeft + 32 + 3), (float)(pTop + 9 + 9 + 3), 0x808080);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            RenderSystem.setShaderTexture(0, this.icon != null ? this.iconLocation : ICON_MISSING);
            RenderSystem.enableBlend();
            GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, 0.0f, 32, 32, 32, 32);
            RenderSystem.disableBlend();
            if (this.minecraft.options.touchscreen || pIsMouseOver) {
                int j;
                RenderSystem.setShaderTexture(0, ICON_OVERLAY_LOCATION);
                GuiComponent.fill(pPoseStack, pLeft, pTop, pLeft + 32, pTop + 32, -1601138544);
                RenderSystem.setShader(GameRenderer::getPositionTexShader);
                RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
                int i = pMouseX - pLeft;
                boolean flag = i < 32;
                int n = j = flag ? 32 : 0;
                if (this.summary.isLocked()) {
                    GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, j, 32, 32, 256, 256);
                    if (flag) {
                        this.screen.setToolTip(this.minecraft.font.split(WORLD_LOCKED_TOOLTIP, 175));
                    }
                } else if (this.summary.requiresManualConversion()) {
                    GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, j, 32, 32, 256, 256);
                    if (flag) {
                        this.screen.setToolTip(this.minecraft.font.split(WORLD_REQUIRES_CONVERSION, 175));
                    }
                } else if (this.summary.markVersionInList()) {
                    GuiComponent.blit(pPoseStack, pLeft, pTop, 32.0f, j, 32, 32, 256, 256);
                    if (this.summary.askToOpenWorld()) {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 96.0f, j, 32, 32, 256, 256);
                        if (flag) {
                            this.screen.setToolTip((List<FormattedCharSequence>)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.getVisualOrderText(), (Object)FROM_NEWER_TOOLTIP_2.getVisualOrderText()));
                        }
                    } else if (!SharedConstants.getCurrentVersion().isStable()) {
                        GuiComponent.blit(pPoseStack, pLeft, pTop, 64.0f, j, 32, 32, 256, 256);
                        if (flag) {
                            this.screen.setToolTip((List<FormattedCharSequence>)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.getVisualOrderText(), (Object)SNAPSHOT_TOOLTIP_2.getVisualOrderText()));
                        }
                    }
                } else {
                    GuiComponent.blit(pPoseStack, pLeft, pTop, 0.0f, j, 32, 32, 256, 256);
                }
            }
        }

        @Override
        public boolean mouseClicked(double pMouseX, double p_101707_, int pMouseY) {
            if (this.summary.isDisabled()) {
                return true;
            }
            WorldSelectionList.this.setSelected(this);
            this.screen.updateButtonStatus(WorldSelectionList.this.getSelectedOpt().isPresent());
            if (pMouseX - (double)WorldSelectionList.this.getRowLeft() <= 32.0) {
                this.joinWorld();
                return true;
            }
            if (Util.getMillis() - this.lastClickTime < 250L) {
                this.joinWorld();
                return true;
            }
            this.lastClickTime = Util.getMillis();
            return false;
        }

        public void joinWorld() {
            if (!this.summary.isDisabled()) {
                LevelSummary.BackupStatus levelsummary$backupstatus = this.summary.backupStatus();
                if (levelsummary$backupstatus.shouldBackup()) {
                    String s = "selectWorld.backupQuestion." + levelsummary$backupstatus.getTranslationKey();
                    String s1 = "selectWorld.backupWarning." + levelsummary$backupstatus.getTranslationKey();
                    TranslatableComponent mutablecomponent = new TranslatableComponent(s);
                    if (levelsummary$backupstatus.isSevere()) {
                        mutablecomponent.a(ChatFormatting.BOLD, ChatFormatting.RED);
                    }
                    TranslatableComponent component = new TranslatableComponent(s1, this.summary.getWorldVersionName(), SharedConstants.getCurrentVersion().getName());
                    this.minecraft.setScreen(new BackupConfirmScreen(this.screen, (p_101736_, p_101737_) -> {
                        if (p_101736_) {
                            String s2 = this.summary.getLevelId();
                            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().createAccess(s2);){
                                EditWorldScreen.makeBackupAndShowToast(levelstoragesource$levelstorageaccess);
                            }
                            catch (IOException ioexception) {
                                SystemToast.onWorldAccessFailure(this.minecraft, s2);
                                LOGGER.error("Failed to backup level {}", (Object)s2, (Object)ioexception);
                            }
                        }
                        this.loadWorld();
                    }, mutablecomponent, component, false));
                } else if (this.summary.askToOpenWorld()) {
                    this.minecraft.setScreen(new ConfirmScreen(p_101741_ -> {
                        if (p_101741_) {
                            try {
                                this.loadWorld();
                            }
                            catch (Exception exception) {
                                LOGGER.error("Failure to open 'future world'", (Throwable)exception);
                                this.minecraft.setScreen(new AlertScreen(() -> this.minecraft.setScreen(this.screen), new TranslatableComponent("selectWorld.futureworld.error.title"), new TranslatableComponent("selectWorld.futureworld.error.text")));
                            }
                        } else {
                            this.minecraft.setScreen(this.screen);
                        }
                    }, new TranslatableComponent("selectWorld.versionQuestion"), new TranslatableComponent("selectWorld.versionWarning", this.summary.getWorldVersionName()), new TranslatableComponent("selectWorld.versionJoinButton"), CommonComponents.GUI_CANCEL));
                } else {
                    this.loadWorld();
                }
            }
        }

        public void deleteWorld() {
            this.minecraft.setScreen(new ConfirmScreen(p_170322_ -> {
                if (p_170322_) {
                    this.minecraft.setScreen(new ProgressScreen(true));
                    this.doDeleteWorld();
                }
                this.minecraft.setScreen(this.screen);
            }, new TranslatableComponent("selectWorld.deleteQuestion"), new TranslatableComponent("selectWorld.deleteWarning", this.summary.getLevelName()), new TranslatableComponent("selectWorld.deleteButton"), CommonComponents.GUI_CANCEL));
        }

        public void doDeleteWorld() {
            LevelStorageSource levelstoragesource = this.minecraft.getLevelSource();
            String s = this.summary.getLevelId();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = levelstoragesource.createAccess(s);){
                levelstoragesource$levelstorageaccess.deleteLevel();
            }
            catch (IOException ioexception) {
                SystemToast.onWorldDeleteFailure(this.minecraft, s);
                LOGGER.error("Failed to delete world {}", (Object)s, (Object)ioexception);
            }
            WorldSelectionList.this.refreshList(() -> this.screen.searchBox.getValue(), true);
        }

        public void editWorld() {
            String s = this.summary.getLevelId();
            try {
                LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().createAccess(s);
                this.minecraft.setScreen(new EditWorldScreen(p_101719_ -> {
                    try {
                        levelstoragesource$levelstorageaccess.close();
                    }
                    catch (IOException ioexception1) {
                        LOGGER.error("Failed to unlock level {}", (Object)s, (Object)ioexception1);
                    }
                    if (p_101719_) {
                        WorldSelectionList.this.refreshList(() -> this.screen.searchBox.getValue(), true);
                    }
                    this.minecraft.setScreen(this.screen);
                }, levelstoragesource$levelstorageaccess));
            }
            catch (IOException ioexception) {
                SystemToast.onWorldAccessFailure(this.minecraft, s);
                LOGGER.error("Failed to access level {}", (Object)s, (Object)ioexception);
                WorldSelectionList.this.refreshList(() -> this.screen.searchBox.getValue(), true);
            }
        }

        public void recreateWorld() {
            this.queueLoadScreen();
            try (LevelStorageSource.LevelStorageAccess levelstoragesource$levelstorageaccess = this.minecraft.getLevelSource().createAccess(this.summary.getLevelId());
                 WorldStem worldstem = this.minecraft.makeWorldStem(levelstoragesource$levelstorageaccess, false);){
                WorldGenSettings worldgensettings = worldstem.worldData().worldGenSettings();
                Path path = CreateWorldScreen.createTempDataPackDirFromExistingWorld(levelstoragesource$levelstorageaccess.getLevelPath(LevelResource.DATAPACK_DIR), this.minecraft);
                if (worldgensettings.isOldCustomizedWorld()) {
                    this.minecraft.setScreen(new ConfirmScreen(p_205503_ -> this.minecraft.setScreen(p_205503_ ? CreateWorldScreen.createFromExisting(this.screen, worldstem, path) : this.screen), new TranslatableComponent("selectWorld.recreate.customized.title"), new TranslatableComponent("selectWorld.recreate.customized.text"), CommonComponents.GUI_PROCEED, CommonComponents.GUI_CANCEL));
                } else {
                    this.minecraft.setScreen(CreateWorldScreen.createFromExisting(this.screen, worldstem, path));
                }
            }
            catch (Exception exception) {
                LOGGER.error("Unable to recreate world", (Throwable)exception);
                this.minecraft.setScreen(new AlertScreen(() -> this.minecraft.setScreen(this.screen), new TranslatableComponent("selectWorld.recreate.error.title"), new TranslatableComponent("selectWorld.recreate.error.text")));
            }
        }

        private void loadWorld() {
            this.minecraft.getSoundManager().play(SimpleSoundInstance.forUI(SoundEvents.UI_BUTTON_CLICK, 1.0f));
            if (this.minecraft.getLevelSource().levelExists(this.summary.getLevelId())) {
                this.queueLoadScreen();
                this.minecraft.loadLevel(this.summary.getLevelId());
            }
        }

        private void queueLoadScreen() {
            this.minecraft.forceSetScreen(new GenericDirtMessageScreen(new TranslatableComponent("selectWorld.data_read")));
        }

        @Nullable
        private DynamicTexture loadServerIcon() {
            boolean flag;
            boolean bl = flag = this.iconFile != null && this.iconFile.isFile();
            if (flag) {
                try {
                    DynamicTexture dynamictexture1;
                    try (FileInputStream inputstream = new FileInputStream(this.iconFile);){
                        NativeImage nativeimage = NativeImage.read(inputstream);
                        Validate.validState((nativeimage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                        Validate.validState((nativeimage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                        DynamicTexture dynamictexture = new DynamicTexture(nativeimage);
                        this.minecraft.getTextureManager().register(this.iconLocation, (AbstractTexture)dynamictexture);
                        dynamictexture1 = dynamictexture;
                    }
                    return dynamictexture1;
                }
                catch (Throwable throwable2) {
                    LOGGER.error("Invalid icon for world {}", (Object)this.summary.getLevelId(), (Object)throwable2);
                    this.iconFile = null;
                    return null;
                }
            }
            this.minecraft.getTextureManager().release(this.iconLocation);
            return null;
        }

        @Override
        public void close() {
            if (this.icon != null) {
                this.icon.close();
            }
        }

        public String getLevelName() {
            return this.summary.getLevelName();
        }
    }
}

