/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.main;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.blaze3d.platform.DisplayData;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.client.main.GameConfig;
import net.minecraft.client.main.SilentInitException;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class Main {
    static final Logger LOGGER = LogUtils.getLogger();

    static {
        System.setProperty("java.awt.headless", "true");
    }

    @DontObfuscate
    public static void main(String[] pArgs) {
        Thread thread1;
        Minecraft minecraft;
        SharedConstants.tryDetectVersion();
        OptionParser optionparser = new OptionParser();
        optionparser.allowsUnrecognizedOptions();
        optionparser.accepts("demo");
        optionparser.accepts("disableMultiplayer");
        optionparser.accepts("disableChat");
        optionparser.accepts("fullscreen");
        optionparser.accepts("checkGlErrors");
        OptionSpecBuilder optionspec = optionparser.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec optionspec1 = optionparser.accepts("server").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec2 = optionparser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)25565, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec3 = optionparser.accepts("gameDir").withRequiredArg().ofType(File.class).defaultsTo((Object)new File("."), (Object[])new File[0]);
        ArgumentAcceptingOptionSpec optionspec4 = optionparser.accepts("assetsDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec5 = optionparser.accepts("resourcePackDir").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec optionspec6 = optionparser.accepts("proxyHost").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec7 = optionparser.accepts("proxyPort").withRequiredArg().defaultsTo((Object)"8080", (Object[])new String[0]).ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec8 = optionparser.accepts("proxyUser").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec9 = optionparser.accepts("proxyPass").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec10 = optionparser.accepts("username").withRequiredArg().defaultsTo((Object)("Player" + Util.getMillis() % 1000L), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec11 = optionparser.accepts("uuid").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec12 = optionparser.accepts("xuid").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec13 = optionparser.accepts("clientId").withOptionalArg().defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec14 = optionparser.accepts("accessToken").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec15 = optionparser.accepts("version").withRequiredArg().required();
        ArgumentAcceptingOptionSpec optionspec16 = optionparser.accepts("width").withRequiredArg().ofType(Integer.class).defaultsTo((Object)854, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec17 = optionparser.accepts("height").withRequiredArg().ofType(Integer.class).defaultsTo((Object)480, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optionspec18 = optionparser.accepts("fullscreenWidth").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec19 = optionparser.accepts("fullscreenHeight").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionspec20 = optionparser.accepts("userProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec21 = optionparser.accepts("profileProperties").withRequiredArg().defaultsTo((Object)"{}", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec22 = optionparser.accepts("assetIndex").withRequiredArg();
        ArgumentAcceptingOptionSpec optionspec23 = optionparser.accepts("userType").withRequiredArg().defaultsTo((Object)User.Type.LEGACY.getName(), (Object[])new String[0]);
        ArgumentAcceptingOptionSpec optionspec24 = optionparser.accepts("versionType").withRequiredArg().defaultsTo((Object)"release", (Object[])new String[0]);
        NonOptionArgumentSpec optionspec25 = optionparser.nonOptions();
        OptionSet optionset = optionparser.parse(pArgs);
        List list = optionset.valuesOf((OptionSpec)optionspec25);
        if (!list.isEmpty()) {
            System.out.println("Completely ignored arguments: " + list);
        }
        String s = (String)Main.parseArgument(optionset, optionspec6);
        Proxy proxy = Proxy.NO_PROXY;
        if (s != null) {
            try {
                proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(s, (int)((Integer)Main.parseArgument(optionset, optionspec7))));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String s1 = (String)Main.parseArgument(optionset, optionspec8);
        String s2 = (String)Main.parseArgument(optionset, optionspec9);
        if (!proxy.equals(Proxy.NO_PROXY) && Main.stringHasValue(s1) && Main.stringHasValue(s2)) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(s1, s2.toCharArray());
                }
            });
        }
        int i = (Integer)Main.parseArgument(optionset, optionspec16);
        int j = (Integer)Main.parseArgument(optionset, optionspec17);
        OptionalInt optionalint = Main.ofNullable((Integer)Main.parseArgument(optionset, optionspec18));
        OptionalInt optionalint1 = Main.ofNullable((Integer)Main.parseArgument(optionset, optionspec19));
        boolean flag = optionset.has("fullscreen");
        boolean flag1 = optionset.has("demo");
        boolean flag2 = optionset.has("disableMultiplayer");
        boolean flag3 = optionset.has("disableChat");
        String s3 = (String)Main.parseArgument(optionset, optionspec15);
        Gson gson = new GsonBuilder().registerTypeAdapter(PropertyMap.class, (Object)new PropertyMap.Serializer()).create();
        PropertyMap propertymap = GsonHelper.fromJson(gson, (String)Main.parseArgument(optionset, optionspec20), PropertyMap.class);
        PropertyMap propertymap1 = GsonHelper.fromJson(gson, (String)Main.parseArgument(optionset, optionspec21), PropertyMap.class);
        String s4 = (String)Main.parseArgument(optionset, optionspec24);
        File file1 = (File)Main.parseArgument(optionset, optionspec3);
        File file2 = optionset.has((OptionSpec)optionspec4) ? (File)Main.parseArgument(optionset, optionspec4) : new File(file1, "assets/");
        File file3 = optionset.has((OptionSpec)optionspec5) ? (File)Main.parseArgument(optionset, optionspec5) : new File(file1, "resourcepacks/");
        String s5 = optionset.has((OptionSpec)optionspec11) ? (String)optionspec11.value(optionset) : Player.createPlayerUUID((String)optionspec10.value(optionset)).toString();
        String s6 = optionset.has((OptionSpec)optionspec22) ? (String)optionspec22.value(optionset) : null;
        String s7 = (String)optionset.valueOf((OptionSpec)optionspec12);
        String s8 = (String)optionset.valueOf((OptionSpec)optionspec13);
        String s9 = (String)Main.parseArgument(optionset, optionspec1);
        Integer integer = (Integer)Main.parseArgument(optionset, optionspec2);
        if (optionset.has((OptionSpec)optionspec)) {
            JvmProfiler.INSTANCE.start(Environment.CLIENT);
        }
        CrashReport.preload();
        Bootstrap.bootStrap();
        Bootstrap.validate();
        Util.startTimerHackThread();
        String s10 = (String)optionspec23.value(optionset);
        User.Type user$type = User.Type.byName(s10);
        if (user$type == null) {
            LOGGER.warn("Unrecognized user type: {}", (Object)s10);
        }
        User user = new User((String)optionspec10.value(optionset), s5, (String)optionspec14.value(optionset), Main.emptyStringToEmptyOptional(s7), Main.emptyStringToEmptyOptional(s8), user$type);
        GameConfig gameconfig = new GameConfig(new GameConfig.UserData(user, propertymap, propertymap1, proxy), new DisplayData(i, j, optionalint, optionalint1, flag), new GameConfig.FolderData(file1, file3, file2, s6), new GameConfig.GameData(flag1, s3, s4, flag2, flag3), new GameConfig.ServerData(s9, integer));
        Thread thread = new Thread("Client Shutdown Thread"){

            @Override
            public void run() {
                IntegratedServer integratedserver;
                Minecraft minecraft1 = Minecraft.getInstance();
                if (minecraft1 != null && (integratedserver = minecraft1.getSingleplayerServer()) != null) {
                    integratedserver.halt(true);
                }
            }
        };
        thread.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
        Runtime.getRuntime().addShutdownHook(thread);
        try {
            Thread.currentThread().setName("Render thread");
            RenderSystem.initRenderThread();
            RenderSystem.beginInitialization();
            minecraft = new Minecraft(gameconfig);
            RenderSystem.finishInitialization();
        }
        catch (SilentInitException silentinitexception) {
            LOGGER.warn("Failed to create window: ", (Throwable)silentinitexception);
            return;
        }
        catch (Throwable throwable1) {
            CrashReport crashreport = CrashReport.forThrowable(throwable1, "Initializing game");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Initialization");
            NativeModuleLister.addCrashSection(crashreportcategory);
            Minecraft.fillReport(null, null, gameconfig.game.launchVersion, null, crashreport);
            Minecraft.crash(crashreport);
            return;
        }
        if (minecraft.renderOnThread()) {
            thread1 = new Thread("Game thread"){

                @Override
                public void run() {
                    try {
                        RenderSystem.initGameThread(true);
                        minecraft.run();
                    }
                    catch (Throwable throwable2) {
                        LOGGER.error("Exception in client thread", throwable2);
                    }
                }
            };
            thread1.start();
            while (minecraft.isRunning()) {
            }
        } else {
            thread1 = null;
            try {
                RenderSystem.initGameThread(false);
                minecraft.run();
            }
            catch (Throwable throwable) {
                LOGGER.error("Unhandled game exception", throwable);
            }
        }
        BufferUploader.reset();
        try {
            try {
                minecraft.stop();
                if (thread1 != null) {
                    thread1.join();
                }
            }
            catch (InterruptedException interruptedexception) {
                LOGGER.error("Exception during client thread shutdown", (Throwable)interruptedexception);
                minecraft.destroy();
            }
        }
        finally {
            minecraft.destroy();
        }
    }

    private static Optional<String> emptyStringToEmptyOptional(String p_195487_) {
        return p_195487_.isEmpty() ? Optional.empty() : Optional.of(p_195487_);
    }

    private static OptionalInt ofNullable(@Nullable Integer pValue) {
        return pValue != null ? OptionalInt.of(pValue) : OptionalInt.empty();
    }

    @Nullable
    private static <T> T parseArgument(OptionSet pSet, OptionSpec<T> pOption) {
        try {
            return (T)pSet.valueOf(pOption);
        }
        catch (Throwable throwable) {
            ArgumentAcceptingOptionSpec argumentacceptingoptionspec;
            List list;
            if (pOption instanceof ArgumentAcceptingOptionSpec && !(list = (argumentacceptingoptionspec = (ArgumentAcceptingOptionSpec)pOption).defaultValues()).isEmpty()) {
                return (T)list.get(0);
            }
            throw throwable;
        }
    }

    private static boolean stringHasValue(@Nullable String pStr) {
        return pStr != null && !pStr.isEmpty();
    }
}

