/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;

public class AnimationUtils {
    public static void animateCrossbowHold(ModelPart pRightArm, ModelPart pLeftArm, ModelPart pHead, boolean pRightHanded) {
        ModelPart modelpart = pRightHanded ? pRightArm : pLeftArm;
        ModelPart modelpart1 = pRightHanded ? pLeftArm : pRightArm;
        modelpart.yRot = (pRightHanded ? -0.3f : 0.3f) + pHead.yRot;
        modelpart1.yRot = (pRightHanded ? 0.6f : -0.6f) + pHead.yRot;
        modelpart.xRot = -1.5707964f + pHead.xRot + 0.1f;
        modelpart1.xRot = -1.5f + pHead.xRot;
    }

    public static void animateCrossbowCharge(ModelPart pRightArm, ModelPart pLeftArm, LivingEntity pLivingEntity, boolean pRightHanded) {
        ModelPart modelpart = pRightHanded ? pRightArm : pLeftArm;
        ModelPart modelpart1 = pRightHanded ? pLeftArm : pRightArm;
        modelpart.yRot = pRightHanded ? -0.8f : 0.8f;
        modelpart1.xRot = modelpart.xRot = -0.97079635f;
        float f = CrossbowItem.getChargeDuration(pLivingEntity.getUseItem());
        float f1 = Mth.clamp((float)pLivingEntity.getTicksUsingItem(), 0.0f, f);
        float f2 = f1 / f;
        modelpart1.yRot = Mth.lerp(f2, 0.4f, 0.85f) * (float)(pRightHanded ? 1 : -1);
        modelpart1.xRot = Mth.lerp(f2, modelpart1.xRot, -1.5707964f);
    }

    public static <T extends Mob> void swingWeaponDown(ModelPart pRightArm, ModelPart pLeftArm, T pMob, float pAttackTime, float pAgeInTicks) {
        float f = Mth.sin(pAttackTime * (float)Math.PI);
        float f1 = Mth.sin((1.0f - (1.0f - pAttackTime) * (1.0f - pAttackTime)) * (float)Math.PI);
        pRightArm.zRot = 0.0f;
        pLeftArm.zRot = 0.0f;
        pRightArm.yRot = 0.15707964f;
        pLeftArm.yRot = -0.15707964f;
        if (pMob.getMainArm() == HumanoidArm.RIGHT) {
            pRightArm.xRot = -1.8849558f + Mth.cos(pAgeInTicks * 0.09f) * 0.15f;
            pLeftArm.xRot = -0.0f + Mth.cos(pAgeInTicks * 0.19f) * 0.5f;
            pRightArm.xRot += f * 2.2f - f1 * 0.4f;
            pLeftArm.xRot += f * 1.2f - f1 * 0.4f;
        } else {
            pRightArm.xRot = -0.0f + Mth.cos(pAgeInTicks * 0.19f) * 0.5f;
            pLeftArm.xRot = -1.8849558f + Mth.cos(pAgeInTicks * 0.09f) * 0.15f;
            pRightArm.xRot += f * 1.2f - f1 * 0.4f;
            pLeftArm.xRot += f * 2.2f - f1 * 0.4f;
        }
        AnimationUtils.bobArms(pRightArm, pLeftArm, pAgeInTicks);
    }

    public static void bobModelPart(ModelPart pModelPart, float pAgeInTicks, float pMultiplier) {
        pModelPart.zRot += pMultiplier * (Mth.cos(pAgeInTicks * 0.09f) * 0.05f + 0.05f);
        pModelPart.xRot += pMultiplier * Mth.sin(pAgeInTicks * 0.067f) * 0.05f;
    }

    public static void bobArms(ModelPart pRightArm, ModelPart pLeftArm, float pAgeInTicks) {
        AnimationUtils.bobModelPart(pRightArm, pAgeInTicks, 1.0f);
        AnimationUtils.bobModelPart(pLeftArm, pAgeInTicks, -1.0f);
    }

    public static void animateZombieArms(ModelPart pLeftArm, ModelPart pRightArm, boolean pIsAggressive, float pAttackTime, float pAgeInTicks) {
        float f2;
        float f = Mth.sin(pAttackTime * (float)Math.PI);
        float f1 = Mth.sin((1.0f - (1.0f - pAttackTime) * (1.0f - pAttackTime)) * (float)Math.PI);
        pRightArm.zRot = 0.0f;
        pLeftArm.zRot = 0.0f;
        pRightArm.yRot = -(0.1f - f * 0.6f);
        pLeftArm.yRot = 0.1f - f * 0.6f;
        pRightArm.xRot = f2 = (float)(-Math.PI) / (pIsAggressive ? 1.5f : 2.25f);
        pLeftArm.xRot = f2;
        pRightArm.xRot += f * 1.2f - f1 * 0.4f;
        pLeftArm.xRot += f * 1.2f - f1 * 0.4f;
        AnimationUtils.bobArms(pRightArm, pLeftArm, pAgeInTicks);
    }
}

