/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorStandArmorModel
extends HumanoidModel<ArmorStand> {
    public ArmorStandArmorModel(ModelPart p_170346_) {
        super(p_170346_);
    }

    public static LayerDefinition createBodyLayer(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = HumanoidModel.createMesh(pCubeDeformation, 0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation), PartPose.offset(0.0f, 1.0f, 0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, pCubeDeformation.extend(0.5f)), PartPose.offset(0.0f, 1.0f, 0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.offset(-1.9f, 11.0f, 0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, pCubeDeformation), PartPose.offset(1.9f, 11.0f, 0.0f));
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(ArmorStand pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = (float)Math.PI / 180 * pEntity.getHeadPose().getX();
        this.head.yRot = (float)Math.PI / 180 * pEntity.getHeadPose().getY();
        this.head.zRot = (float)Math.PI / 180 * pEntity.getHeadPose().getZ();
        this.body.xRot = (float)Math.PI / 180 * pEntity.getBodyPose().getX();
        this.body.yRot = (float)Math.PI / 180 * pEntity.getBodyPose().getY();
        this.body.zRot = (float)Math.PI / 180 * pEntity.getBodyPose().getZ();
        this.leftArm.xRot = (float)Math.PI / 180 * pEntity.getLeftArmPose().getX();
        this.leftArm.yRot = (float)Math.PI / 180 * pEntity.getLeftArmPose().getY();
        this.leftArm.zRot = (float)Math.PI / 180 * pEntity.getLeftArmPose().getZ();
        this.rightArm.xRot = (float)Math.PI / 180 * pEntity.getRightArmPose().getX();
        this.rightArm.yRot = (float)Math.PI / 180 * pEntity.getRightArmPose().getY();
        this.rightArm.zRot = (float)Math.PI / 180 * pEntity.getRightArmPose().getZ();
        this.leftLeg.xRot = (float)Math.PI / 180 * pEntity.getLeftLegPose().getX();
        this.leftLeg.yRot = (float)Math.PI / 180 * pEntity.getLeftLegPose().getY();
        this.leftLeg.zRot = (float)Math.PI / 180 * pEntity.getLeftLegPose().getZ();
        this.rightLeg.xRot = (float)Math.PI / 180 * pEntity.getRightLegPose().getX();
        this.rightLeg.yRot = (float)Math.PI / 180 * pEntity.getRightLegPose().getY();
        this.rightLeg.zRot = (float)Math.PI / 180 * pEntity.getRightLegPose().getZ();
        this.hat.copyFrom(this.head);
    }
}

