/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3f;
import java.util.Map;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;

public class AxolotlModel<T extends Axolotl>
extends AgeableListModel<T> {
    public static final float SWIMMING_LEG_XROT = 1.8849558f;
    private final ModelPart tail;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart topGills;
    private final ModelPart leftGills;
    private final ModelPart rightGills;

    public AxolotlModel(ModelPart pRoot) {
        super(true, 8.0f, 3.35f);
        this.body = pRoot.getChilds("body");
        this.head = this.body.getChilds("head");
        this.rightHindLeg = this.body.getChilds("right_hind_leg");
        this.leftHindLeg = this.body.getChilds("left_hind_leg");
        this.rightFrontLeg = this.body.getChilds("right_front_leg");
        this.leftFrontLeg = this.body.getChilds("left_front_leg");
        this.tail = this.body.getChilds("tail");
        this.topGills = this.head.getChilds("top_gills");
        this.leftGills = this.head.getChilds("left_gills");
        this.rightGills = this.head.getChilds("right_gills");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 11).addBox(-4.0f, -2.0f, -9.0f, 8.0f, 4.0f, 10.0f).texOffs(2, 17).addBox(0.0f, -3.0f, -8.0f, 0.0f, 5.0f, 9.0f), PartPose.offset(0.0f, 20.0f, 5.0f));
        CubeDeformation cubedeformation = new CubeDeformation(0.001f);
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 1).addBox(-4.0f, -3.0f, -5.0f, 8.0f, 5.0f, 5.0f, cubedeformation), PartPose.offset(0.0f, 0.0f, -9.0f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(3, 37).addBox(-4.0f, -3.0f, 0.0f, 8.0f, 3.0f, 0.0f, cubedeformation);
        CubeListBuilder cubelistbuilder1 = CubeListBuilder.create().texOffs(0, 40).addBox(-3.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, cubedeformation);
        CubeListBuilder cubelistbuilder2 = CubeListBuilder.create().texOffs(11, 40).addBox(0.0f, -5.0f, 0.0f, 3.0f, 7.0f, 0.0f, cubedeformation);
        partdefinition2.addOrReplaceChild("top_gills", cubelistbuilder, PartPose.offset(0.0f, -3.0f, -1.0f));
        partdefinition2.addOrReplaceChild("left_gills", cubelistbuilder1, PartPose.offset(-4.0f, 0.0f, -1.0f));
        partdefinition2.addOrReplaceChild("right_gills", cubelistbuilder2, PartPose.offset(4.0f, 0.0f, -1.0f));
        CubeListBuilder cubelistbuilder3 = CubeListBuilder.create().texOffs(2, 13).addBox(-1.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, cubedeformation);
        CubeListBuilder cubelistbuilder4 = CubeListBuilder.create().texOffs(2, 13).addBox(-2.0f, 0.0f, 0.0f, 3.0f, 5.0f, 0.0f, cubedeformation);
        partdefinition1.addOrReplaceChild("right_hind_leg", cubelistbuilder4, PartPose.offset(-3.5f, 1.0f, -1.0f));
        partdefinition1.addOrReplaceChild("left_hind_leg", cubelistbuilder3, PartPose.offset(3.5f, 1.0f, -1.0f));
        partdefinition1.addOrReplaceChild("right_front_leg", cubelistbuilder4, PartPose.offset(-3.5f, 1.0f, -8.0f));
        partdefinition1.addOrReplaceChild("left_front_leg", cubelistbuilder3, PartPose.offset(3.5f, 1.0f, -8.0f));
        partdefinition1.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(2, 19).addBox(0.0f, -3.0f, 0.0f, 0.0f, 5.0f, 12.0f), PartPose.offset(0.0f, 0.0f, 1.0f));
        return LayerDefinition.create(meshdefinition, 64, 64);
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of();
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body);
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.setupInitialAnimationValues(pEntity, pNetHeadYaw, pHeadPitch);
        if (((Axolotl)pEntity).isPlayingDead()) {
            this.setupPlayDeadAnimation(pNetHeadYaw);
            this.saveAnimationValues(pEntity);
        } else {
            boolean flag;
            boolean bl = flag = ((Entity)pEntity).getDeltaMovement().horizontalDistanceSqr() > 1.0E-7 || ((Entity)pEntity).getXRot() != ((Axolotl)pEntity).xRotO || ((Entity)pEntity).getYRot() != ((Axolotl)pEntity).yRotO || ((Axolotl)pEntity).xOld != ((Entity)pEntity).getX() || ((Axolotl)pEntity).zOld != ((Entity)pEntity).getZ();
            if (((Entity)pEntity).isInWaterOrBubble()) {
                if (flag) {
                    this.setupSwimmingAnimation(pAgeInTicks, pHeadPitch);
                } else {
                    this.setupWaterHoveringAnimation(pAgeInTicks);
                }
                this.saveAnimationValues(pEntity);
            } else {
                if (((Entity)pEntity).isOnGround()) {
                    if (flag) {
                        this.setupGroundCrawlingAnimation(pAgeInTicks, pNetHeadYaw);
                    } else {
                        this.setupLayStillOnGroundAnimation(pAgeInTicks, pNetHeadYaw);
                    }
                }
                this.saveAnimationValues(pEntity);
            }
        }
    }

    private void saveAnimationValues(T pAxolotl) {
        Map<String, Vector3f> map = ((Axolotl)pAxolotl).getModelRotationValues();
        map.put("body", this.getRotationVector(this.body));
        map.put("head", this.getRotationVector(this.head));
        map.put("right_hind_leg", this.getRotationVector(this.rightHindLeg));
        map.put("left_hind_leg", this.getRotationVector(this.leftHindLeg));
        map.put("right_front_leg", this.getRotationVector(this.rightFrontLeg));
        map.put("left_front_leg", this.getRotationVector(this.leftFrontLeg));
        map.put("tail", this.getRotationVector(this.tail));
        map.put("top_gills", this.getRotationVector(this.topGills));
        map.put("left_gills", this.getRotationVector(this.leftGills));
        map.put("right_gills", this.getRotationVector(this.rightGills));
    }

    private Vector3f getRotationVector(ModelPart pModelPart) {
        return new Vector3f(pModelPart.xRot, pModelPart.yRot, pModelPart.zRot);
    }

    private void setRotationFromVector(ModelPart pModelPart, Vector3f pRotationVector) {
        pModelPart.setRotation(pRotationVector.x(), pRotationVector.y(), pRotationVector.z());
    }

    private void setupInitialAnimationValues(T pAxolotl, float pNetHeadYaw, float pHeadPitch) {
        this.body.x = 0.0f;
        this.head.y = 0.0f;
        this.body.y = 20.0f;
        Map<String, Vector3f> map = ((Axolotl)pAxolotl).getModelRotationValues();
        if (map.isEmpty()) {
            this.body.setRotation(pHeadPitch * ((float)Math.PI / 180), pNetHeadYaw * ((float)Math.PI / 180), 0.0f);
            this.head.setRotation(0.0f, 0.0f, 0.0f);
            this.leftHindLeg.setRotation(0.0f, 0.0f, 0.0f);
            this.rightHindLeg.setRotation(0.0f, 0.0f, 0.0f);
            this.leftFrontLeg.setRotation(0.0f, 0.0f, 0.0f);
            this.rightFrontLeg.setRotation(0.0f, 0.0f, 0.0f);
            this.leftGills.setRotation(0.0f, 0.0f, 0.0f);
            this.rightGills.setRotation(0.0f, 0.0f, 0.0f);
            this.topGills.setRotation(0.0f, 0.0f, 0.0f);
            this.tail.setRotation(0.0f, 0.0f, 0.0f);
        } else {
            this.setRotationFromVector(this.body, map.get("body"));
            this.setRotationFromVector(this.head, map.get("head"));
            this.setRotationFromVector(this.leftHindLeg, map.get("left_hind_leg"));
            this.setRotationFromVector(this.rightHindLeg, map.get("right_hind_leg"));
            this.setRotationFromVector(this.leftFrontLeg, map.get("left_front_leg"));
            this.setRotationFromVector(this.rightFrontLeg, map.get("right_front_leg"));
            this.setRotationFromVector(this.leftGills, map.get("left_gills"));
            this.setRotationFromVector(this.rightGills, map.get("right_gills"));
            this.setRotationFromVector(this.topGills, map.get("top_gills"));
            this.setRotationFromVector(this.tail, map.get("tail"));
        }
    }

    private float lerpTo(float p_170375_, float p_170376_) {
        return this.lerpTo(0.05f, p_170375_, p_170376_);
    }

    private float lerpTo(float p_170378_, float p_170379_, float p_170380_) {
        return Mth.rotLerp(p_170378_, p_170379_, p_170380_);
    }

    private void lerpPart(ModelPart p_170404_, float p_170405_, float p_170406_, float p_170407_) {
        p_170404_.setRotation(this.lerpTo(p_170404_.xRot, p_170405_), this.lerpTo(p_170404_.yRot, p_170406_), this.lerpTo(p_170404_.zRot, p_170407_));
    }

    private void setupLayStillOnGroundAnimation(float p_170415_, float p_170416_) {
        float f = p_170415_ * 0.09f;
        float f1 = Mth.sin(f);
        float f2 = Mth.cos(f);
        float f3 = f1 * f1 - 2.0f * f1;
        float f4 = f2 * f2 - 3.0f * f1;
        this.head.xRot = this.lerpTo(this.head.xRot, -0.09f * f3);
        this.head.yRot = this.lerpTo(this.head.yRot, 0.0f);
        this.head.zRot = this.lerpTo(this.head.zRot, -0.2f);
        this.tail.yRot = this.lerpTo(this.tail.yRot, -0.1f + 0.1f * f3);
        this.topGills.xRot = this.lerpTo(this.topGills.xRot, 0.6f + 0.05f * f4);
        this.leftGills.yRot = this.lerpTo(this.leftGills.yRot, -this.topGills.xRot);
        this.rightGills.yRot = this.lerpTo(this.rightGills.yRot, -this.leftGills.yRot);
        this.lerpPart(this.leftHindLeg, 1.1f, 1.0f, 0.0f);
        this.lerpPart(this.leftFrontLeg, 0.8f, 2.3f, -0.5f);
        this.applyMirrorLegRotations();
        this.body.xRot = this.lerpTo(0.2f, this.body.xRot, 0.0f);
        this.body.yRot = this.lerpTo(this.body.yRot, p_170416_ * ((float)Math.PI / 180));
        this.body.zRot = this.lerpTo(this.body.zRot, 0.0f);
    }

    private void setupGroundCrawlingAnimation(float p_170419_, float p_170420_) {
        float f = p_170419_ * 0.11f;
        float f1 = Mth.cos(f);
        float f2 = (f1 * f1 - 2.0f * f1) / 5.0f;
        float f3 = 0.7f * f1;
        this.head.xRot = this.lerpTo(this.head.xRot, 0.0f);
        this.head.yRot = this.lerpTo(this.head.yRot, 0.09f * f1);
        this.head.zRot = this.lerpTo(this.head.zRot, 0.0f);
        this.tail.yRot = this.lerpTo(this.tail.yRot, this.head.yRot);
        this.topGills.xRot = this.lerpTo(this.topGills.xRot, 0.6f - 0.08f * (f1 * f1 + 2.0f * Mth.sin(f)));
        this.leftGills.yRot = this.lerpTo(this.leftGills.yRot, -this.topGills.xRot);
        this.rightGills.yRot = this.lerpTo(this.rightGills.yRot, -this.leftGills.yRot);
        this.lerpPart(this.leftHindLeg, 0.9424779f, 1.5f - f2, -0.1f);
        this.lerpPart(this.leftFrontLeg, 1.0995574f, 1.5707964f - f3, 0.0f);
        this.lerpPart(this.rightHindLeg, this.leftHindLeg.xRot, -1.0f - f2, 0.0f);
        this.lerpPart(this.rightFrontLeg, this.leftFrontLeg.xRot, -1.5707964f - f3, 0.0f);
        this.body.xRot = this.lerpTo(0.2f, this.body.xRot, 0.0f);
        this.body.yRot = this.lerpTo(this.body.yRot, p_170420_ * ((float)Math.PI / 180));
        this.body.zRot = this.lerpTo(this.body.zRot, 0.0f);
    }

    private void setupWaterHoveringAnimation(float p_170373_) {
        float f = p_170373_ * 0.075f;
        float f1 = Mth.cos(f);
        float f2 = Mth.sin(f) * 0.15f;
        this.body.xRot = this.lerpTo(this.body.xRot, -0.15f + 0.075f * f1);
        this.body.y -= f2;
        this.head.xRot = this.lerpTo(this.head.xRot, -this.body.xRot);
        this.topGills.xRot = this.lerpTo(this.topGills.xRot, 0.2f * f1);
        this.leftGills.yRot = this.lerpTo(this.leftGills.yRot, -0.3f * f1 - 0.19f);
        this.rightGills.yRot = this.lerpTo(this.rightGills.yRot, -this.leftGills.yRot);
        this.lerpPart(this.leftHindLeg, 2.3561945f - f1 * 0.11f, 0.47123894f, 1.7278761f);
        this.lerpPart(this.leftFrontLeg, 0.7853982f - f1 * 0.2f, 2.042035f, 0.0f);
        this.applyMirrorLegRotations();
        this.tail.yRot = this.lerpTo(this.tail.yRot, 0.5f * f1);
        this.head.yRot = this.lerpTo(this.head.yRot, 0.0f);
        this.head.zRot = this.lerpTo(this.head.zRot, 0.0f);
    }

    private void setupSwimmingAnimation(float p_170423_, float p_170424_) {
        float f = p_170423_ * 0.33f;
        float f1 = Mth.sin(f);
        float f2 = Mth.cos(f);
        float f3 = 0.13f * f1;
        this.body.xRot = this.lerpTo(0.1f, this.body.xRot, p_170424_ * ((float)Math.PI / 180) + f3);
        this.head.xRot = -f3 * 1.8f;
        this.body.y -= 0.45f * f2;
        this.topGills.xRot = this.lerpTo(this.topGills.xRot, -0.5f * f1 - 0.8f);
        this.leftGills.yRot = this.lerpTo(this.leftGills.yRot, 0.3f * f1 + 0.9f);
        this.rightGills.yRot = this.lerpTo(this.rightGills.yRot, -this.leftGills.yRot);
        this.tail.yRot = this.lerpTo(this.tail.yRot, 0.3f * Mth.cos(f * 0.9f));
        this.lerpPart(this.leftHindLeg, 1.8849558f, -0.4f * f1, 1.5707964f);
        this.lerpPart(this.leftFrontLeg, 1.8849558f, -0.2f * f2 - 0.1f, 1.5707964f);
        this.applyMirrorLegRotations();
        this.head.yRot = this.lerpTo(this.head.yRot, 0.0f);
        this.head.zRot = this.lerpTo(this.head.zRot, 0.0f);
    }

    private void setupPlayDeadAnimation(float p_170413_) {
        this.lerpPart(this.leftHindLeg, 1.4137167f, 1.0995574f, 0.7853982f);
        this.lerpPart(this.leftFrontLeg, 0.7853982f, 2.042035f, 0.0f);
        this.body.xRot = this.lerpTo(this.body.xRot, -0.15f);
        this.body.zRot = this.lerpTo(this.body.zRot, 0.35f);
        this.applyMirrorLegRotations();
        this.body.yRot = this.lerpTo(this.body.yRot, p_170413_ * ((float)Math.PI / 180));
        this.head.xRot = this.lerpTo(this.head.xRot, 0.0f);
        this.head.yRot = this.lerpTo(this.head.yRot, 0.0f);
        this.head.zRot = this.lerpTo(this.head.zRot, 0.0f);
        this.tail.yRot = this.lerpTo(this.tail.yRot, 0.0f);
        this.lerpPart(this.topGills, 0.0f, 0.0f, 0.0f);
        this.lerpPart(this.leftGills, 0.0f, 0.0f, 0.0f);
        this.lerpPart(this.rightGills, 0.0f, 0.0f, 0.0f);
    }

    private void applyMirrorLegRotations() {
        this.lerpPart(this.rightHindLeg, this.leftHindLeg.xRot, -this.leftHindLeg.yRot, -this.leftHindLeg.zRot);
        this.lerpPart(this.rightFrontLeg, this.leftFrontLeg.xRot, -this.leftFrontLeg.yRot, -this.leftFrontLeg.zRot);
    }
}

