/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class BlazeModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart[] upperBodyParts;
    private final ModelPart head;

    public BlazeModel(ModelPart pRoot) {
        this.root = pRoot;
        this.head = pRoot.getChilds("head");
        this.upperBodyParts = new ModelPart[12];
        Arrays.setAll(this.upperBodyParts, p_170449_ -> pRoot.getChilds(BlazeModel.getPartName(p_170449_)));
    }

    private static String getPartName(int pIndex) {
        return "part" + pIndex;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.ZERO);
        float f = 0.0f;
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(0, 16).addBox(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f);
        int i = 0;
        while (i < 4) {
            float f1 = Mth.cos(f) * 9.0f;
            float f2 = -2.0f + Mth.cos((float)(i * 2) * 0.25f);
            float f3 = Mth.sin(f) * 9.0f;
            partdefinition.addOrReplaceChild(BlazeModel.getPartName(i), cubelistbuilder, PartPose.offset(f1, f2, f3));
            f += 1.0f;
            ++i;
        }
        f = 0.7853982f;
        int j = 4;
        while (j < 8) {
            float f4 = Mth.cos(f) * 7.0f;
            float f6 = 2.0f + Mth.cos((float)(j * 2) * 0.25f);
            float f8 = Mth.sin(f) * 7.0f;
            partdefinition.addOrReplaceChild(BlazeModel.getPartName(j), cubelistbuilder, PartPose.offset(f4, f6, f8));
            f += 1.0f;
            ++j;
        }
        f = 0.47123894f;
        int k = 8;
        while (k < 12) {
            float f5 = Mth.cos(f) * 5.0f;
            float f7 = 11.0f + Mth.cos((float)k * 1.5f * 0.5f);
            float f9 = Mth.sin(f) * 5.0f;
            partdefinition.addOrReplaceChild(BlazeModel.getPartName(k), cubelistbuilder, PartPose.offset(f5, f7, f9));
            f += 1.0f;
            ++k;
        }
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = pAgeInTicks * (float)Math.PI * -0.1f;
        int i = 0;
        while (i < 4) {
            this.upperBodyParts[i].y = -2.0f + Mth.cos(((float)(i * 2) + pAgeInTicks) * 0.25f);
            this.upperBodyParts[i].x = Mth.cos(f) * 9.0f;
            this.upperBodyParts[i].z = Mth.sin(f) * 9.0f;
            f += 1.0f;
            ++i;
        }
        f = 0.7853982f + pAgeInTicks * (float)Math.PI * 0.03f;
        int j = 4;
        while (j < 8) {
            this.upperBodyParts[j].y = 2.0f + Mth.cos(((float)(j * 2) + pAgeInTicks) * 0.25f);
            this.upperBodyParts[j].x = Mth.cos(f) * 7.0f;
            this.upperBodyParts[j].z = Mth.sin(f) * 7.0f;
            f += 1.0f;
            ++j;
        }
        f = 0.47123894f + pAgeInTicks * (float)Math.PI * -0.05f;
        int k = 8;
        while (k < 12) {
            this.upperBodyParts[k].y = 11.0f + Mth.cos(((float)k * 1.5f + pAgeInTicks) * 0.5f);
            this.upperBodyParts[k].x = Mth.cos(f) * 5.0f;
            this.upperBodyParts[k].z = Mth.sin(f) * 5.0f;
            f += 1.0f;
            ++k;
        }
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
    }
}

