/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class EndermiteModel<T extends Entity>
extends HierarchicalModel<T> {
    private static final int BODY_COUNT = 4;
    private static final int[][] BODY_SIZES = new int[][]{{4, 3, 2}, {6, 4, 5}, {3, 3, 1}, {1, 2, 1}};
    private static final int[][] BODY_TEXS;
    private final ModelPart root;
    private final ModelPart[] bodyParts;

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[2];
        int[] nArray = new int[2];
        nArray[1] = 5;
        nArrayArray[1] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 14;
        nArrayArray[2] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 18;
        nArrayArray[3] = nArray3;
        BODY_TEXS = nArrayArray;
    }

    public EndermiteModel(ModelPart pRoot) {
        this.root = pRoot;
        this.bodyParts = new ModelPart[4];
        int i = 0;
        while (i < 4) {
            this.bodyParts[i] = pRoot.getChilds(EndermiteModel.createSegmentName(i));
            ++i;
        }
    }

    private static String createSegmentName(int pIndex) {
        return "segment" + pIndex;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = -3.5f;
        int i = 0;
        while (i < 4) {
            partdefinition.addOrReplaceChild(EndermiteModel.createSegmentName(i), CubeListBuilder.create().texOffs(BODY_TEXS[i][0], BODY_TEXS[i][1]).addBox((float)BODY_SIZES[i][0] * -0.5f, 0.0f, (float)BODY_SIZES[i][2] * -0.5f, BODY_SIZES[i][0], BODY_SIZES[i][1], BODY_SIZES[i][2]), PartPose.offset(0.0f, 24 - BODY_SIZES[i][1], f));
            if (i < 3) {
                f += (float)(BODY_SIZES[i][2] + BODY_SIZES[i + 1][2]) * 0.5f;
            }
            ++i;
        }
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        int i = 0;
        while (i < this.bodyParts.length) {
            this.bodyParts[i].yRot = Mth.cos(pAgeInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI) * (float)Math.PI * 0.01f * (float)(1 + Math.abs(i - 2));
            this.bodyParts[i].x = Mth.sin(pAgeInTicks * 0.9f + (float)i * 0.15f * (float)Math.PI) * (float)Math.PI * 0.1f * (float)Math.abs(i - 2);
            ++i;
        }
    }
}

