/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Function;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class HumanoidModel<T extends LivingEntity>
extends AgeableListModel<T>
implements ArmedModel,
HeadedModel {
    public static final float OVERLAY_SCALE = 0.25f;
    public static final float HAT_OVERLAY_SCALE = 0.5f;
    private static final float SPYGLASS_ARM_ROT_Y = 0.2617994f;
    private static final float SPYGLASS_ARM_ROT_X = 1.9198622f;
    private static final float SPYGLASS_ARM_CROUCH_ROT_X = 0.2617994f;
    public final ModelPart head;
    public final ModelPart hat;
    public final ModelPart body;
    public final ModelPart rightArm;
    public final ModelPart leftArm;
    public final ModelPart rightLeg;
    public final ModelPart leftLeg;
    public ArmPose leftArmPose = ArmPose.EMPTY;
    public ArmPose rightArmPose = ArmPose.EMPTY;
    public boolean crouching;
    public float swimAmount;

    public HumanoidModel(ModelPart pRoot) {
        this(pRoot, RenderType::entityCutoutNoCull);
    }

    public HumanoidModel(ModelPart pRoot, Function<ResourceLocation, RenderType> pRenderType) {
        super(pRenderType, true, 16.0f, 0.0f, 2.0f, 2.0f, 24.0f);
        this.head = pRoot.getChilds("head");
        this.hat = pRoot.getChilds("hat");
        this.body = pRoot.getChilds("body");
        this.rightArm = pRoot.getChilds("right_arm");
        this.leftArm = pRoot.getChilds("left_arm");
        this.rightLeg = pRoot.getChilds("right_leg");
        this.leftLeg = pRoot.getChilds("left_leg");
    }

    public static MeshDefinition createMesh(CubeDeformation p_170682_, float p_170683_) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_), PartPose.offset(0.0f, 0.0f + p_170683_, 0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, p_170682_.extend(0.5f)), PartPose.offset(0.0f, 0.0f + p_170683_, 0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 16).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(0.0f, 0.0f + p_170683_, 0.0f));
        partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 16).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(-5.0f, 2.0f + p_170683_, 0.0f));
        partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(40, 16).mirror().addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(5.0f, 2.0f + p_170683_, 0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(-1.9f, 12.0f + p_170683_, 0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 16).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, p_170682_), PartPose.offset(1.9f, 12.0f + p_170683_, 0.0f));
        return meshdefinition;
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightArm, (Object)this.leftArm, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.hat);
    }

    @Override
    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.swimAmount = ((LivingEntity)pEntity).getSwimAmount(pPartialTick);
        super.prepareMobModel(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        boolean flag2;
        boolean flag = ((LivingEntity)pEntity).getFallFlyingTicks() > 4;
        boolean flag1 = ((LivingEntity)pEntity).isVisuallySwimming();
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = flag ? -0.7853982f : (this.swimAmount > 0.0f ? (flag1 ? this.rotlerpRad(this.swimAmount, this.head.xRot, -0.7853982f) : this.rotlerpRad(this.swimAmount, this.head.xRot, pHeadPitch * ((float)Math.PI / 180))) : pHeadPitch * ((float)Math.PI / 180));
        this.body.yRot = 0.0f;
        this.rightArm.z = 0.0f;
        this.rightArm.x = -5.0f;
        this.leftArm.z = 0.0f;
        this.leftArm.x = 5.0f;
        float f = 1.0f;
        if (flag) {
            f = (float)((Entity)pEntity).getDeltaMovement().lengthSqr();
            f /= 0.2f;
            f *= f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.rightArm.xRot = Mth.cos(pLimbSwing * 0.6662f + (float)Math.PI) * 2.0f * pLimbSwingAmount * 0.5f / f;
        this.leftArm.xRot = Mth.cos(pLimbSwing * 0.6662f) * 2.0f * pLimbSwingAmount * 0.5f / f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        this.rightLeg.xRot = Mth.cos(pLimbSwing * 0.6662f) * 1.4f * pLimbSwingAmount / f;
        this.leftLeg.xRot = Mth.cos(pLimbSwing * 0.6662f + (float)Math.PI) * 1.4f * pLimbSwingAmount / f;
        this.rightLeg.yRot = 0.0f;
        this.leftLeg.yRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        this.leftLeg.zRot = 0.0f;
        if (this.riding) {
            this.rightArm.xRot += -0.62831855f;
            this.leftArm.xRot += -0.62831855f;
            this.rightLeg.xRot = -1.4137167f;
            this.rightLeg.yRot = 0.31415927f;
            this.rightLeg.zRot = 0.07853982f;
            this.leftLeg.xRot = -1.4137167f;
            this.leftLeg.yRot = -0.31415927f;
            this.leftLeg.zRot = -0.07853982f;
        }
        this.rightArm.yRot = 0.0f;
        this.leftArm.yRot = 0.0f;
        boolean bl = flag2 = ((LivingEntity)pEntity).getMainArm() == HumanoidArm.RIGHT;
        if (((LivingEntity)pEntity).isUsingItem()) {
            boolean flag3;
            boolean bl2 = flag3 = ((LivingEntity)pEntity).getUsedItemHand() == InteractionHand.MAIN_HAND;
            if (flag3 == flag2) {
                this.poseRightArm(pEntity);
            } else {
                this.poseLeftArm(pEntity);
            }
        } else {
            boolean flag4;
            boolean bl3 = flag4 = flag2 ? this.leftArmPose.isTwoHanded() : this.rightArmPose.isTwoHanded();
            if (flag2 != flag4) {
                this.poseLeftArm(pEntity);
                this.poseRightArm(pEntity);
            } else {
                this.poseRightArm(pEntity);
                this.poseLeftArm(pEntity);
            }
        }
        this.setupAttackAnimation(pEntity, pAgeInTicks);
        if (this.crouching) {
            this.body.xRot = 0.5f;
            this.rightArm.xRot += 0.4f;
            this.leftArm.xRot += 0.4f;
            this.rightLeg.z = 4.0f;
            this.leftLeg.z = 4.0f;
            this.rightLeg.y = 12.2f;
            this.leftLeg.y = 12.2f;
            this.head.y = 4.2f;
            this.body.y = 3.2f;
            this.leftArm.y = 5.2f;
            this.rightArm.y = 5.2f;
        } else {
            this.body.xRot = 0.0f;
            this.rightLeg.z = 0.1f;
            this.leftLeg.z = 0.1f;
            this.rightLeg.y = 12.0f;
            this.leftLeg.y = 12.0f;
            this.head.y = 0.0f;
            this.body.y = 0.0f;
            this.leftArm.y = 2.0f;
            this.rightArm.y = 2.0f;
        }
        if (this.rightArmPose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart(this.rightArm, pAgeInTicks, 1.0f);
        }
        if (this.leftArmPose != ArmPose.SPYGLASS) {
            AnimationUtils.bobModelPart(this.leftArm, pAgeInTicks, -1.0f);
        }
        if (this.swimAmount > 0.0f) {
            float f2;
            float f5 = pLimbSwing % 26.0f;
            HumanoidArm humanoidarm = this.getAttackArm(pEntity);
            float f1 = humanoidarm == HumanoidArm.RIGHT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            float f3 = f2 = humanoidarm == HumanoidArm.LEFT && this.attackTime > 0.0f ? 0.0f : this.swimAmount;
            if (!((LivingEntity)pEntity).isUsingItem()) {
                if (f5 < 14.0f) {
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 0.0f);
                    this.rightArm.xRot = Mth.lerp(f1, this.rightArm.xRot, 0.0f);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp(f1, this.rightArm.yRot, (float)Math.PI);
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI + 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                    this.rightArm.zRot = Mth.lerp(f1, this.rightArm.zRot, (float)Math.PI - 1.8707964f * this.quadraticArmUpdate(f5) / this.quadraticArmUpdate(14.0f));
                } else if (f5 >= 14.0f && f5 < 22.0f) {
                    float f6 = (f5 - 14.0f) / 8.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f * f6);
                    this.rightArm.xRot = Mth.lerp(f1, this.rightArm.xRot, 1.5707964f * f6);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp(f1, this.rightArm.yRot, (float)Math.PI);
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, 5.012389f - 1.8707964f * f6);
                    this.rightArm.zRot = Mth.lerp(f1, this.rightArm.zRot, 1.2707963f + 1.8707964f * f6);
                } else if (f5 >= 22.0f && f5 < 26.0f) {
                    float f32 = (f5 - 22.0f) / 4.0f;
                    this.leftArm.xRot = this.rotlerpRad(f2, this.leftArm.xRot, 1.5707964f - 1.5707964f * f32);
                    this.rightArm.xRot = Mth.lerp(f1, this.rightArm.xRot, 1.5707964f - 1.5707964f * f32);
                    this.leftArm.yRot = this.rotlerpRad(f2, this.leftArm.yRot, (float)Math.PI);
                    this.rightArm.yRot = Mth.lerp(f1, this.rightArm.yRot, (float)Math.PI);
                    this.leftArm.zRot = this.rotlerpRad(f2, this.leftArm.zRot, (float)Math.PI);
                    this.rightArm.zRot = Mth.lerp(f1, this.rightArm.zRot, (float)Math.PI);
                }
            }
            float f7 = 0.3f;
            float f4 = 0.33333334f;
            this.leftLeg.xRot = Mth.lerp(this.swimAmount, this.leftLeg.xRot, 0.3f * Mth.cos(pLimbSwing * 0.33333334f + (float)Math.PI));
            this.rightLeg.xRot = Mth.lerp(this.swimAmount, this.rightLeg.xRot, 0.3f * Mth.cos(pLimbSwing * 0.33333334f));
        }
        this.hat.copyFrom(this.head);
    }

    private void poseRightArm(T pLivingEntity) {
        switch (this.rightArmPose) {
            case EMPTY: {
                this.rightArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.9424779f;
                this.rightArm.yRot = -0.5235988f;
                break;
            }
            case ITEM: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - 0.31415927f;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.rightArm.xRot = this.rightArm.xRot * 0.5f - (float)Math.PI;
                this.rightArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.yRot = -0.1f + this.head.yRot;
                this.leftArm.yRot = 0.1f + this.head.yRot + 0.4f;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, pLivingEntity, true);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, true);
                break;
            }
            case SPYGLASS: {
                this.rightArm.xRot = Mth.clamp(this.head.xRot - 1.9198622f - (((Entity)pLivingEntity).isCrouching() ? 0.2617994f : 0.0f), -2.4f, 3.3f);
                this.rightArm.yRot = this.head.yRot - 0.2617994f;
            }
        }
    }

    private void poseLeftArm(T pLivingEntity) {
        switch (this.leftArmPose) {
            case EMPTY: {
                this.leftArm.yRot = 0.0f;
                break;
            }
            case BLOCK: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.9424779f;
                this.leftArm.yRot = 0.5235988f;
                break;
            }
            case ITEM: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - 0.31415927f;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case THROW_SPEAR: {
                this.leftArm.xRot = this.leftArm.xRot * 0.5f - (float)Math.PI;
                this.leftArm.yRot = 0.0f;
                break;
            }
            case BOW_AND_ARROW: {
                this.rightArm.yRot = -0.1f + this.head.yRot - 0.4f;
                this.leftArm.yRot = 0.1f + this.head.yRot;
                this.rightArm.xRot = -1.5707964f + this.head.xRot;
                this.leftArm.xRot = -1.5707964f + this.head.xRot;
                break;
            }
            case CROSSBOW_CHARGE: {
                AnimationUtils.animateCrossbowCharge(this.rightArm, this.leftArm, pLivingEntity, false);
                break;
            }
            case CROSSBOW_HOLD: {
                AnimationUtils.animateCrossbowHold(this.rightArm, this.leftArm, this.head, false);
                break;
            }
            case SPYGLASS: {
                this.leftArm.xRot = Mth.clamp(this.head.xRot - 1.9198622f - (((Entity)pLivingEntity).isCrouching() ? 0.2617994f : 0.0f), -2.4f, 3.3f);
                this.leftArm.yRot = this.head.yRot + 0.2617994f;
            }
        }
    }

    protected void setupAttackAnimation(T pLivingEntity, float pAgeInTicks) {
        if (!(this.attackTime <= 0.0f)) {
            HumanoidArm humanoidarm = this.getAttackArm(pLivingEntity);
            ModelPart modelpart = this.getArm(humanoidarm);
            float f = this.attackTime;
            this.body.yRot = Mth.sin(Mth.sqrt(f) * ((float)Math.PI * 2)) * 0.2f;
            if (humanoidarm == HumanoidArm.LEFT) {
                this.body.yRot *= -1.0f;
            }
            this.rightArm.z = Mth.sin(this.body.yRot) * 5.0f;
            this.rightArm.x = -Mth.cos(this.body.yRot) * 5.0f;
            this.leftArm.z = -Mth.sin(this.body.yRot) * 5.0f;
            this.leftArm.x = Mth.cos(this.body.yRot) * 5.0f;
            this.rightArm.yRot += this.body.yRot;
            this.leftArm.yRot += this.body.yRot;
            this.leftArm.xRot += this.body.yRot;
            f = 1.0f - this.attackTime;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float f1 = Mth.sin(f * (float)Math.PI);
            float f2 = Mth.sin(this.attackTime * (float)Math.PI) * -(this.head.xRot - 0.7f) * 0.75f;
            modelpart.xRot -= f1 * 1.2f + f2;
            modelpart.yRot += this.body.yRot * 2.0f;
            modelpart.zRot += Mth.sin(this.attackTime * (float)Math.PI) * -0.4f;
        }
    }

    protected float rotlerpRad(float pAngle, float pMaxAngle, float pMul) {
        float f = (pMul - pMaxAngle) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return pMaxAngle + pAngle * f;
    }

    private float quadraticArmUpdate(float pLimbSwing) {
        return -65.0f * pLimbSwing + pLimbSwing * pLimbSwing;
    }

    @Override
    public void copyPropertiesTo(HumanoidModel<T> pModel) {
        super.copyPropertiesTo(pModel);
        pModel.leftArmPose = this.leftArmPose;
        pModel.rightArmPose = this.rightArmPose;
        pModel.crouching = this.crouching;
        pModel.head.copyFrom(this.head);
        pModel.hat.copyFrom(this.hat);
        pModel.body.copyFrom(this.body);
        pModel.rightArm.copyFrom(this.rightArm);
        pModel.leftArm.copyFrom(this.leftArm);
        pModel.rightLeg.copyFrom(this.rightLeg);
        pModel.leftLeg.copyFrom(this.leftLeg);
    }

    public void setAllVisible(boolean pVisible) {
        this.head.visible = pVisible;
        this.hat.visible = pVisible;
        this.body.visible = pVisible;
        this.rightArm.visible = pVisible;
        this.leftArm.visible = pVisible;
        this.rightLeg.visible = pVisible;
        this.leftLeg.visible = pVisible;
    }

    @Override
    public void translateToHand(HumanoidArm pSide, PoseStack pPoseStack) {
        this.getArm(pSide).translateAndRotate(pPoseStack);
    }

    protected ModelPart getArm(HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @Override
    public ModelPart getHead() {
        return this.head;
    }

    private HumanoidArm getAttackArm(T pEntity) {
        HumanoidArm humanoidarm = ((LivingEntity)pEntity).getMainArm();
        return ((LivingEntity)pEntity).swingingArm == InteractionHand.MAIN_HAND ? humanoidarm : humanoidarm.getOpposite();
    }

    public static enum ArmPose {
        EMPTY(false),
        ITEM(false),
        BLOCK(false),
        BOW_AND_ARROW(true),
        THROW_SPEAR(false),
        CROSSBOW_CHARGE(true),
        CROSSBOW_HOLD(true),
        SPYGLASS(false);

        private final boolean twoHanded;

        private ArmPose(boolean p_102896_) {
            this.twoHanded = p_102896_;
        }

        public boolean isTwoHanded() {
            return this.twoHanded;
        }
    }
}

