/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Slime;

public class LavaSlimeModel<T extends Slime>
extends HierarchicalModel<T> {
    private static final int SEGMENT_COUNT = 8;
    private final ModelPart root;
    private final ModelPart[] bodyCubes = new ModelPart[8];

    public LavaSlimeModel(ModelPart pRoot) {
        this.root = pRoot;
        Arrays.setAll(this.bodyCubes, p_170709_ -> pRoot.getChilds(LavaSlimeModel.getSegmentName(p_170709_)));
    }

    private static String getSegmentName(int pIndex) {
        return "cube" + pIndex;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 0;
        while (i < 8) {
            int j = 0;
            int k = i;
            if (i == 2) {
                j = 24;
                k = 10;
            } else if (i == 3) {
                j = 24;
                k = 19;
            }
            partdefinition.addOrReplaceChild(LavaSlimeModel.getSegmentName(i), CubeListBuilder.create().texOffs(j, k).addBox(-4.0f, 16 + i, -4.0f, 8.0f, 1.0f, 8.0f), PartPose.ZERO);
            ++i;
        }
        partdefinition.addOrReplaceChild("inside_cube", CubeListBuilder.create().texOffs(0, 16).addBox(-2.0f, 18.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.ZERO);
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
    }

    @Override
    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        float f = Mth.lerp(pPartialTick, ((Slime)pEntity).oSquish, ((Slime)pEntity).squish);
        if (f < 0.0f) {
            f = 0.0f;
        }
        int i = 0;
        while (i < this.bodyCubes.length) {
            this.bodyCubes[i].y = (float)(-(4 - i)) * f * 1.7f;
            ++i;
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

