/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Parrot;

public class ParrotModel
extends HierarchicalModel<Parrot> {
    private static final String FEATHER = "feather";
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart tail;
    private final ModelPart leftWing;
    private final ModelPart rightWing;
    private final ModelPart head;
    private final ModelPart feather;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;

    public ParrotModel(ModelPart pRoot) {
        this.root = pRoot;
        this.body = pRoot.getChilds("body");
        this.tail = pRoot.getChilds("tail");
        this.leftWing = pRoot.getChilds("left_wing");
        this.rightWing = pRoot.getChilds("right_wing");
        this.head = pRoot.getChilds("head");
        this.feather = this.head.getChilds(FEATHER);
        this.leftLeg = pRoot.getChilds("left_leg");
        this.rightLeg = pRoot.getChilds("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(2, 8).addBox(-1.5f, 0.0f, -1.5f, 3.0f, 6.0f, 3.0f), PartPose.offset(0.0f, 16.5f, -3.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, 1).addBox(-1.5f, -1.0f, -1.0f, 3.0f, 4.0f, 1.0f), PartPose.offset(0.0f, 21.07f, 1.16f));
        partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(19, 8).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f), PartPose.offset(1.5f, 16.94f, -2.76f));
        partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(19, 8).addBox(-0.5f, 0.0f, -1.5f, 1.0f, 5.0f, 3.0f), PartPose.offset(-1.5f, 16.94f, -2.76f));
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(2, 2).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 3.0f, 2.0f), PartPose.offset(0.0f, 15.69f, -2.76f));
        partdefinition1.addOrReplaceChild("head2", CubeListBuilder.create().texOffs(10, 0).addBox(-1.0f, -0.5f, -2.0f, 2.0f, 1.0f, 4.0f), PartPose.offset(0.0f, -2.0f, -1.0f));
        partdefinition1.addOrReplaceChild("beak1", CubeListBuilder.create().texOffs(11, 7).addBox(-0.5f, -1.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offset(0.0f, -0.5f, -1.5f));
        partdefinition1.addOrReplaceChild("beak2", CubeListBuilder.create().texOffs(16, 7).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f), PartPose.offset(0.0f, -1.75f, -2.45f));
        partdefinition1.addOrReplaceChild(FEATHER, CubeListBuilder.create().texOffs(2, 18).addBox(0.0f, -4.0f, -2.0f, 0.0f, 5.0f, 4.0f), PartPose.offset(0.0f, -2.15f, 0.15f));
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(14, 18).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        partdefinition.addOrReplaceChild("left_leg", cubelistbuilder, PartPose.offset(1.0f, 22.0f, -1.05f));
        partdefinition.addOrReplaceChild("right_leg", cubelistbuilder, PartPose.offset(-1.0f, 22.0f, -1.05f));
        return LayerDefinition.create(meshdefinition, 32, 32);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(Parrot pState, float p_103218_, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw) {
        this.setupAnim(ParrotModel.getState(pState), pState.tickCount, p_103218_, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw);
    }

    @Override
    public void prepareMobModel(Parrot pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.prepare(ParrotModel.getState(pEntity));
    }

    public void renderOnShoulder(PoseStack p_103224_, VertexConsumer p_103225_, int p_103226_, int p_103227_, float p_103228_, float p_103229_, float p_103230_, float p_103231_, int p_103232_) {
        this.prepare(State.ON_SHOULDER);
        this.setupAnim(State.ON_SHOULDER, p_103232_, p_103228_, p_103229_, 0.0f, p_103230_, p_103231_);
        this.root.render(p_103224_, p_103225_, p_103226_, p_103227_);
    }

    private void setupAnim(State p_103242_, int p_103243_, float p_103244_, float p_103245_, float p_103246_, float p_103247_, float p_103248_) {
        this.head.xRot = p_103248_ * ((float)Math.PI / 180);
        this.head.yRot = p_103247_ * ((float)Math.PI / 180);
        this.head.zRot = 0.0f;
        this.head.x = 0.0f;
        this.body.x = 0.0f;
        this.tail.x = 0.0f;
        this.rightWing.x = -1.5f;
        this.leftWing.x = 1.5f;
        switch (p_103242_) {
            case SITTING: {
                break;
            }
            case PARTY: {
                float f = Mth.cos(p_103243_);
                float f1 = Mth.sin(p_103243_);
                this.head.x = f;
                this.head.y = 15.69f + f1;
                this.head.xRot = 0.0f;
                this.head.yRot = 0.0f;
                this.head.zRot = Mth.sin(p_103243_) * 0.4f;
                this.body.x = f;
                this.body.y = 16.5f + f1;
                this.leftWing.zRot = -0.0873f - p_103246_;
                this.leftWing.x = 1.5f + f;
                this.leftWing.y = 16.94f + f1;
                this.rightWing.zRot = 0.0873f + p_103246_;
                this.rightWing.x = -1.5f + f;
                this.rightWing.y = 16.94f + f1;
                this.tail.x = f;
                this.tail.y = 21.07f + f1;
                break;
            }
            case STANDING: {
                this.leftLeg.xRot += Mth.cos(p_103244_ * 0.6662f) * 1.4f * p_103245_;
                this.rightLeg.xRot += Mth.cos(p_103244_ * 0.6662f + (float)Math.PI) * 1.4f * p_103245_;
            }
            default: {
                float f2 = p_103246_ * 0.3f;
                this.head.y = 15.69f + f2;
                this.tail.xRot = 1.015f + Mth.cos(p_103244_ * 0.6662f) * 0.3f * p_103245_;
                this.tail.y = 21.07f + f2;
                this.body.y = 16.5f + f2;
                this.leftWing.zRot = -0.0873f - p_103246_;
                this.leftWing.y = 16.94f + f2;
                this.rightWing.zRot = 0.0873f + p_103246_;
                this.rightWing.y = 16.94f + f2;
                this.leftLeg.y = 22.0f + f2;
                this.rightLeg.y = 22.0f + f2;
            }
        }
    }

    private void prepare(State pState) {
        this.feather.xRot = -0.2214f;
        this.body.xRot = 0.4937f;
        this.leftWing.xRot = -0.69813174f;
        this.leftWing.yRot = (float)(-Math.PI);
        this.rightWing.xRot = -0.69813174f;
        this.rightWing.yRot = (float)(-Math.PI);
        this.leftLeg.xRot = -0.0299f;
        this.rightLeg.xRot = -0.0299f;
        this.leftLeg.y = 22.0f;
        this.rightLeg.y = 22.0f;
        this.leftLeg.zRot = 0.0f;
        this.rightLeg.zRot = 0.0f;
        switch (pState) {
            case SITTING: {
                float f = 1.9f;
                this.head.y = 17.59f;
                this.tail.xRot = 1.5388988f;
                this.tail.y = 22.97f;
                this.body.y = 18.4f;
                this.leftWing.zRot = -0.0873f;
                this.leftWing.y = 18.84f;
                this.rightWing.zRot = 0.0873f;
                this.rightWing.y = 18.84f;
                this.leftLeg.y += 1.0f;
                this.rightLeg.y += 1.0f;
                this.leftLeg.xRot += 1.0f;
                this.rightLeg.xRot += 1.0f;
                break;
            }
            case PARTY: {
                this.leftLeg.zRot = -0.34906584f;
                this.rightLeg.zRot = 0.34906584f;
            }
            default: {
                break;
            }
            case FLYING: {
                this.leftLeg.xRot += 0.69813174f;
                this.rightLeg.xRot += 0.69813174f;
            }
        }
    }

    private static State getState(Parrot pParrot) {
        if (pParrot.isPartyParrot()) {
            return State.PARTY;
        }
        if (pParrot.isInSittingPose()) {
            return State.SITTING;
        }
        return pParrot.isFlying() ? State.FLYING : State.STANDING;
    }

    public static enum State {
        FLYING,
        STANDING,
        SITTING,
        PARTY,
        ON_SHOULDER;

    }
}

