/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Rabbit;

public class RabbitModel<T extends Rabbit>
extends EntityModel<T> {
    private static final float REAR_JUMP_ANGLE = 50.0f;
    private static final float FRONT_JUMP_ANGLE = -40.0f;
    private static final String LEFT_HAUNCH = "left_haunch";
    private static final String RIGHT_HAUNCH = "right_haunch";
    private final ModelPart leftRearFoot;
    private final ModelPart rightRearFoot;
    private final ModelPart leftHaunch;
    private final ModelPart rightHaunch;
    private final ModelPart body;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart head;
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final ModelPart tail;
    private final ModelPart nose;
    private float jumpRotation;
    private static final float NEW_SCALE = 0.6f;

    public RabbitModel(ModelPart pRoot) {
        this.leftRearFoot = pRoot.getChilds("left_hind_foot");
        this.rightRearFoot = pRoot.getChilds("right_hind_foot");
        this.leftHaunch = pRoot.getChilds(LEFT_HAUNCH);
        this.rightHaunch = pRoot.getChilds(RIGHT_HAUNCH);
        this.body = pRoot.getChilds("body");
        this.leftFrontLeg = pRoot.getChilds("left_front_leg");
        this.rightFrontLeg = pRoot.getChilds("right_front_leg");
        this.head = pRoot.getChilds("head");
        this.rightEar = pRoot.getChilds("right_ear");
        this.leftEar = pRoot.getChilds("left_ear");
        this.tail = pRoot.getChilds("tail");
        this.nose = pRoot.getChilds("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("left_hind_foot", CubeListBuilder.create().texOffs(26, 24).addBox(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), PartPose.offset(3.0f, 17.5f, 3.7f));
        partdefinition.addOrReplaceChild("right_hind_foot", CubeListBuilder.create().texOffs(8, 24).addBox(-1.0f, 5.5f, -3.7f, 2.0f, 1.0f, 7.0f), PartPose.offset(-3.0f, 17.5f, 3.7f));
        partdefinition.addOrReplaceChild(LEFT_HAUNCH, CubeListBuilder.create().texOffs(30, 15).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), PartPose.offsetAndRotation(3.0f, 17.5f, 3.7f, -0.34906584f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild(RIGHT_HAUNCH, CubeListBuilder.create().texOffs(16, 15).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 4.0f, 5.0f), PartPose.offsetAndRotation(-3.0f, 17.5f, 3.7f, -0.34906584f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -2.0f, -10.0f, 6.0f, 5.0f, 10.0f), PartPose.offsetAndRotation(0.0f, 19.0f, 8.0f, -0.34906584f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(8, 15).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation(3.0f, 17.0f, -1.0f, -0.17453292f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(0, 15).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.offsetAndRotation(-3.0f, 17.0f, -1.0f, -0.17453292f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-2.5f, -4.0f, -5.0f, 5.0f, 4.0f, 5.0f), PartPose.offset(0.0f, 16.0f, -1.0f));
        partdefinition.addOrReplaceChild("right_ear", CubeListBuilder.create().texOffs(52, 0).addBox(-2.5f, -9.0f, -1.0f, 2.0f, 5.0f, 1.0f), PartPose.offsetAndRotation(0.0f, 16.0f, -1.0f, 0.0f, -0.2617994f, 0.0f));
        partdefinition.addOrReplaceChild("left_ear", CubeListBuilder.create().texOffs(58, 0).addBox(0.5f, -9.0f, -1.0f, 2.0f, 5.0f, 1.0f), PartPose.offsetAndRotation(0.0f, 16.0f, -1.0f, 0.0f, 0.2617994f, 0.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(52, 6).addBox(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 2.0f), PartPose.offsetAndRotation(0.0f, 20.0f, 7.0f, -0.3490659f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(32, 9).addBox(-0.5f, -2.5f, -5.5f, 1.0f, 1.0f, 1.0f), PartPose.offset(0.0f, 16.0f, -1.0f));
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        if (this.young) {
            float f = 1.5f;
            pPoseStack.pushPose();
            pPoseStack.scale(0.56666666f, 0.56666666f, 0.56666666f);
            pPoseStack.translate(0.0, 1.375, 0.125);
            ImmutableList.of((Object)this.head, (Object)this.leftEar, (Object)this.rightEar, (Object)this.nose).forEach(p_103597_ -> p_103597_.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
            pPoseStack.popPose();
            pPoseStack.pushPose();
            pPoseStack.scale(0.4f, 0.4f, 0.4f);
            pPoseStack.translate(0.0, 2.25, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.tail).forEach(p_103587_ -> p_103587_.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
            pPoseStack.popPose();
        } else {
            pPoseStack.pushPose();
            pPoseStack.scale(0.6f, 0.6f, 0.6f);
            pPoseStack.translate(0.0, 1.0, 0.0);
            ImmutableList.of((Object)this.leftRearFoot, (Object)this.rightRearFoot, (Object)this.leftHaunch, (Object)this.rightHaunch, (Object)this.body, (Object)this.leftFrontLeg, (Object)this.rightFrontLeg, (Object)this.head, (Object)this.rightEar, (Object)this.leftEar, (Object)this.tail, (Object)this.nose, (Object[])new ModelPart[0]).forEach(p_103572_ -> p_103572_.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pRed, pGreen, pBlue, pAlpha));
            pPoseStack.popPose();
        }
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = pAgeInTicks - (float)((Rabbit)pEntity).tickCount;
        this.nose.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.rightEar.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.leftEar.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.nose.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        this.rightEar.yRot = this.nose.yRot - 0.2617994f;
        this.leftEar.yRot = this.nose.yRot + 0.2617994f;
        this.jumpRotation = Mth.sin(((Rabbit)pEntity).getJumpCompletion(f) * (float)Math.PI);
        this.leftHaunch.xRot = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.rightHaunch.xRot = (this.jumpRotation * 50.0f - 21.0f) * ((float)Math.PI / 180);
        this.leftRearFoot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.rightRearFoot.xRot = this.jumpRotation * 50.0f * ((float)Math.PI / 180);
        this.leftFrontLeg.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
        this.rightFrontLeg.xRot = (this.jumpRotation * -40.0f - 11.0f) * ((float)Math.PI / 180);
    }

    @Override
    public void prepareMobModel(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        this.jumpRotation = Mth.sin(((Rabbit)pEntity).getJumpCompletion(pPartialTick) * (float)Math.PI);
    }
}

