/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.monster.Ravager;

public class RavagerModel
extends HierarchicalModel<Ravager> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart mouth;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart neck;

    public RavagerModel(ModelPart pRoot) {
        this.root = pRoot;
        this.neck = pRoot.getChilds("neck");
        this.head = this.neck.getChilds("head");
        this.mouth = this.head.getChilds("mouth");
        this.rightHindLeg = pRoot.getChilds("right_hind_leg");
        this.leftHindLeg = pRoot.getChilds("left_hind_leg");
        this.rightFrontLeg = pRoot.getChilds("right_front_leg");
        this.leftFrontLeg = pRoot.getChilds("left_front_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 16;
        PartDefinition partdefinition1 = partdefinition.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(68, 73).addBox(-5.0f, -1.0f, -18.0f, 10.0f, 10.0f, 18.0f), PartPose.offset(0.0f, -7.0f, 5.5f));
        PartDefinition partdefinition2 = partdefinition1.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -20.0f, -14.0f, 16.0f, 20.0f, 16.0f).texOffs(0, 0).addBox(-2.0f, -6.0f, -18.0f, 4.0f, 8.0f, 4.0f), PartPose.offset(0.0f, 16.0f, -17.0f));
        partdefinition2.addOrReplaceChild("right_horn", CubeListBuilder.create().texOffs(74, 55).addBox(0.0f, -14.0f, -2.0f, 2.0f, 14.0f, 4.0f), PartPose.offsetAndRotation(-10.0f, -14.0f, -8.0f, 1.0995574f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild("left_horn", CubeListBuilder.create().texOffs(74, 55).mirror().addBox(0.0f, -14.0f, -2.0f, 2.0f, 14.0f, 4.0f), PartPose.offsetAndRotation(8.0f, -14.0f, -8.0f, 1.0995574f, 0.0f, 0.0f));
        partdefinition2.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(0, 36).addBox(-8.0f, 0.0f, -16.0f, 16.0f, 3.0f, 16.0f), PartPose.offset(0.0f, -2.0f, 2.0f));
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 55).addBox(-7.0f, -10.0f, -7.0f, 14.0f, 16.0f, 20.0f).texOffs(0, 91).addBox(-6.0f, 6.0f, -7.0f, 12.0f, 13.0f, 18.0f), PartPose.offsetAndRotation(0.0f, 1.0f, 2.0f, 1.5707964f, 0.0f, 0.0f));
        partdefinition.addOrReplaceChild("right_hind_leg", CubeListBuilder.create().texOffs(96, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(-8.0f, -13.0f, 18.0f));
        partdefinition.addOrReplaceChild("left_hind_leg", CubeListBuilder.create().texOffs(96, 0).mirror().addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(8.0f, -13.0f, 18.0f));
        partdefinition.addOrReplaceChild("right_front_leg", CubeListBuilder.create().texOffs(64, 0).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(-8.0f, -13.0f, -5.0f));
        partdefinition.addOrReplaceChild("left_front_leg", CubeListBuilder.create().texOffs(64, 0).mirror().addBox(-4.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f), PartPose.offset(8.0f, -13.0f, -5.0f));
        return LayerDefinition.create(meshdefinition, 128, 128);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(Ravager pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.xRot = pHeadPitch * ((float)Math.PI / 180);
        this.head.yRot = pNetHeadYaw * ((float)Math.PI / 180);
        float f = 0.4f * pLimbSwingAmount;
        this.rightHindLeg.xRot = Mth.cos(pLimbSwing * 0.6662f) * f;
        this.leftHindLeg.xRot = Mth.cos(pLimbSwing * 0.6662f + (float)Math.PI) * f;
        this.rightFrontLeg.xRot = Mth.cos(pLimbSwing * 0.6662f + (float)Math.PI) * f;
        this.leftFrontLeg.xRot = Mth.cos(pLimbSwing * 0.6662f) * f;
    }

    @Override
    public void prepareMobModel(Ravager pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        super.prepareMobModel(pEntity, pLimbSwing, pLimbSwingAmount, pPartialTick);
        int i = pEntity.getStunnedTick();
        int j = pEntity.getRoarTick();
        int k = 20;
        int l = pEntity.getAttackTick();
        int i1 = 10;
        if (l > 0) {
            float f = Mth.triangleWave((float)l - pPartialTick, 10.0f);
            float f1 = (1.0f + f) * 0.5f;
            float f2 = f1 * f1 * f1 * 12.0f;
            float f3 = f2 * Mth.sin(this.neck.xRot);
            this.neck.z = -6.5f + f2;
            this.neck.y = -7.0f - f3;
            float f4 = Mth.sin(((float)l - pPartialTick) / 10.0f * (float)Math.PI * 0.25f);
            this.mouth.xRot = 1.5707964f * f4;
            this.mouth.xRot = l > 5 ? Mth.sin(((float)(-4 + l) - pPartialTick) / 4.0f) * (float)Math.PI * 0.4f : 0.15707964f * Mth.sin((float)Math.PI * ((float)l - pPartialTick) / 10.0f);
        } else {
            float f5 = -1.0f;
            float f6 = -1.0f * Mth.sin(this.neck.xRot);
            this.neck.x = 0.0f;
            this.neck.y = -7.0f - f6;
            this.neck.z = 5.5f;
            boolean flag = i > 0;
            this.neck.xRot = flag ? 0.2199115f : 0.0f;
            this.mouth.xRot = (float)Math.PI * (flag ? 0.05f : 0.01f);
            if (flag) {
                double d0 = (double)i / 40.0;
                this.neck.x = (float)Math.sin(d0 * 10.0) * 3.0f;
            } else if (j > 0) {
                float f7 = Mth.sin(((float)(20 - j) - pPartialTick) / 20.0f * (float)Math.PI * 0.25f);
                this.mouth.xRot = 1.5707964f * f7;
            }
        }
    }
}

