/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import java.util.Arrays;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class SquidModel<T extends Entity>
extends HierarchicalModel<T> {
    private final ModelPart[] tentacles = new ModelPart[8];
    private final ModelPart root;

    public SquidModel(ModelPart pRoot) {
        this.root = pRoot;
        Arrays.setAll(this.tentacles, p_170995_ -> pRoot.getChilds(SquidModel.createTentacleName(p_170995_)));
    }

    private static String createTentacleName(int pIndex) {
        return "tentacle" + pIndex;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = -16;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-6.0f, -8.0f, -6.0f, 12.0f, 16.0f, 12.0f), PartPose.offset(0.0f, 8.0f, 0.0f));
        int j = 8;
        CubeListBuilder cubelistbuilder = CubeListBuilder.create().texOffs(48, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 18.0f, 2.0f);
        int k = 0;
        while (k < 8) {
            double d0 = (double)k * Math.PI * 2.0 / 8.0;
            float f = (float)Math.cos(d0) * 5.0f;
            float f1 = 15.0f;
            float f2 = (float)Math.sin(d0) * 5.0f;
            d0 = (double)k * Math.PI * -2.0 / 8.0 + 1.5707963267948966;
            float f3 = (float)d0;
            partdefinition.addOrReplaceChild(SquidModel.createTentacleName(k), cubelistbuilder, PartPose.offsetAndRotation(f, 15.0f, f2, 0.0f, f3, 0.0f));
            ++k;
        }
        return LayerDefinition.create(meshdefinition, 64, 32);
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        ModelPart[] modelPartArray = this.tentacles;
        int n = this.tentacles.length;
        int n2 = 0;
        while (n2 < n) {
            ModelPart modelpart = modelPartArray[n2];
            modelpart.xRot = pAgeInTicks;
            ++n2;
        }
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

