/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import net.minecraft.client.model.ColorableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class TropicalFishModelA<T extends Entity>
extends ColorableHierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart tail;

    public TropicalFishModelA(ModelPart pRoot) {
        this.root = pRoot;
        this.tail = pRoot.getChilds("tail");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation pCubeDeformation) {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        int i = 22;
        partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.5f, -3.0f, 2.0f, 3.0f, 6.0f, pCubeDeformation), PartPose.offset(0.0f, 22.0f, 0.0f));
        partdefinition.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(22, -6).addBox(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 6.0f, pCubeDeformation), PartPose.offset(0.0f, 22.0f, 3.0f));
        partdefinition.addOrReplaceChild("right_fin", CubeListBuilder.create().texOffs(2, 16).addBox(-2.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, pCubeDeformation), PartPose.offsetAndRotation(-1.0f, 22.5f, 0.0f, 0.0f, 0.7853982f, 0.0f));
        partdefinition.addOrReplaceChild("left_fin", CubeListBuilder.create().texOffs(2, 12).addBox(0.0f, -1.0f, 0.0f, 2.0f, 2.0f, 0.0f, pCubeDeformation), PartPose.offsetAndRotation(1.0f, 22.5f, 0.0f, 0.0f, -0.7853982f, 0.0f));
        partdefinition.addOrReplaceChild("top_fin", CubeListBuilder.create().texOffs(10, -5).addBox(0.0f, -3.0f, 0.0f, 0.0f, 3.0f, 6.0f, pCubeDeformation), PartPose.offset(0.0f, 20.5f, -3.0f));
        return LayerDefinition.create(meshdefinition, 32, 32);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }

    @Override
    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        float f = 1.0f;
        if (!((Entity)pEntity).isInWater()) {
            f = 1.5f;
        }
        this.tail.yRot = -f * 0.45f * Mth.sin(0.6f * pAgeInTicks);
    }
}

