/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model.geom.builders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDefinition;
import net.minecraft.client.model.geom.builders.CubeListBuilder;

public class PartDefinition {
    private final List<CubeDefinition> cubes;
    private final PartPose partPose;
    private final Map<String, PartDefinition> children = Maps.newHashMap();

    PartDefinition(List<CubeDefinition> pCubes, PartPose pPartPose) {
        this.cubes = pCubes;
        this.partPose = pPartPose;
    }

    public PartDefinition addOrReplaceChild(String pName, CubeListBuilder pCubes, PartPose pPartPose) {
        PartDefinition partdefinition = new PartDefinition(pCubes.getCubes(), pPartPose);
        PartDefinition partdefinition1 = this.children.put(pName, partdefinition);
        if (partdefinition1 != null) {
            partdefinition.children.putAll(partdefinition1.children);
        }
        return partdefinition;
    }

    public ModelPart bake(int pTexWidth, int pTexHeight) {
        Object2ObjectArrayMap object2objectarraymap = this.children.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p_171593_ -> ((PartDefinition)p_171593_.getValue()).bake(pTexWidth, pTexHeight), (p_171595_, p_171596_) -> p_171595_, Object2ObjectArrayMap::new));
        List list = (List)this.cubes.stream().map(p_171589_ -> p_171589_.bake(pTexWidth, pTexHeight)).collect(ImmutableList.toImmutableList());
        ModelPart modelpart = new ModelPart(list, (Map<String, ModelPart>)object2objectarraymap);
        modelpart.loadPose(this.partPose);
        return modelpart;
    }

    public PartDefinition getChild(String pName) {
        return this.children.get(pName);
    }
}

