/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementList;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.AdvancementToast;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundUpdateAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class ClientAdvancements {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Minecraft minecraft;
    private final AdvancementList advancements = new AdvancementList();
    private final Map<Advancement, AdvancementProgress> progress = Maps.newHashMap();
    @Nullable
    private Listener listener;
    @Nullable
    private Advancement selectedTab;

    public ClientAdvancements(Minecraft pMinecraft) {
        this.minecraft = pMinecraft;
    }

    public void update(ClientboundUpdateAdvancementsPacket pPacket) {
        if (pPacket.shouldReset()) {
            this.advancements.clear();
            this.progress.clear();
        }
        this.advancements.remove(pPacket.getRemoved());
        this.advancements.add(pPacket.getAdded());
        for (Map.Entry<ResourceLocation, AdvancementProgress> entry : pPacket.getProgress().entrySet()) {
            Advancement advancement = this.advancements.get(entry.getKey());
            if (advancement != null) {
                AdvancementProgress advancementprogress = entry.getValue();
                advancementprogress.a(advancement.getCriteria(), advancement.getRequirements());
                this.progress.put(advancement, advancementprogress);
                if (this.listener != null) {
                    this.listener.onUpdateAdvancementProgress(advancement, advancementprogress);
                }
                if (pPacket.shouldReset() || !advancementprogress.isDone() || advancement.getDisplay() == null || !advancement.getDisplay().shouldShowToast()) continue;
                this.minecraft.getToasts().addToast(new AdvancementToast(advancement));
                continue;
            }
            LOGGER.warn("Server informed client about progress for unknown advancement {}", (Object)entry.getKey());
        }
    }

    public AdvancementList getAdvancements() {
        return this.advancements;
    }

    public void setSelectedTab(@Nullable Advancement pAdvancement, boolean pTellServer) {
        ClientPacketListener clientpacketlistener = this.minecraft.getConnection();
        if (clientpacketlistener != null && pAdvancement != null && pTellServer) {
            clientpacketlistener.send(ServerboundSeenAdvancementsPacket.openedTab(pAdvancement));
        }
        if (this.selectedTab != pAdvancement) {
            this.selectedTab = pAdvancement;
            if (this.listener != null) {
                this.listener.onSelectedTabChanged(pAdvancement);
            }
        }
    }

    public void setListener(@Nullable Listener pListener) {
        this.listener = pListener;
        this.advancements.setListener(pListener);
        if (pListener != null) {
            for (Map.Entry<Advancement, AdvancementProgress> entry : this.progress.entrySet()) {
                pListener.onUpdateAdvancementProgress(entry.getKey(), entry.getValue());
            }
            pListener.onSelectedTabChanged(this.selectedTab);
        }
    }

    public static interface Listener
    extends AdvancementList.Listener {
        public void onUpdateAdvancementProgress(Advancement var1, AdvancementProgress var2);

        public void onSelectedTabChanged(@Nullable Advancement var1);
    }
}

